/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.admin.useradmin.login;

import au.com.ordermate.gui.GraphPaperLayout;
import au.com.ordermate.persistence.Displayable;
import au.com.ordermate.util.image.IconLoader;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import ordermate.database.users.User;
import ordermate.database.users.UserFingerprint;
import ordermate.gui.scroll.CustomScrollPane;
import ordermate.gui.scroll.CustomScrollPaneModel;
import ordermate.gui.scroll.DataScrollPaneModel;
import ordermate.gui.themes.OrderMateTheme;
import ordermate.internationalization.Internationalization;
import ordermate.signals.Signal;
import ordermate.signals.Signals;

public class UserLoginSetupPanel
extends JPanel {
    private JPanel gui;
    private JLabel proximityLabel;
    private JLabel swipecardLabel;
    private JLabel pinLabel;
    private JLabel fingerprintLabel;
    private DataScrollPaneModel userModel;
    public final Signal<User, ?, ?, ?, ?> userSelected = Signals.createSignal(User.class, (String)"user");
    public final Signal changePIN = Signals.createSignal();
    public final Signal enrolFingerprint = Signals.createSignal();

    public UserLoginSetupPanel() {
        this.setLayout((LayoutManager)new GraphPaperLayout(new Dimension(1, 1)));
        this.userModel = new DataScrollPaneModel(1, 8);
        this.gui = this.createInterface();
        this.add((Component)this.gui, new Rectangle(0, 0, 1, 1));
    }

    protected JPanel createInterface() {
        JPanel panel = new JPanel((LayoutManager)new GraphPaperLayout(new Dimension(4, 1)));
        CustomScrollPane userSelectionPane = new CustomScrollPane((CustomScrollPaneModel)this.userModel);
        this.userModel.objectSelected.connect((Object)this, "gotObjectSelected");
        panel.add((Component)userSelectionPane, new Rectangle(0, 0, 1, 1));
        panel.add((Component)this.createSetupDetailPane(), new Rectangle(1, 0, 3, 1));
        return panel;
    }

    protected JPanel createSetupDetailPane() {
        JPanel detailPanel = new JPanel((LayoutManager)new GraphPaperLayout(1, 4));
        JPanel swipecardPanel = new JPanel((LayoutManager)new GraphPaperLayout(new Dimension(10, 4)));
        swipecardPanel.setBorder(new TitledBorder(Internationalization.getLiteralFor((String)"SWIPECARD_ID")));
        this.swipecardLabel = new JLabel(Internationalization.getLiteralFor((String)"AWAITING_SCAN"));
        this.swipecardLabel.setFont(OrderMateTheme.getLargeFont());
        swipecardPanel.add((Component)this.swipecardLabel, new Rectangle(3, 1, 6, 1));
        JPanel proximityPanel = new JPanel((LayoutManager)new GraphPaperLayout(new Dimension(10, 4)));
        proximityPanel.setBorder(new TitledBorder(Internationalization.getLiteralFor((String)"PROXIMITY_BAND_ID")));
        this.proximityLabel = new JLabel(Internationalization.getLiteralFor((String)"AWAITING_SCAN"));
        this.proximityLabel.setFont(OrderMateTheme.getLargeFont());
        proximityPanel.add((Component)this.proximityLabel, new Rectangle(3, 1, 6, 1));
        JPanel pinPanel = new JPanel((LayoutManager)new GraphPaperLayout(new Dimension(10, 4)));
        pinPanel.setBorder(new TitledBorder(Internationalization.getLiteralFor((String)"PIN_NUMBER")));
        this.pinLabel = new JLabel("");
        this.pinLabel.setFont(OrderMateTheme.getLargeFont());
        pinPanel.add((Component)this.pinLabel, new Rectangle(3, 1, 6, 1));
        JButton newPinButton = new JButton(Internationalization.getLiteralFor((String)"CHANGE_PIN"));
        newPinButton.setIcon(IconLoader.get((String)"/waitermate/images/key_small.png"));
        newPinButton.setHorizontalTextPosition(0);
        newPinButton.setVerticalTextPosition(3);
        newPinButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UserLoginSetupPanel.this.changePIN.emit();
            }
        });
        pinPanel.add((Component)newPinButton, new Rectangle(8, 0, 2, 4));
        JButton fingerprintButton = new JButton(Internationalization.getLiteralFor((String)"ENROL_FINGERPRINT"));
        fingerprintButton.setIcon(IconLoader.get((String)"/waitermate/images/fingerprint.png"));
        fingerprintButton.setHorizontalTextPosition(0);
        fingerprintButton.setVerticalTextPosition(3);
        fingerprintButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UserLoginSetupPanel.this.enrolFingerprint.emit();
            }
        });
        JPanel fingerprintPanel = new JPanel((LayoutManager)new GraphPaperLayout(10, 5));
        this.fingerprintLabel = new JLabel(Internationalization.getLiteralFor((String)"NO_PRINTS"));
        this.fingerprintLabel.setFont(OrderMateTheme.getLargeFont());
        fingerprintPanel.setBorder(new TitledBorder(Internationalization.getLiteralFor((String)"FINGERPRINTS")));
        fingerprintPanel.add((Component)this.fingerprintLabel, new Rectangle(3, 1, 6, 1));
        fingerprintPanel.add((Component)fingerprintButton, new Rectangle(8, 0, 2, 5));
        detailPanel.add((Component)swipecardPanel, new Rectangle(0, 0, 1, 1));
        detailPanel.add((Component)proximityPanel, new Rectangle(0, 1, 1, 1));
        detailPanel.add((Component)pinPanel, new Rectangle(0, 2, 1, 1));
        detailPanel.add((Component)fingerprintPanel, new Rectangle(0, 3, 1, 1));
        return detailPanel;
    }

    public void setUsers(List<User> users) {
        this.userModel.setItems(users, true, true);
    }

    public void setProximityBand(String data) {
        this.proximityLabel.setText(data);
    }

    public void setSwipeCard(String data) {
        this.swipecardLabel.setText(data);
    }

    public void setPinNumber(String data) {
        if (data != null && !data.isEmpty()) {
            char[] disguisedPIN = new char[data.length()];
            for (int i = 0; i < disguisedPIN.length; ++i) {
                disguisedPIN[i] = 42;
            }
            this.pinLabel.setText(new String(disguisedPIN));
        } else {
            this.pinLabel.setText("");
        }
    }

    public void gotObjectSelected(Displayable user) {
        User selectedUser = (User)user;
        this.userSelected.emit((Object)selectedUser);
    }

    public void selectUser(final User user) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                UserLoginSetupPanel.this.userModel.selectButton((Displayable)user);
            }
        });
    }

    public void setPrints(List<UserFingerprint> prints) {
        if (prints == null || prints.isEmpty()) {
            this.fingerprintLabel.setText(Internationalization.getLiteralFor((String)"NO_PRINTS_ENROLED"));
        } else {
            this.fingerprintLabel.setText(Internationalization.getLiteralFor((String)"PRINTS_ENROLED"));
        }
    }
}

