/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.admin.vouchers;

import au.com.ordermate.gui.GraphPaperLayout;
import au.com.ordermate.guicore.Refreshable;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.search.IRangedSearchFilter;
import au.com.ordermate.search.SearchFilterI;
import au.com.ordermate.search.control.RefreshAction;
import au.com.ordermate.search.filter.BooleanSearchFilter;
import au.com.ordermate.search.searchfield.java.SearchGuiField;
import au.com.ordermate.search.searchfield.java.SearchGuiFieldWrapper;
import au.com.ordermate.util.image.IconLoader;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import ordermate.database.finance.giftvoucher.GiftVoucher;
import ordermate.database.finance.giftvoucher.GiftVoucherTransaction;
import ordermate.database.searchers.reports.vouchers.VoucherTransactionSearcher;
import ordermate.gui.themes.OrderMateTheme;
import ordermate.internationalization.Internationalization;
import waitermate.gui.screens.ordering.giftvoucher.VoucherGrabber;
import waitermate.gui.screens.search.AbstractWaitermateSearchPanel;
import waitermate.gui.screens.search.FieldPanel;
import waitermate.guikit.search.searchfield.WaitermateDateRangePanel;
import waitermate.guikit.search.searchfield.WaitermateDateRangeSearchField;

class VoucherSearchPanel
extends AbstractWaitermateSearchPanel
implements ActionListener,
Refreshable {
    private JButton voucherIDButton;
    private JCheckBox hideZeroCheck;
    private JButton clearButton;
    private WaitermateDateRangePanel activeDateRange;
    private VoucherTransactionSearcher voucherSearcher;
    private List<SearchGuiField> allFields;
    private GiftVoucher voucher;
    private RefreshAction refresh;

    @Override
    protected void setupComponents() {
        this.refresh = new RefreshAction((Refreshable)this);
        this.allFields = new ArrayList<SearchGuiField>();
        this.createSearcher();
        this.voucherIDButton = new JButton();
        this.voucherIDButton.setName("VOUCHER_ID");
        this.voucherIDButton.addActionListener(this);
        this.hideZeroCheck = new JCheckBox();
        this.hideZeroCheck.setFont(OrderMateTheme.getMediumFont());
        this.hideZeroCheck.addActionListener(this);
        this.hideZeroCheck.setName("hideZero");
        SearchGuiField voucherIdSearchGui = this.createSearchGuiField(this.voucherIDButton, GiftVoucher.Properties.UNIQUE_ID);
        SearchGuiFieldWrapper hideZeroDollarField = new SearchGuiFieldWrapper(Internationalization.getLiteralFor((String)"HIDE_ZERO_DOLLAR"), (Action)this.refresh, (JComponent)this.hideZeroCheck, (SearchFilterI)new BooleanSearchFilter(null));
        this.setupClearButton();
        this.setLayout((LayoutManager)new GraphPaperLayout(3, 6));
        this.addSearchGuiField(Internationalization.getLiteralFor((String)"VOUCHER_ID"), voucherIdSearchGui, new Rectangle(0, 0, 2, 1));
        this.addSearchGuiField(Internationalization.getLiteralFor((String)"LAST_ACTIVE_BETWEEN"), (SearchGuiField)this.setupDateRangeSearchField(), new Rectangle(0, 1, 2, 1));
        this.addSearchGuiField(Internationalization.getLiteralFor((String)"HIDE_ZERO_DOLLAR"), (SearchGuiField)hideZeroDollarField, new Rectangle(0, 2, 2, 1));
        this.setupFooterPanel();
    }

    private WaitermateDateRangeSearchField setupDateRangeSearchField() {
        this.activeDateRange = new WaitermateDateRangePanel(Calendar.getInstance(), Calendar.getInstance(), "", "", this.refresh);
        WaitermateDateRangeSearchField dateField = new WaitermateDateRangeSearchField(Internationalization.getLiteralFor((String)"LAST_ACTIVE_BETWEEN"), (IRangedSearchFilter)this.voucherSearcher.getCreatedDayRangeFilter(), null, (Action)this.refresh, this.activeDateRange);
        return dateField;
    }

    private void setupClearButton() {
        this.clearButton = new JButton();
        OrderMateTheme.setupNavBarButton((AbstractButton)this.clearButton);
        this.clearButton.setText(Internationalization.getLiteralFor((String)"CLEAR_SEARCH"));
        this.clearButton.setIcon(IconLoader.get((String)"/waitermate/guikit/images/clear.png"));
        this.clearButton.addActionListener(this);
    }

    private void setupFooterPanel() {
        JPanel footerSearchPanel = new JPanel();
        footerSearchPanel.setLayout(new BoxLayout(footerSearchPanel, 0));
        footerSearchPanel.add(this.clearButton);
        this.add((Component)footerSearchPanel, new Rectangle(0, 5, 1, 1));
    }

    protected void addSearchGuiField(String label, SearchGuiField guiField, Rectangle position) {
        this.allFields.add(guiField);
        this.add((Component)new FieldPanel(label, guiField.getGuiComponent(), 1), position);
    }

    private SearchGuiField createSearchGuiField(final JComponent component, PropertiedObject.Property prop) {
        return new SearchGuiField(component.getName(), null){

            public void reset() {
                VoucherSearchPanel.this.voucherSearcher.getUuidPrefixFilter().clearSearch();
            }

            public SearchFilterI getSearchProperty() {
                VoucherSearchPanel.this.voucherSearcher.getUuidPrefixFilter().setSearchValue((Object)VoucherSearchPanel.this.voucherIDButton.getText());
                return VoucherSearchPanel.this.voucherSearcher.getUuidPrefixFilter();
            }

            public void setVisible(boolean flag) {
            }

            public boolean isVisible() {
                return true;
            }

            public void setEnabled(boolean flag) {
            }

            public boolean isEnabled() {
                return true;
            }

            public Component getGuiComponent() {
                return component;
            }

            public void addAction(Action action) {
            }
        };
    }

    private void createSearcher() {
        this.voucherSearcher = new VoucherTransactionSearcher();
        this.voucherSearcher.setGroupByProperty(GiftVoucherTransaction.Properties.GIFT_VOUCHER);
        this.voucherSearcher.setLimit(20);
    }

    public VoucherTransactionSearcher getSearcher() {
        return this.voucherSearcher;
    }

    @Override
    public void reset() {
        this.voucherIDButton.setText("");
        this.hideZeroCheck.setSelected(true);
        this.activeDateRange.setDates(Calendar.getInstance(), Calendar.getInstance());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() {
        List<SearchGuiField> list = this.allFields;
        synchronized (list) {
            for (SearchGuiField element : this.allFields) {
                SearchGuiField searchField = element;
                if (!searchField.getGuiComponent().isEnabled() || !searchField.getSearchProperty().hasSearchValue()) continue;
                this.getSearcher().addSearchFilter(searchField.getSearchProperty());
            }
        }
        this.emitChange();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.voucherIDButton) {
            VoucherGrabber voucherGrabber = new VoucherGrabber(false);
            this.voucher = voucherGrabber.start();
            if (this.voucher != null) {
                this.voucherIDButton.setText(this.voucher.getUniqueId());
            } else {
                this.voucherIDButton.setText(voucherGrabber.getScannedString());
            }
            this.refresh();
        } else if (source == this.hideZeroCheck) {
            this.voucherSearcher.setHideZeroDollarFilter(this.hideZeroCheck.isSelected() ? Boolean.TRUE : null);
            this.refresh();
        } else if (source == this.clearButton) {
            this.clearSearch.emit();
            return;
        }
        this.emitChange();
    }

    public void emitChange() {
        this.propertyChanged.emit();
    }
}

