/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.admin.wastage;

import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import ordermate.database.sales.Account;
import ordermate.database.stock.usage.StockWastage;
import ordermate.gui.themes.OrderMateTheme;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import waitermate.gui.displayitems.stockitems.StockItemSearchPanel;
import waitermate.gui.screens.admin.AbstractAdminScreen;
import waitermate.gui.screens.admin.wastage.WasteMenuItemsScreen;
import waitermate.gui.screens.admin.wastage.WasteStockItemsPanel;
import waitermate.gui.screens.admin.wastage.WasteStockItemsScreen;

public class WastageTabbedPanel
extends JTabbedPane {
    public final Signal back = Signals.createSignal();
    public final Signal rootDisplay = Signals.createSignal();
    WasteMenuItemsScreen wasteMenuScr;
    WasteStockItemsScreen wasteStockScr;
    private final List<AbstractAdminScreen> panels = new ArrayList<AbstractAdminScreen>();
    StockItemSearchPanel stockSearchGui;

    WastageTabbedPanel() {
        OrderMateTheme.setupTabbedPane((JTabbedPane)this);
        this.setFont(OrderMateTheme.getLargeFont());
        this.wasteMenuScr = new WasteMenuItemsScreen();
        this.wasteMenuScr.rootDisplay.connect(this.rootDisplay);
        this.panels.add(this.wasteMenuScr);
        this.wasteStockScr = new WasteStockItemsScreen();
        this.stockSearchGui = this.wasteStockScr.getStockItemSearchdGui();
        this.stockSearchGui.startSearch(null, false);
        this.panels.add(this.wasteStockScr);
        for (AbstractAdminScreen panel : this.panels) {
            this.addTab(panel);
        }
    }

    private void addTab(AbstractAdminScreen adminScreen) {
        adminScreen.back.connect(this.back);
        JComponent gui = adminScreen.getMainArea();
        this.addTab(adminScreen.getCategoryName(), gui);
    }

    void startTabs() {
        for (AbstractAdminScreen pan : this.panels) {
            pan.display();
        }
    }

    public void resetAccounts() {
        this.wasteMenuScr.clearAccount();
    }

    public void setAccount(Account psuedoAccount) {
        this.wasteMenuScr.setAccount(psuedoAccount);
    }

    public List<StockWastage> getWastageList() {
        return this.wasteStockScr.getWastageList();
    }

    public void clearWastageList() {
        this.wasteStockScr.gotClear();
    }

    public void invalidatGUI() {
        ((WasteStockItemsPanel)((Object)this.wasteStockScr.getMainArea())).clearBufferedImage();
        this.wasteStockScr.invalidatePanel();
        this.stockSearchGui.invalidate();
        this.stockSearchGui.startSearch(null, false);
    }

    public void setStockItemWastageScreenImage() {
        ((WasteStockItemsPanel)((Object)this.wasteStockScr.getMainArea())).createBufferedImage();
    }
}

