/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.admin.wastage;

import au.com.ordermate.gui.GraphPaperLayout;
import au.com.ordermate.guicore.NameDecorator;
import au.com.ordermate.units.SalesQuantity;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import javax.swing.JComponent;
import ordermate.database.hardware.Terminal;
import ordermate.database.inventory.InventoryGroup;
import ordermate.database.inventory.InventoryItem;
import ordermate.database.inventory.combos.InventoryCombo;
import ordermate.database.inventory.triggers.activation.TriggerActivationContext;
import ordermate.database.sales.Account;
import ordermate.database.sales.ItemGroup;
import ordermate.database.sales.Sellable;
import ordermate.database.sales.SellableWrapperFactory;
import ordermate.gui.scroll.CustomScrollPane;
import ordermate.gui.scroll.CustomScrollPaneModel;
import ordermate.gui.scroll.Renderer;
import ordermate.gui.scroll.RendererScrollPaneModel;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import waitermate.LoginManager;
import waitermate.gui.displayitems.SelectItemButtonRenderer;
import waitermate.gui.displayitems.accountitems.SingleScreenItemRenderer;
import waitermate.gui.screens.admin.AbstractAdminPanel;
import waitermate.gui.screens.ordering.additems.selectitem.AbstractMenuItemSelectionPanel;
import waitermate.gui.screens.ordering.additems.selectitem.MultipleMenuItemSelectionPanel;

public class WasteMenuItemsPanel
extends AbstractAdminPanel {
    private Account psuedoAccount = null;
    public final Signal<InventoryGroup, ?, ?, ?, ?> groupSelected = Signals.createSignal(InventoryGroup.class, (String)"group");
    public final Signal<Sellable, ?, ?, ?, ?> item = Signals.createSignal(Sellable.class, (String)"selectedItem");
    public final Signal<InventoryItem, ?, ?, ?, ?> newItem = Signals.createSignal(InventoryItem.class, (String)"newItem");
    public final Signal<InventoryCombo, ?, ?, ?, ?> newCombo = Signals.createSignal(InventoryCombo.class, (String)"newCombo");
    public final Signal<Sellable, ?, ?, ?, ?> quantity = Signals.createSignal(Sellable.class, (String)"selectedItem");
    public final Signal<Sellable, ?, ?, ?, ?> delete = Signals.createSignal(Sellable.class, (String)"selectedItem");
    public final Signal<Sellable, ?, ?, ?, ?> upgrade = Signals.createSignal(Sellable.class, (String)"selectedItme");
    public final Signal clearTendered = Signals.createSignal();
    private final RendererScrollPaneModel items;
    private final CustomScrollPane itemsPane;
    private final AbstractMenuItemSelectionPanel groups;
    private SellableWrapperFactory sellableFactory;

    public WasteMenuItemsPanel() {
        int menuWidth = 65;
        SingleScreenItemRenderer renderer = new SingleScreenItemRenderer();
        this.sellableFactory = new SellableWrapperFactory();
        int size = 11;
        this.setLayout((LayoutManager)new GraphPaperLayout(new Dimension(100, size)));
        this.items = new RendererScrollPaneModel((Renderer)renderer, 1, 6);
        this.itemsPane = new CustomScrollPane((CustomScrollPaneModel)this.items);
        this.itemsPane.setEmptyMessage("Select a menu group to begin ordering");
        boolean tabbedMenuOrdering = false;
        boolean showQuantity = true;
        this.groups = new MultipleMenuItemSelectionPanel(new SelectItemButtonRenderer(showQuantity), tabbedMenuOrdering);
        this.add((Component)new NameDecorator((JComponent)this.groups, "ItemScreen"), new Rectangle(0, 0, menuWidth, 11));
        this.groups.setNumKeypadVisible(Terminal.getLocalHost().getQuickSaleQtyKeyPad());
        this.add((Component)new NameDecorator((JComponent)this.itemsPane, "fastBarItemsPane"), new Rectangle(menuWidth, 0, 100 - menuWidth, 11));
        this.groups.itemSelected.connect((Object)this, "gotNewItem");
        this.groups.comboSelected.connect((Object)this, "gotNewCombo");
        renderer.item.connect((Object)this, "gotItem");
        renderer.quantity.connect((Object)this, "gotQuantity");
        renderer.delete.connect((Object)this, "gotDelete");
        renderer.upgrade.connect((Object)this, "gotUpgrade");
    }

    @Override
    protected void start() {
        this.newAccount(this.psuedoAccount);
    }

    public void newAccount(Account account) {
        this.setAccount(account);
        TriggerActivationContext context = new TriggerActivationContext(LoginManager.getEventContext(), new Date(), (ItemGroup)account);
        if (this.groups.getInventoryGroup() == null) {
            this.groups.showRootGroup(context, Collections.EMPTY_LIST, null);
        } else if (this.groups.getInventoryGroup() != null) {
            this.groups.showGroup(context, this.groups.getInventoryGroup(), Collections.EMPTY_LIST, null);
        }
        this.items.setObjects(new ArrayList(0));
    }

    void showAccount(Account account) {
        this.setAccount(account);
        TriggerActivationContext context = new TriggerActivationContext(LoginManager.getEventContext(), new Date(), (ItemGroup)account);
        if (this.groups.getInventoryGroup() != null) {
            this.groups.showGroup(context, this.groups.getInventoryGroup(), account.getItems(), Collections.EMPTY_LIST);
        } else if (account.getAllItems().size() > 0) {
            this.groups.showRootGroup(context, account.getItems(), null);
        }
        this.items.setObjects(this.sellableFactory.getSellables((ItemGroup)account));
    }

    void gotGroup(InventoryGroup theGroup) {
        this.groupSelected.emit((Object)theGroup);
    }

    void gotItem(Sellable theItem) {
        this.item.emit((Object)theItem);
    }

    void gotNewCombo(InventoryCombo theNewCombo) {
        this.newCombo.emit((Object)theNewCombo);
    }

    void gotNewItem(InventoryItem theNewItem) {
        this.newItem.emit((Object)theNewItem);
    }

    void gotQuantity(Sellable theItem) {
        this.quantity.emit((Object)theItem);
    }

    void gotDelete(Sellable theItem) {
        this.delete.emit((Object)theItem);
    }

    void gotUpgrade(Sellable theItem) {
        this.upgrade.emit((Object)theItem);
    }

    public void setAccount(Account newAccount) {
        this.psuedoAccount = newAccount;
    }

    public Account getAccount() {
        return this.psuedoAccount;
    }

    public SalesQuantity getKeyPadQuantity() {
        if (!Terminal.getLocalHost().getQuickSaleSingleScreenOrdering()) {
            return SalesQuantity.ONE;
        }
        return this.groups.getQuantity();
    }

    public boolean getIncrementQuantityFlag() {
        if (!Terminal.getLocalHost().getQuickSaleSingleScreenOrdering()) {
            return true;
        }
        return this.groups.getFirstPressQuantityFlag();
    }

    void showLastPage() {
        this.itemsPane.displayLastPage();
    }
}

