/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.admin.wastage;

import au.com.ordermate.gui.GraphPaperLayout;
import au.com.ordermate.guicore.NameDecorator;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.List;
import javax.swing.JComponent;
import ordermate.database.searchers.stock.StockItemSearcher;
import ordermate.database.stock.StockItem;
import ordermate.database.stock.usage.StockWastage;
import ordermate.gui.scroll.CustomScrollPane;
import ordermate.gui.scroll.CustomScrollPaneModel;
import ordermate.gui.scroll.Renderer;
import ordermate.gui.scroll.RendererScrollPaneModel;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import waitermate.gui.displayitems.stockitems.StockItemSearchPanel;
import waitermate.gui.displayitems.stockwastage.DefaultStockWastageRenderer;
import waitermate.gui.screens.admin.AbstractAdminPanel;

public class WasteStockItemsPanel
extends AbstractAdminPanel {
    public final Signal<StockItem, ?, ?, ?, ?> newItem = Signals.createSignal(StockItem.class, (String)"newItem");
    public final Signal<StockWastage, ?, ?, ?, ?> item = Signals.createSignal(StockWastage.class, (String)"selectedStockWastage");
    public final Signal<StockWastage, ?, ?, ?, ?> delete = Signals.createSignal(StockWastage.class, (String)"selectedStockWastage");
    public final Signal clearTendered = Signals.createSignal();
    private final RendererScrollPaneModel items;
    private final CustomScrollPane itemsPane;
    private StockItemSearchPanel stockItemSearchGui;
    private BufferedImage bufferedImage = null;

    public WasteStockItemsPanel() {
        int keyboardWidth = 75;
        DefaultStockWastageRenderer renderer = new DefaultStockWastageRenderer();
        int size = 11;
        this.setLayout((LayoutManager)new GraphPaperLayout(new Dimension(100, size)));
        this.items = new RendererScrollPaneModel((Renderer)renderer, 1, 6);
        this.itemsPane = new CustomScrollPane((CustomScrollPaneModel)this.items);
        this.itemsPane.setEmptyMessage("Search a stock item that was wasted");
        this.stockItemSearchGui = new StockItemSearchPanel(new StockItemSearcher(), false);
        this.stockItemSearchGui.itemSelected.connect((Object)this, "gotNewItem");
        this.stockItemSearchGui.startSearch(null, false);
        this.add((Component)new NameDecorator((JComponent)this.itemsPane, "fastBarStockItemsPane"), new Rectangle(keyboardWidth, 0, 100 - keyboardWidth, 11));
        this.add((Component)new NameDecorator((JComponent)this.stockItemSearchGui, "searchGui"), new Rectangle(0, 0, keyboardWidth, 11));
        renderer.item.connect((Object)this, "gotItem");
        renderer.delete.connect((Object)this, "gotDelete");
    }

    public void startSearch() {
        this.stockItemSearchGui.startSearch(null, false);
    }

    void showLinks(List<StockWastage> links) {
        this.items.setObjects(links);
    }

    void gotNewItem(StockItem theNewItem) {
        this.newItem.emit((Object)theNewItem);
    }

    void gotItem(StockWastage theItem) {
        this.item.emit((Object)theItem);
    }

    void gotDelete(StockWastage theItem) {
        this.delete.emit((Object)theItem);
    }

    public StockItemSearchPanel getStockItemSearchdGui() {
        return this.stockItemSearchGui;
    }

    public void retrieveKeyboard() {
        this.stockItemSearchGui.getKeyboard().ancestorAdded(null);
    }

    public void createBufferedImage() {
        WasteStockItemsPanel panelToRender = this;
        int w = ((JComponent)((Object)panelToRender)).getWidth();
        int h = ((JComponent)((Object)panelToRender)).getHeight();
        BufferedImage bi = new BufferedImage(w, h, 1);
        Graphics2D g = bi.createGraphics();
        ((JComponent)((Object)panelToRender)).paint(g);
        this.bufferedImage = bi;
    }

    public void clearBufferedImage() {
        this.bufferedImage = null;
    }

    public void paint(Graphics g) {
        if (this.bufferedImage == null) {
            super.paint(g);
        } else {
            g.drawImage(this.bufferedImage, 0, 0, null);
        }
    }
}

