/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.admin.wastage;

import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import ordermate.database.EventContext;
import ordermate.database.config.Quantity;
import ordermate.database.stock.StockItem;
import ordermate.database.stock.usage.StockWastage;
import ordermate.database.stock.usage.StockWastageHelper;
import stockmate.database.interfaces.stock.MeasureUnitI;
import waitermate.LoginManager;
import waitermate.gui.displayitems.stockitems.StockItemSearchPanel;
import waitermate.gui.screens.admin.AbstractAdminScreen;
import waitermate.gui.screens.admin.wastage.WasteStockItemsPanel;
import waitermate.guikit.NavBar;
import waitermate.guikit.dialogs.Dialogs;

public class WasteStockItemsScreen
extends AbstractAdminScreen {
    private WasteStockItemsPanel gui = new WasteStockItemsPanel();
    private List<StockWastage> selectedLinks = new ArrayList<StockWastage>();

    public WasteStockItemsScreen() {
        this.gui.newItem.connect((Object)this, "gotNewItem");
        this.gui.item.connect((Object)this, "gotItem");
        this.gui.delete.connect((Object)this, "gotDelete");
    }

    public JComponent getMainArea() {
        return this.gui;
    }

    public StockItemSearchPanel getStockItemSearchdGui() {
        return this.gui.getStockItemSearchdGui();
    }

    @Override
    public void display() {
        super.display();
        this.gui.startSearch();
    }

    @Override
    public NavBar getNavBar() {
        return null;
    }

    @Override
    public String getCategoryName() {
        return "Waste Stock Items";
    }

    @Override
    public Icon getCategoryIcon() {
        return null;
    }

    void gotNewItem(StockItem newItem) {
        double toSet = Dialogs.getDouble((String)(newItem.getDisplayMeasureUnitContainer().toString() + " : "), (double)0.0);
        if (toSet > Double.MIN_VALUE) {
            this.selectedLinks.add(StockWastageHelper.createStockWastage((StockItem)newItem, (double)toSet, (EventContext)LoginManager.getEventContext()));
            this.itemsUpdated();
        }
    }

    void gotItem(StockWastage theItem) {
        Quantity newQuantity = theItem.getQuantityUsed();
        MeasureUnitI unit = theItem.getStockItem().getDisplayMeasureUnit();
        double toSet = Dialogs.getDouble((String)unit.toString(), (double)(newQuantity.getRawValue() / unit.getValue()));
        theItem.setQuantityUsed(new Quantity(unit, toSet * unit.getValue()));
        this.itemsUpdated();
    }

    void gotDelete(StockWastage theItem) {
        this.selectedLinks.remove(theItem);
        this.itemsUpdated();
    }

    private void itemsUpdated() {
        this.gui.showLinks(this.selectedLinks);
    }

    public void gotClear() {
        this.getStockItemSearchdGui().gotKeystroke("");
        this.selectedLinks.clear();
        this.itemsUpdated();
    }

    public List<StockWastage> getWastageList() {
        return this.selectedLinks;
    }

    public void invalidatePanel() {
        this.gui.retrieveKeyboard();
    }
}

