/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.customer;

import au.com.ordermate.persistence.PropertiedObject;
import java.util.ArrayList;
import java.util.List;
import ordermate.database.sales.Customer;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import waitermate.gui.screens.customer.add.AddCustomer;
import waitermate.gui.screens.customer.search.CustomerSearch;
import waitermate.guikit.AbstractScreen;
import waitermate.guikit.ScreenResource;

public class SelectCustomer {
    public final Signal back = Signals.createSignal();
    public final Signal<Customer, ?, ?, ?, ?> selected = Signals.createSignal(Customer.class, (String)"customer");
    private static SelectCustomer instance;
    private Customer selectedCustomer;
    private boolean modal = false;
    private CustomerSearch customerSearch;
    private AddCustomer addCustomer;
    private List<PropertiedObject.Property> fieldRequirements = new ArrayList<PropertiedObject.Property>();

    public SelectCustomer(List<PropertiedObject.Property> requiredFields) {
        this.fieldRequirements = requiredFields;
        this.setupCustomerPanels();
    }

    public void setRequirements(List<PropertiedObject.Property> requirements) {
        this.fieldRequirements = requirements;
        this.addCustomer.setRequirements(requirements);
        this.customerSearch.setRequiredFields(requirements);
    }

    public void start() {
        this.customerSearch.reset();
        this.customerSearch.display();
    }

    protected void addCustomer() {
        this.addCustomer.add(this.customerSearch.getEnteredProperties(), this.fieldRequirements);
    }

    public void editCustomer(Customer customer) {
        this.addCustomer.edit(customer, this.fieldRequirements);
    }

    protected void selectCustomer(Customer customer) {
        this.selectedCustomer = customer;
        if (this.modal) {
            ScreenResource.stopModal();
            this.modal = false;
        }
        this.selected.emit((Object)customer);
    }

    void searchBack() {
        if (this.modal) {
            ScreenResource.stopModal();
            this.modal = false;
        }
        this.back.emit();
    }

    public static final void setupPanels() {
        if (instance != null) {
            instance.setupCustomerPanels();
        }
    }

    private void setupCustomerPanels() {
        if (this.customerSearch != null) {
            this.customerSearch.selected.disconnect((Object)this);
            this.customerSearch.edit.disconnect((Object)this);
            this.customerSearch.back.disconnect((Object)this);
            this.customerSearch.add.disconnect((Object)this);
        }
        if (this.addCustomer != null) {
            this.addCustomer.back.disconnect((Object)this);
            this.addCustomer.customerSaved.disconnect((Object)this);
        }
        this.customerSearch = new CustomerSearch(this.fieldRequirements, true, true);
        this.addCustomer = new AddCustomer(this.fieldRequirements);
        this.customerSearch.selected.connect((Object)this, "selectCustomer");
        this.customerSearch.edit.connect((Object)this, "editCustomer");
        this.customerSearch.back.connect((Object)this, "searchBack");
        this.customerSearch.add.connect((Object)this, "addCustomer");
        this.addCustomer.back.connect((Object)this, "searchBack");
        this.addCustomer.customerSaved.connect((Object)this, "selectCustomer");
    }

    public static Customer startModal(List<PropertiedObject.Property> requirements, boolean returnHalfFormed) {
        return SelectCustomer.startModal(null, requirements, returnHalfFormed);
    }

    public static Customer startModal(String phone, List<PropertiedObject.Property> requirements, boolean returnHalfFormed) {
        if (instance == null) {
            instance = new SelectCustomer(requirements);
        } else {
            instance.setRequirements(requirements);
        }
        SelectCustomer.instance.selectedCustomer = null;
        AbstractScreen restoreScreen = ScreenResource.getScreen();
        SelectCustomer.instance.customerSearch.reset();
        SelectCustomer.instance.addCustomer.setReturnHalfFormed(returnHalfFormed);
        if (phone != null) {
            SelectCustomer.instance.customerSearch.setValue(Customer.Properties.PRIMARY_PHONE_NUMBER, phone);
            SelectCustomer.instance.customerSearch.propertyChange(Customer.Properties.PRIMARY_PHONE_NUMBER, phone);
        }
        SelectCustomer.instance.customerSearch.display();
        SelectCustomer.instance.modal = true;
        ScreenResource.startModal();
        restoreScreen.display();
        return SelectCustomer.instance.selectedCustomer;
    }

    public static Customer startModal(List<PropertiedObject.Property> requirements, Customer customer, boolean returnHalfFormed) {
        if (instance == null) {
            instance = new SelectCustomer(requirements);
        } else {
            instance.setRequirements(requirements);
        }
        SelectCustomer.instance.selectedCustomer = customer;
        AbstractScreen restoreScreen = ScreenResource.getScreen();
        SelectCustomer.instance.customerSearch.reset();
        SelectCustomer.instance.addCustomer.setReturnHalfFormed(returnHalfFormed);
        instance.editCustomer(customer);
        SelectCustomer.instance.modal = true;
        ScreenResource.startModal();
        restoreScreen.display();
        return SelectCustomer.instance.selectedCustomer;
    }
}

