/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.customer.add;

import au.com.ordermate.util.image.IconLoader;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.JButton;
import javax.swing.JComponent;
import ordermate.database.misc.SystemProperty;
import ordermate.database.users.AllPermissions;
import ordermate.gui.modify.security.StandardSecurityDecorator;
import ordermate.internationalization.Internationalization;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import waitermate.guikit.NavBar;

public class AddCustomerNav
extends NavBar {
    public final Signal addCard = Signals.createSignal();
    public final Signal drivers = Signals.createSignal();
    public final Signal deleteCustomer = Signals.createSignal();
    public final Signal salesHistorySignal = Signals.createSignal();
    public final Signal location = Signals.createSignal();
    private final JButton addCardButton;
    private final JButton salesHistoryButton;
    private final StandardSecurityDecorator deleteCustomerButton;
    private final StandardSecurityDecorator okDecorator;
    private final StandardSecurityDecorator locationDecorator;

    public AddCustomerNav() {
        this.addLeft(this.getBackButton());
        JButton locationButton = this.constructButton(IconLoader.get((String)"/waitermate/images/customerLocation.png"), Internationalization.getLiteralFor((String)"LOCATION"), "location", this.location);
        this.locationDecorator = new StandardSecurityDecorator((JComponent)locationButton, AllPermissions.VIEW_GOOGLE_MAPS);
        this.addCardButton = this.constructButton(IconLoader.get((String)"/waitermate/images/card.png"), Internationalization.getLiteralFor((String)"CUSTOMER_CARD"), "addCard");
        if (SystemProperty.getInstance().isLoyaltyEnabled()) {
            this.addRight((Component)new StandardSecurityDecorator((JComponent)this.addCardButton, AllPermissions.ASSIGN_LOYALTY_CARD));
        }
        this.deleteCustomerButton = new StandardSecurityDecorator((JComponent)this.constructButton(IconLoader.get((String)"/waitermate/images/deleteLarge.png"), "<HTML><CENTER>" + Internationalization.getLiteralFor((String)"DELETE") + "<BR>" + Internationalization.getLiteralFor((String)"CUSTOMER") + "</CENTER></HTML>", "delete", this.deleteCustomer), AllPermissions.DELETE_CUSTOMER);
        this.salesHistoryButton = this.constructButton(IconLoader.get((String)"/waitermate/images/money.png"), "<HTML><CENTER>" + Internationalization.getLiteralFor((String)"SHOW_SALES") + "<BR>" + Internationalization.getLiteralFor((String)"HISTORY") + "</CENTER></HTML>", "showHistory", this.salesHistorySignal);
        this.addRight((Component)this.locationDecorator);
        this.addRight((Component)this.deleteCustomerButton);
        this.addRight(this.salesHistoryButton);
        JButton okButton = this.getOkButton();
        this.okDecorator = new StandardSecurityDecorator((JComponent)okButton, AllPermissions.CUSTOMER_ADMIN);
        this.addRight((Component)this.okDecorator);
        this.addRight(this.getCancelButton());
        this.addLeft(this.getBackButton());
    }

    public void setHasCustomer(boolean hasCust) {
        this.salesHistoryButton.setVisible(hasCust);
        this.deleteCustomerButton.setVisible(hasCust);
    }

    public void actionPerformed(ActionEvent e) {
        super.actionPerformed(e);
        if (e.getSource() == this.addCardButton) {
            this.addCard.emit();
        }
    }

    public JComponent getAddCardButton() {
        return this.addCardButton;
    }

    public JComponent getOkComponent() {
        return this.okDecorator;
    }
}

