/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.customer.add;

import au.com.ordermate.gui.GraphPaperLayout;
import au.com.ordermate.persistence.PropertiedObject;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import ordermate.database.hardware.Terminal;
import ordermate.database.sales.Customer;
import ordermate.gui.themes.OrderMateTheme;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import waitermate.gui.mandatory.AbstractMandatoryFieldsPanel;
import waitermate.gui.screens.customer.add.addressinfo.AddressInfoPanel;
import waitermate.gui.screens.customer.add.addressinfo.AddressInfoPanelKBFriendly;
import waitermate.gui.screens.customer.add.basicinfo.BasicInfoPanel;
import waitermate.gui.screens.customer.add.basicinfo.BasicInfoPanelKBFriendly;
import waitermate.gui.screens.customer.add.basicinfo.PersonalInfoPanel;
import waitermate.gui.screens.customer.add.basicinfo.PersonalInfoPanelKBFriendly;
import waitermate.gui.screens.customer.add.otherinfo.AdditionalInfoPanel;
import waitermate.gui.screens.customer.add.otherinfo.AdditionalInfoPanelKBFriendly;
import waitermate.gui.screens.customer.add.otherinfo.ContactInfoPanel;
import waitermate.gui.screens.customer.add.otherinfo.ContactInfoPanelKBFriendly;

public class AddCustomerPanel
extends JPanel {
    private JTabbedPane screens;
    private AbstractMandatoryFieldsPanel<Customer> basicInfo;
    private AbstractMandatoryFieldsPanel<Customer> personalInfo;
    private AbstractMandatoryFieldsPanel<Customer> addressInfo;
    private AbstractMandatoryFieldsPanel<Customer> contactInfo;
    private AbstractMandatoryFieldsPanel<Customer> additionalInfo;
    private List<AbstractMandatoryFieldsPanel<Customer>> infoPanels;
    private List mandatoryFields = new ArrayList();
    public final Signal newInput = Signals.createSignal();
    final Signal gotFinishedPanel = Signals.createSignal();

    public AddCustomerPanel(List<PropertiedObject.Property> requirements) {
        super((LayoutManager)new GraphPaperLayout(new Dimension(1, 4)));
        this.setupComponents();
        this.setMandatoryFields(requirements);
    }

    private void setupComponents() {
        boolean useOnscreenKeyboard = Terminal.getLocalHost().isUseOnscreenKeyboard();
        this.infoPanels = new ArrayList<AbstractMandatoryFieldsPanel<Customer>>();
        if (!useOnscreenKeyboard) {
            this.basicInfo = new BasicInfoPanelKBFriendly();
            this.infoPanels.add(this.basicInfo);
            this.personalInfo = new PersonalInfoPanelKBFriendly();
            this.infoPanels.add(this.personalInfo);
            this.addressInfo = new AddressInfoPanelKBFriendly();
            this.infoPanels.add(this.addressInfo);
            this.contactInfo = new ContactInfoPanelKBFriendly();
            this.infoPanels.add(this.contactInfo);
            this.additionalInfo = new AdditionalInfoPanelKBFriendly();
            this.infoPanels.add(this.additionalInfo);
            this.add(this.basicInfo, new Rectangle(0, 0, 1, 1));
            this.add(this.contactInfo, new Rectangle(0, 1, 1, 1));
            this.add(this.addressInfo, new Rectangle(0, 2, 1, 1));
            this.add(this.personalInfo, new Rectangle(0, 3, 1, 1));
            this.add(this.additionalInfo, new Rectangle(0, 4, 1, 1));
            Component[] comps = this.personalInfo.getComponents();
            comps[comps.length - 1].addFocusListener(new FocusListener(){

                @Override
                public void focusGained(FocusEvent e) {
                }

                @Override
                public void focusLost(FocusEvent e) {
                    if (!AddCustomerPanel.this.isAncestorOf(e.getOppositeComponent())) {
                        AddCustomerPanel.this.gotFinishedPanel.emit();
                    }
                }
            });
        } else {
            this.screens = new JTabbedPane();
            OrderMateTheme.setupTabbedPane((JTabbedPane)this.screens);
            this.screens.setFont(OrderMateTheme.getLargeFont());
            this.basicInfo = new BasicInfoPanel();
            this.infoPanels.add(this.basicInfo);
            this.personalInfo = new PersonalInfoPanel();
            this.infoPanels.add(this.personalInfo);
            this.addressInfo = new AddressInfoPanel();
            this.infoPanels.add(this.addressInfo);
            this.contactInfo = new ContactInfoPanel();
            this.infoPanels.add(this.contactInfo);
            this.additionalInfo = new AdditionalInfoPanel();
            this.infoPanels.add(this.additionalInfo);
            this.screens.addTab(this.basicInfo.getPanelTitleFormatted(""), this.basicInfo);
            this.screens.addTab(this.contactInfo.getPanelTitleFormatted(""), this.contactInfo);
            this.screens.addTab(this.addressInfo.getPanelTitleFormatted(""), this.personalInfo);
            this.screens.addTab(this.personalInfo.getPanelTitleFormatted(""), this.addressInfo);
            this.screens.addTab(this.additionalInfo.getPanelTitleFormatted(""), this.additionalInfo);
            this.add((Component)this.screens, new Rectangle(0, 0, 1, 4));
        }
        for (AbstractMandatoryFieldsPanel<Customer> panel : this.infoPanels) {
            panel.newInput.connect((Object)this, "newInput");
            panel.panelValiditySignal.connect((Object)this, "gotPanelValidityChanged");
        }
    }

    public void newInput() {
        this.newInput.emit();
        this.doVisualFeedbackForRequiredPanels();
    }

    boolean okForRequirements() {
        Customer customer = this.getCustomer(new Customer());
        return customer.getMeetsRequirements(this.mandatoryFields);
    }

    public Customer saveCustomer(Customer theCustomer) {
        Customer customer = this.getCustomer(theCustomer);
        if (customer != null) {
            customer.save();
        }
        return customer;
    }

    public void setCustomer(Customer customer) {
        for (AbstractMandatoryFieldsPanel<Customer> panel : this.infoPanels) {
            panel.loadObject(customer);
        }
        this.doVisualFeedbackForRequiredPanels();
    }

    protected Customer getCustomer(Customer theCustomer) {
        if (theCustomer == null) {
            return theCustomer;
        }
        Customer customer = theCustomer;
        customer = this.basicInfo.saveObject(customer);
        customer = this.contactInfo.saveObject(customer);
        customer = this.personalInfo.saveObject(customer);
        customer = this.addressInfo.saveObject(customer);
        customer = this.additionalInfo.saveObject(customer);
        return customer;
    }

    public void reset() {
        if (this.screens != null) {
            this.screens.setSelectedIndex(0);
        }
        for (AbstractMandatoryFieldsPanel<Customer> panel : this.infoPanels) {
            panel.reset();
        }
        this.doVisualFeedbackForRequiredPanels();
    }

    public void setMandatoryFields(List<PropertiedObject.Property> requirements) {
        this.mandatoryFields = requirements;
        for (AbstractMandatoryFieldsPanel<Customer> panel : this.infoPanels) {
            panel.setFieldsRequired(requirements);
        }
        this.doVisualFeedbackForRequiredPanels();
    }

    public void focusFirstComponent() {
        for (int i = this.infoPanels.size() - 1; i >= 0; --i) {
            this.infoPanels.get(i).selectFirstInvalid();
        }
        if (this.screens != null) {
            AbstractMandatoryFieldsPanel<Customer> toSelect = this.infoPanels.get(0);
            for (AbstractMandatoryFieldsPanel<Customer> nextPanel : this.infoPanels) {
                if (nextPanel.isPanelValid()) continue;
                toSelect = nextPanel;
                break;
            }
            final AbstractMandatoryFieldsPanel<Customer> comp = toSelect;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    AddCustomerPanel.this.screens.setSelectedComponent(comp);
                    comp.selectFirstInvalid();
                }
            });
        }
    }

    public List getMandatoryFields() {
        return this.mandatoryFields;
    }

    private void doVisualFeedbackForRequiredPanels() {
        for (AbstractMandatoryFieldsPanel<Customer> panel : this.infoPanels) {
            this.gotPanelValidityChanged(panel.hasPanelMetRequirements(), panel);
        }
    }

    public void gotPanelValidityChanged(Boolean validity, AbstractMandatoryFieldsPanel panel) {
        String textTabColour = validity != null && validity != false ? null : "RED";
        if (this.screens != null) {
            this.screens.setTitleAt(this.screens.indexOfComponent(panel), panel.getPanelTitleFormatted(textTabColour));
        }
    }

    public JTabbedPane getScreens() {
        return this.screens;
    }
}

