/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.customer.add.addressinfo;

import au.com.ordermate.gui.GraphPaperLayout;
import au.com.ordermate.persistence.PropertiedObject;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import ordermate.database.delivery.DeliveryZone;
import ordermate.database.delivery.Policy;
import ordermate.database.delivery.StreetDirectoryReference;
import ordermate.database.misc.BusinessInfo;
import ordermate.database.misc.SystemProperty;
import ordermate.database.sales.Customer;
import ordermate.database.sales.CustomerSearch;
import ordermate.gui.scroll.AbstractScrollPaneModel;
import ordermate.internationalization.Internationalization;
import waitermate.gui.screens.customer.add.CustomerInfoPanelTSFriendly;
import waitermate.guikit.dialogs.OnePressPopupWindow;

public class AddressInfoPanel
extends CustomerInfoPanelTSFriendly {
    private JToggleButton roomAptNo;
    private JToggleButton houseNumber;
    private JToggleButton streetName;
    private JToggleButton streetType;
    private JToggleButton suburb;
    private JToggleButton postCode;
    private JToggleButton state;
    private JLabel streetDirRef;
    private JLabel deliveryZone;
    private JLabel roomAptNoLabel;
    private JLabel houseNumberLabel;
    private JLabel streetNameLabel;
    private JLabel streetTypeLabel;
    private JLabel suburbLabel;
    private JLabel postCodeLabel;
    private JLabel stateLabel;
    private JLabel streetDirRefLabel;
    private JLabel deliveryZoneLabel;

    public AddressInfoPanel() {
        super(Internationalization.getLiteralFor((String)"ADDRESS"));
        JPanel addressFieldPanel = new JPanel((LayoutManager)new GraphPaperLayout(new Dimension(16, 20)));
        this.houseNumber = new JToggleButton("");
        this.houseNumber.setName("houseNumber");
        this.buttons.add(this.houseNumber);
        this.addButtonProperty(Customer.Properties.HOUSE_NUMBER, this.houseNumber);
        this.houseNumberLabel = new JLabel(Internationalization.getLiteralFor((String)"HOUSE_NUMBER"));
        this.roomAptNo = new JToggleButton("");
        this.roomAptNo.setName("roomAptNo");
        this.buttons.add(this.roomAptNo);
        this.addButtonProperty(Customer.Properties.ROOM_APT_NUMBER, this.roomAptNo);
        this.roomAptNoLabel = new JLabel(Internationalization.getLiteralFor((String)"ROOM_APT_NO"));
        this.streetName = new JToggleButton("");
        this.streetName.setName("streetName");
        this.buttons.add(this.streetName);
        this.addButtonProperty(Customer.Properties.STREET_NAME, this.streetName);
        this.streetNameLabel = new JLabel(Internationalization.getLiteralFor((String)"STREET_NAME"));
        this.streetType = new JToggleButton("");
        this.streetType.setName("streetType");
        this.buttons.add(this.streetType);
        this.addButtonProperty(Customer.Properties.STREET_TYPE, this.streetType);
        this.streetTypeLabel = new JLabel(Internationalization.getLiteralFor((String)"STREET_TYPE"));
        this.suburb = new JToggleButton("");
        this.suburb.setName("suburb");
        this.buttons.add(this.suburb);
        this.addButtonProperty(Customer.Properties.SUBURB, this.suburb);
        this.suburbLabel = new JLabel(Internationalization.getLiteralFor((String)"SUBURB"));
        this.postCode = new JToggleButton("");
        this.postCode.setName("postCode");
        this.buttons.add(this.postCode);
        this.addButtonProperty(Customer.Properties.POSTCODE, this.postCode);
        this.postCodeLabel = new JLabel(Internationalization.getLiteralFor((String)"POST_CODE"));
        this.state = new JToggleButton("");
        this.state.setName("state");
        this.buttons.add(this.state);
        this.addButtonProperty(Customer.Properties.STATE, this.state);
        this.stateLabel = new JLabel(Internationalization.getLiteralFor((String)"STATE"));
        this.streetDirRef = new JLabel("");
        this.streetDirRef.setName("streetDirRef");
        this.streetDirRefLabel = new JLabel(Internationalization.getLiteralFor((String)"MELWAYS_REFERENCE"));
        this.deliveryZone = new JLabel("");
        this.deliveryZoneLabel = new JLabel(Internationalization.getLiteralFor((String)"DELIVERY_ZONE"));
        boolean useZones = SystemProperty.getInstance().isUseDeliveryZones();
        this.deliveryZone.setVisible(useZones);
        this.deliveryZoneLabel.setVisible(useZones);
        this.roomAptNo.addActionListener(this);
        this.houseNumber.addActionListener(this);
        this.streetName.addActionListener(this);
        this.streetType.addActionListener(this);
        this.suburb.addActionListener(this);
        this.postCode.addActionListener(this);
        this.state.addActionListener(this);
        addressFieldPanel.add((Component)this.roomAptNoLabel, new Rectangle(0, 0, 3, 2));
        addressFieldPanel.add((Component)this.roomAptNo, new Rectangle(0, 2, 2, 4));
        addressFieldPanel.add((Component)this.houseNumberLabel, new Rectangle(3, 0, 3, 2));
        addressFieldPanel.add((Component)this.houseNumber, new Rectangle(3, 2, 2, 4));
        addressFieldPanel.add((Component)this.streetNameLabel, new Rectangle(6, 0, 4, 2));
        addressFieldPanel.add((Component)this.streetName, new Rectangle(6, 2, 4, 4));
        addressFieldPanel.add((Component)this.streetTypeLabel, new Rectangle(11, 0, 4, 2));
        addressFieldPanel.add((Component)this.streetType, new Rectangle(11, 2, 4, 4));
        addressFieldPanel.add((Component)this.suburbLabel, new Rectangle(0, 7, 4, 2));
        addressFieldPanel.add((Component)this.suburb, new Rectangle(0, 9, 5, 4));
        addressFieldPanel.add((Component)this.stateLabel, new Rectangle(6, 7, 4, 2));
        addressFieldPanel.add((Component)this.state, new Rectangle(6, 9, 4, 4));
        addressFieldPanel.add((Component)this.postCodeLabel, new Rectangle(11, 7, 3, 2));
        addressFieldPanel.add((Component)this.postCode, new Rectangle(11, 9, 3, 4));
        addressFieldPanel.add((Component)this.streetDirRefLabel, new Rectangle(0, 14, 4, 2));
        addressFieldPanel.add((Component)this.streetDirRef, new Rectangle(0, 16, 4, 4));
        addressFieldPanel.add((Component)this.deliveryZoneLabel, new Rectangle(6, 14, 4, 2));
        addressFieldPanel.add((Component)this.deliveryZone, new Rectangle(6, 16, 4, 4));
        this.add((Component)addressFieldPanel, new Rectangle(0, 0, 15, 20));
        this.newInput.emit();
    }

    @Override
    public void setSelectedButton(AbstractButton button) {
        OnePressPopupWindow statePopup;
        OnePressPopupWindow streetPopup;
        JButton selectedButton;
        super.setSelectedButton(button);
        if (button == this.streetType && (selectedButton = (streetPopup = new OnePressPopupWindow("" + Internationalization.getLiteralFor((String)"SELECT_STREET_TYPE"), (Collection)AbstractScrollPaneModel.constructButtons((String[])CustomerSearch.makeStreetTypeList().toArray(new String[0])), 2, 4, true)).start()) != null) {
            this.streetType.setText(selectedButton.getText());
            this.keyboardUpdated(selectedButton.getText());
            this.doRequiredFieldsVisualFeedback();
        }
        if (button == this.state && (selectedButton = (statePopup = new OnePressPopupWindow(Internationalization.getLiteralFor((String)"SELECT_STATE"), (Collection)AbstractScrollPaneModel.constructButtons((String[])CustomerSearch.getStates()), 2, 4, true)).start()) != null) {
            this.state.setText(selectedButton.getText());
            this.keyboardUpdated(selectedButton.getText());
            this.doRequiredFieldsVisualFeedback();
        }
        if (button == this.postCode) {
            if (this.isActiveLocale("GB")) {
                this.theKeyboard.enableNumbersOnly(false);
                this.theKeyboard.setCaps(true);
            } else {
                this.theKeyboard.enableNumbersOnly(true);
                this.theKeyboard.setCaps(false);
            }
            this.theKeyboard.setShift(false);
        } else {
            this.theKeyboard.enableNumbersOnly(false);
        }
    }

    private boolean isActiveLocale(String localeString) {
        if (Internationalization.getActiveResourceBundleForState() == null || Internationalization.getActiveResourceBundleForState().getLocale() == null) {
            return false;
        }
        return localeString.equals(Internationalization.getActiveResourceBundleForState().getLocale().getCountry());
    }

    public String getHouseNumber() {
        return this.houseNumber.getText();
    }

    public String getStreetName() {
        return this.streetName.getText();
    }

    public String getSuburb() {
        return this.suburb.getText();
    }

    public String getPostcode() {
        return this.postCode.getText();
    }

    public String getState() {
        return this.state.getText();
    }

    public String getRef() {
        return this.streetDirRef.getText();
    }

    public String getStreetType() {
        return this.streetType.getText();
    }

    @Override
    public void keyboardUpdated(String newValue) {
        if (!this.streetType.isSelected() && !this.state.isSelected()) {
            super.keyboardUpdated(newValue);
            this.newInput();
        } else {
            this.newInput();
        }
        this.updateStreetRef();
    }

    @Override
    public void loadObject(Customer object) {
        super.loadObject(object);
        this.updateStreetRef();
    }

    @Override
    public void reset() {
        super.reset();
        this.setSelectedButton(this.houseNumber);
        this.houseNumber.setSelected(true);
        this.state.setText(BusinessInfo.getInstance().getDefaultState());
    }

    private void updateStreetRef() {
        String theStreetName = this.getStreetName();
        String theStreetType = this.getStreetType();
        String theSuburb = this.getSuburb();
        if (theStreetName == null || theStreetName.equals("") || theStreetType == null || theStreetType.equals("") || theSuburb == null || theSuburb.equals("")) {
            this.streetDirRef.setText("");
            this.deliveryZone.setText("");
            return;
        }
        StreetDirectoryReference ref = StreetDirectoryReference.findStreetDir((String)theStreetName, (String)(theStreetType = CustomerSearch.convertStreetTypeToAbbreviation((String)theStreetType)), (String)theSuburb);
        if (ref != null) {
            this.streetDirRef.setText(ref.getDirectoryReference());
        }
        if (ref == null || ref.getZone() == null) {
            this.deliveryZone.setForeground(Policy.PREVENT.getColor());
            this.deliveryZone.setText(Internationalization.getLiteralFor((String)"NO_ZONE"));
        } else {
            DeliveryZone zone = ref.getZone();
            Policy policy = zone.getPolicy();
            this.deliveryZone.setForeground(policy.getColor());
            this.deliveryZone.setText(zone.getLabel());
        }
    }

    @Override
    public void gotAutoComplete(String text) {
        super.gotAutoComplete(text);
        this.updateStreetRef();
    }

    @Override
    protected void doAutoSuggest(String newValue) {
        if (newValue != null && !newValue.equals("") && (this.streetName.equals(this.getTarget()) || this.suburb.equals(this.getTarget()))) {
            List items = CustomerSearch.newFieldSearch((PropertiedObject.Property)this.getPropertyForButton(this.getTarget()), (String)newValue);
            boolean hasResults = false;
            List streetDirResults = null;
            if (this.streetName.equals(this.getTarget())) {
                streetDirResults = CustomerSearch.searchStreetNames((String)newValue);
                hasResults = streetDirResults.size() > 0;
            } else if (this.suburb.equals(this.getTarget())) {
                streetDirResults = CustomerSearch.searchSuburbNames((String)newValue);
                boolean bl = hasResults = streetDirResults.size() > 0;
            }
            if (hasResults && streetDirResults != null) {
                for (Object o : streetDirResults) {
                    if (items.contains(o)) continue;
                    items.add(o);
                }
                Collections.sort(items);
            }
            this.autoCompletePanel.setItems(items);
        } else {
            super.doAutoSuggest(newValue);
        }
    }

    @Override
    public Customer saveObject(Customer customer) {
        super.saveObject(customer);
        if (customer != null) {
            customer.setStreetDirRef(this.streetDirRef.getText());
        }
        return customer;
    }
}

