/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.customer.add.addressinfo;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import java.awt.Component;
import java.awt.Rectangle;
import java.util.Collection;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.text.JTextComponent;
import ordermate.database.delivery.StreetDirectoryReference;
import ordermate.database.sales.Customer;
import ordermate.database.sales.CustomerSearch;
import ordermate.gui.autosuggestor.DynamicSuggestionComboHandler;
import ordermate.gui.autosuggestor.StringSearcherSuggestor;
import ordermate.gui.autosuggestor.Suggestor;
import ordermate.internationalization.Internationalization;
import waitermate.KBFriendlyFormHelper;
import waitermate.gui.WaiterMateObjectEditor;
import waitermate.gui.screens.customer.add.CustomerInfoPanelKBFriendly;

public class AddressInfoPanelKBFriendly
extends CustomerInfoPanelKBFriendly {
    private static final int DEF_COLS = 20;
    private JTextComponent houseNumberField;
    private JComboBox streetNameCombo;
    private JComboBox streetTypeCombo;
    private JComboBox suburbCombo;
    private JTextComponent postcodeField;
    private JComboBox stateCombo;
    private JLabel streetDirRef;

    public AddressInfoPanelKBFriendly() {
        super(Internationalization.getLiteralFor((String)"ADDRESS"));
    }

    @Override
    protected void setupComponents(WaiterMateObjectEditor editor) {
        this.houseNumberField = editor.createTextField(Customer.Properties.HOUSE_NUMBER, 5);
        Suggestor streetNameSuggestor = CustomerSearch.makeStreetNameSuggestor();
        this.streetNameCombo = editor.createComboBox(Customer.Properties.STREET_NAME, streetNameSuggestor.getSuggestions());
        DynamicSuggestionComboHandler handler = new DynamicSuggestionComboHandler(streetNameSuggestor, this.streetNameCombo, false);
        handler.selectionMade.connect((Object)this, "gotSelection");
        EventList streetTypes = GlazedLists.eventList((Collection)CustomerSearch.makeStreetTypeList());
        this.streetTypeCombo = editor.createComboBox(Customer.Properties.STREET_TYPE, streetTypes);
        editor.applyAutoComplete(this.streetTypeCombo, streetTypes, true);
        StringSearcherSuggestor suburbSuggestor = new StringSearcherSuggestor(StreetDirectoryReference.Properties.SUBURB);
        this.suburbCombo = editor.createComboBox(Customer.Properties.SUBURB, suburbSuggestor.getSuggestions());
        new DynamicSuggestionComboHandler((Suggestor)suburbSuggestor, this.suburbCombo, true);
        this.postcodeField = editor.createIntegerField(Customer.Properties.POSTCODE, 5);
        EventList states = GlazedLists.eventListOf((Object[])CustomerSearch.getStates());
        this.stateCombo = editor.createComboBox(Customer.Properties.STATE, states);
        editor.applyAutoComplete(this.stateCombo, states, true);
        this.streetDirRef = editor.createLabel(Customer.Properties.STREET_DIR_REF);
        this.registerPropertyComponent(Customer.Properties.HOUSE_NUMBER, this.houseNumberField);
        this.registerPropertyComponent(Customer.Properties.STREET_NAME, this.streetNameCombo);
        this.registerPropertyComponent(Customer.Properties.STREET_TYPE, this.streetTypeCombo);
        this.registerPropertyComponent(Customer.Properties.SUBURB, this.suburbCombo);
        this.registerPropertyComponent(Customer.Properties.POSTCODE, this.postcodeField);
        this.registerPropertyComponent(Customer.Properties.STATE, this.stateCombo);
        this.add((Component)KBFriendlyFormHelper.createLabel(Internationalization.getLiteralFor((String)"NUMBER"), null), new Rectangle(0, 0, 4, 1));
        this.add((Component)this.houseNumberField, new Rectangle(5, 0, 3, 1));
        this.add((Component)KBFriendlyFormHelper.createLabel(Internationalization.getLiteralFor((String)"STREET"), null), new Rectangle(9, 0, 4, 1));
        this.add((Component)this.streetNameCombo, new Rectangle(14, 0, 18, 1));
        this.add((Component)this.streetTypeCombo, new Rectangle(33, 0, 6, 1));
        this.add((Component)KBFriendlyFormHelper.createLabel(Internationalization.getLiteralFor((String)"SUBURB"), null), new Rectangle(0, 1, 4, 1));
        this.add((Component)this.suburbCombo, new Rectangle(5, 1, 8, 1));
        this.add((Component)KBFriendlyFormHelper.createLabel(Internationalization.getLiteralFor((String)"STATE"), null), new Rectangle(14, 1, 3, 1));
        this.add((Component)this.stateCombo, new Rectangle(18, 1, 6, 1));
        this.add((Component)KBFriendlyFormHelper.createLabel(Internationalization.getLiteralFor((String)"POSTCODE"), null), new Rectangle(25, 1, 3, 1));
        this.add((Component)this.postcodeField, new Rectangle(29, 1, 3, 1));
        this.add((Component)KBFriendlyFormHelper.createLabel(Internationalization.getLiteralFor((String)"STREET_REF"), null), new Rectangle(33, 1, 3, 1));
        this.add((Component)this.streetDirRef, new Rectangle(37, 1, 3, 1));
    }

    public void gotSelection(Object value) {
        if (value != null && value instanceof StreetDirectoryReference) {
            StreetDirectoryReference ref = (StreetDirectoryReference)value;
            this.streetNameCombo.setSelectedItem(ref.getStreetName());
            this.streetTypeCombo.setSelectedItem(CustomerSearch.convertStreetAbbreviationToName((String)ref.getStreetType()));
            this.streetDirRef.setText(ref.getDirectoryReference());
            this.suburbCombo.setSelectedItem(ref.getSuburb());
            this.postcodeField.setText(ref.getPostcode());
            this.stateCombo.requestFocusInWindow();
        }
    }

    @Override
    public Customer saveObject(Customer theObject) {
        if (this.streetNameCombo.getSelectedIndex() < 0) {
            return super.saveObject(theObject);
        }
        return theObject;
    }
}

