/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.customer.add.basicinfo;

import java.awt.Component;
import java.awt.Rectangle;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JToggleButton;
import ordermate.database.sales.Customer;
import ordermate.database.sales.CustomerCategory;
import ordermate.database.sales.CustomerSearch;
import ordermate.gui.scroll.AbstractScrollPaneModel;
import ordermate.internationalization.Internationalization;
import waitermate.gui.screens.customer.add.CustomerInfoPanelTSFriendly;
import waitermate.guikit.dialogs.OnePressPopupWindow;

public class BasicInfoPanel
extends CustomerInfoPanelTSFriendly {
    private JToggleButton title = new JToggleButton("");
    private JToggleButton firstName;
    private JToggleButton lastName;
    private JLabel titleLabel;
    private JLabel firstNameLabel;
    private JLabel lastNameLabel;
    private JLabel categoryLabel;
    private JComboBox categoryCombo;
    private String[] titles;

    public BasicInfoPanel() {
        super(Internationalization.getLiteralFor((String)"BASIC"));
        this.title.setName("titleButton");
        this.buttons.add(this.title);
        this.addButtonProperty(Customer.Properties.TITLE, this.title);
        this.titleLabel = new JLabel(Internationalization.getLiteralFor((String)"TITLE"));
        this.firstName = new JToggleButton("");
        this.firstName.setText("");
        this.firstName.setName("firstName");
        this.buttons.add(this.firstName);
        this.addButtonProperty(Customer.Properties.FIRST_NAME, this.firstName);
        this.firstNameLabel = new JLabel(Internationalization.getLiteralFor((String)"FIRST_NAME"));
        this.lastName = new JToggleButton("");
        this.lastName.setName("lastName");
        this.buttons.add(this.lastName);
        this.addButtonProperty(Customer.Properties.LAST_NAME, this.lastName);
        this.lastNameLabel = new JLabel(Internationalization.getLiteralFor((String)"LAST_NAME"));
        this.categoryCombo = new JComboBox();
        this.categoryCombo.setName("categoryCombo");
        this.categoryLabel = new JLabel(Internationalization.getLiteralFor((String)"CATEGORY"));
        List categories = CustomerCategory.getAllCategories();
        Iterator it = categories.iterator();
        while (it.hasNext()) {
            this.categoryCombo.addItem(it.next());
        }
        this.categoryCombo.setSelectedIndex(0);
        if (categories.size() < 2) {
            this.categoryLabel.setVisible(false);
            this.categoryCombo.setVisible(false);
        }
        this.title.addActionListener(this);
        this.firstName.addActionListener(this);
        this.lastName.addActionListener(this);
        this.categoryCombo.addActionListener(this);
        this.titles = CustomerSearch.TITLES;
        this.add((Component)this.titleLabel, new Rectangle(0, 0, 4, 2));
        this.add((Component)this.title, new Rectangle(0, 2, 4, 4));
        this.add((Component)this.firstNameLabel, new Rectangle(5, 0, 4, 2));
        this.add((Component)this.firstName, new Rectangle(5, 2, 4, 4));
        this.add((Component)this.lastNameLabel, new Rectangle(10, 0, 4, 2));
        this.add((Component)this.lastName, new Rectangle(10, 2, 4, 4));
        this.add((Component)this.categoryLabel, new Rectangle(0, 7, 4, 2));
        this.add((Component)this.categoryCombo, new Rectangle(0, 9, 4, 4));
    }

    public String getFirstName() {
        return this.firstName.getText();
    }

    public String getLastName() {
        return this.lastName.getText();
    }

    public String getTitle() {
        return this.title.getText();
    }

    public CustomerCategory getCustomerCategory() {
        return (CustomerCategory)this.categoryCombo.getSelectedItem();
    }

    public void setSelectedCategory(CustomerCategory category) {
        if (category != null) {
            this.categoryCombo.setSelectedItem(category);
        } else {
            this.categoryCombo.setSelectedIndex(0);
        }
    }

    @Override
    public void setSelectedButton(AbstractButton button) {
        OnePressPopupWindow titlePopup;
        JButton selectedButton;
        super.setSelectedButton(button);
        if (button == this.title && (selectedButton = (titlePopup = new OnePressPopupWindow(Internationalization.getLiteralFor((String)"SELECT_TITLE"), (Collection)AbstractScrollPaneModel.constructButtons((String[])this.titles), 1, 5)).start()) != null) {
            this.title.setText(selectedButton.getText());
            this.keyboardUpdated(selectedButton.getText());
        }
    }

    @Override
    public void selectFirstInvalid() {
        this.title.setVisible(false);
        super.selectFirstInvalid();
        this.title.setVisible(true);
    }

    @Override
    public void keyboardUpdated(String newValue) {
        if (!this.title.isSelected()) {
            super.keyboardUpdated(newValue);
        } else {
            this.newInput();
        }
    }

    @Override
    public void reset() {
        super.reset();
        this.setSelectedButton(this.firstName);
        this.firstName.setSelected(true);
        this.categoryCombo.setSelectedIndex(0);
    }

    @Override
    public void loadObject(Customer customer) {
        super.loadObject(customer);
        if (customer != null) {
            this.setSelectedCategory(customer.getCategory());
        }
    }

    @Override
    public Customer saveObject(Customer customer) {
        if (customer != null) {
            if (this.categoryCombo.getSelectedIndex() < 0) {
                this.categoryCombo.setSelectedIndex(0);
            }
            customer.setCategory(this.getCustomerCategory());
        }
        return super.saveObject(customer);
    }
}

