/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.customer.search;

import au.com.ordermate.persistence.PropertiedObject;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import ordermate.database.hardware.Terminal;
import ordermate.database.sales.Customer;
import ordermate.gui.scroll.CustomScrollPane;
import ordermate.gui.scroll.Renderer;
import ordermate.gui.scroll.RendererScrollPaneModel;
import ordermate.gui.themes.OrderMateTheme;
import ordermate.internationalization.Internationalization;
import ordermate.signals.Signal;
import waitermate.gui.displayitems.customer.CustomerRenderer;
import waitermate.gui.screens.customer.search.CustomerSearchFieldPanel;
import waitermate.gui.screens.customer.search.CustomerSearchFieldPanelKBFriendly;
import waitermate.gui.screens.customer.search.CustomerSearchFieldPanelTSFriendly;

class SearchPanel
extends JPanel {
    public final Signal selected;
    public final Signal<Customer, ?, ?, ?, ?> edit;
    public final Signal propertyChanged;
    private RendererScrollPaneModel<Customer> model;
    private CustomScrollPane scrollPane;
    private CustomerSearchFieldPanel fieldPanel;
    private CustomerRenderer renderer;

    public SearchPanel(boolean showHistory, boolean showEdit) {
        this.renderer = new CustomerRenderer(showHistory, showEdit);
        this.model = new RendererScrollPaneModel((Renderer)this.renderer, 1, 5);
        this.scrollPane = new CustomScrollPane(this.model);
        this.scrollPane.setEmptyMessage(Internationalization.getLiteralFor((String)"NO_CUSTOMERS_FOUND"));
        this.fieldPanel = !Terminal.getLocalHost().isUseOnscreenKeyboard() ? new CustomerSearchFieldPanelKBFriendly() : new CustomerSearchFieldPanelTSFriendly();
        JPanel left = new JPanel();
        left.setLayout(new BorderLayout(0, 5));
        left.add("Center", this.fieldPanel);
        JLabel label = new JLabel(Internationalization.getLiteralFor((String)"_1_SEARCH_FOR_CUSTOMER"));
        label.setFont(OrderMateTheme.getLargeFont());
        left.add("North", label);
        JPanel right = new JPanel();
        right.setLayout(new BorderLayout(0, 5));
        right.add("Center", (Component)this.scrollPane);
        label = new JLabel(Internationalization.getLiteralFor((String)"_2_SELECT_CUSTOMER"));
        label.setFont(OrderMateTheme.getLargeFont());
        right.add("North", label);
        this.setLayout(new GridLayout(1, 2, 5, 0));
        this.add(left);
        this.add(right);
        this.selected = this.renderer.selected;
        this.edit = this.renderer.edit;
        this.propertyChanged = this.fieldPanel.propertyChanged;
    }

    public void setCustomers(List<Customer> customers) {
        this.model.setObjects(customers);
        this.scrollPane.displayPage(0);
    }

    public void setFullScreen(boolean isFullScreen) {
        this.fieldPanel.setFullScreen(isFullScreen);
    }

    public void reset() {
        this.fieldPanel.reset();
        this.model.removeAllObjects();
        this.scrollPane.displayPage(0);
    }

    public Object getValue(PropertiedObject.Property property) {
        return this.fieldPanel.getValue(property);
    }

    public void setValue(PropertiedObject.Property property, Object value) {
        this.fieldPanel.setValue(property, value);
    }
}

