/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.debtor;

import au.com.ordermate.gui.CompositeIconGenerator;
import au.com.ordermate.persistence.Displayable;
import au.com.ordermate.util.DateTimeUtils;
import au.com.ordermate.util.Price;
import java.awt.Color;
import ordermate.database.finance.debtors.transactions.DebtorPayment;
import ordermate.database.finance.transactions.FinanceTransaction;
import ordermate.gui.button.CustomButtonRenderer;

public class DebtorPaymentRenderer
implements CustomButtonRenderer {
    private final DebtorPayment payment;
    protected final FinanceTransaction transaction;

    public DebtorPaymentRenderer(DebtorPayment payment) {
        this.payment = payment;
        this.transaction = payment.getFinanceTransaction();
    }

    public Color getBackgroundColor() {
        return this.transaction.getBackgroundColor();
    }

    public Color getForegroundColor() {
        return this.transaction.getForegroundColor();
    }

    public String getIcon() {
        int ICON_SIZE = 24;
        if (this.transaction.isRefundedDebtorPayment()) {
            CompositeIconGenerator generator = new CompositeIconGenerator(24);
            generator.addIcon("/waitermate/images/undo.png");
            generator.addIcon(this.transaction.getIcon());
            return generator.generateIcon();
        }
        if (this.transaction.getPaid().lessThan((Object)Price.ZERO)) {
            CompositeIconGenerator generator = new CompositeIconGenerator(24);
            generator.addIcon("/waitermate/images/redo.png");
            generator.addIcon(this.transaction.getIcon());
            return generator.generateIcon();
        }
        return this.transaction.getIcon();
    }

    public String getLabel() {
        StringBuilder SB = new StringBuilder("<HTML>");
        SB.append(DateTimeUtils.getMediumDateFormat().format(this.transaction.getCreationTime())).append("<BR><FONT size='+1'>").append(this.getPaidString()).append("</FONT>&nbsp;&nbsp;&nbsp; ").append(this.transaction.getSubType().getLabel()).append("</HTML>");
        return SB.toString();
    }

    public Displayable getData() {
        return this.payment;
    }

    protected String getPaidString() {
        return this.transaction.getPaid().toString();
    }
}

