/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.debtor;

import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObjectI;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import ordermate.database.finance.debtors.AbstractDebtor;
import ordermate.database.finance.debtors.DebtorsSummary;
import ordermate.database.hardware.Terminal;
import ordermate.database.hardware.VirtualPrinter;
import ordermate.docketprocessor.DocketProcessor;
import ordermate.gui.button.CustomButton;
import ordermate.gui.scroll.AbstractScrollPaneModel;
import ordermate.gui.scroll.CustomScrollPane;
import ordermate.gui.scroll.CustomScrollPaneModel;
import ordermate.gui.scroll.TextScrollPaneModel;
import ordermate.integration.PropertyIntegrationUtils;
import waitermate.gui.screens.debtor.SelectDebtorNavBar;
import waitermate.gui.screens.debtor.adddebtor.AddDebtor;
import waitermate.gui.screens.debtor.components.DebtorSelectionPanel;
import waitermate.gui.screens.debtor.debtortransactions.DebtorTransactionsScreen;
import waitermate.guikit.NavBar;
import waitermate.guikit.TabScreen;
import waitermate.guikit.dialogs.Dialogs;
import waitermate.guikit.dialogs.OnePressPopupWindow;
import waitermate.guikit.dialogs.PopupWindow;

public class SelectDebtorTabScreen
extends TabScreen {
    private SelectDebtorNavBar nav = new SelectDebtorNavBar();
    private DebtorSelectionPanel debtorSelectionPanel = new DebtorSelectionPanel(this.nav);
    private DebtorTransactionsScreen individualDebtorScreen = new DebtorTransactionsScreen();
    private AddDebtor addDebtorScreen = new AddDebtor();
    private static SelectDebtorTabScreen instance = new SelectDebtorTabScreen();
    private static final String DEFAULT_STATUS_FILTER = "Outstanding";

    public static SelectDebtorTabScreen getInstance() {
        return instance;
    }

    private SelectDebtorTabScreen() {
        this.nav.reportSignal.connect((Object)this, "gotSummaryReport");
        this.nav.newDebtorSignal.connect((Object)this, "gotNewDebtor");
        this.nav.addRight(this.nav.getAdminButton());
        this.nav.addRight(this.nav.getLogoutButton());
        this.nav.showReportButton(true);
        this.individualDebtorScreen.getNavBar().back.connect((Object)this, "gotBack");
        this.debtorSelectionPanel.debtorSelectedSignal.connect((Object)this, "gotDebtor");
        this.debtorSelectionPanel.back.connect((Object)this, "gotBack");
        this.addDebtorScreen.backSignal.connect((Object)this, "gotBack");
        this.addDebtorScreen.saveDebtorSignal.connect((Object)this, "show");
        this.debtorSelectionPanel.gotPaymentStatusFilter(DEFAULT_STATUS_FILTER);
    }

    public JComponent getMainArea() {
        return this.debtorSelectionPanel;
    }

    public NavBar getNavBar() {
        return this.nav;
    }

    public void gotSummaryReport() {
        JPanel toDisplay = new JPanel();
        List<AbstractDebtor> debtorsToReportOn = this.debtorSelectionPanel.getDebtors();
        TextScrollPaneModel model = new TextScrollPaneModel(16);
        model.addLine("<HTML><h1>Summary Report</h1></HTML>");
        String reportString = "";
        for (AbstractDebtor debtor : debtorsToReportOn) {
            reportString = debtor.getLabel() + "                " + debtor.getAmountOutstanding();
            if (debtor.hasOverdue()) {
                reportString = reportString + "    *** has overdue ***";
            }
            if (!debtor.hasAmount()) continue;
            model.addLine(reportString);
        }
        DebtorsSummary summary = DebtorsSummary.summarize(debtorsToReportOn);
        model.addLine();
        model.addLine("<HTML><H2>Total : " + summary.getOutstanding() + "</H2></HTML>");
        model.addLine("<HTML><H2>Total Overdue: " + summary.getOverdue() + "</H2></HTML>");
        model.addLine();
        model.addLine("Current: " + summary.getCurrent());
        model.addLine("30 Days: " + summary.getThirtyDays());
        model.addLine("60 Days: " + summary.getSixtyDays());
        model.addLine("Plus 60 Days: " + summary.getSixtyPlusDays());
        CustomScrollPane scrollPane = new CustomScrollPane((CustomScrollPaneModel)model);
        scrollPane.setPreferredSize(new Dimension(750, 450));
        toDisplay.add((Component)scrollPane);
        PopupWindow popupWin = new PopupWindow(false);
        popupWin.getNavBar().removeLeft((Component)popupWin.getNavBar().getCancelButton());
        JButton print = popupWin.getNavBar().getPrintButton();
        print.setText("Print Report");
        popupWin.getNavBar().addRight((Component)print);
        popupWin.getNavBar().print.connect((Object)this, "printReport");
        popupWin.getNavBar().setText("Report for current list of debtors");
        popupWin.setComponent((JComponent)scrollPane);
        popupWin.start();
    }

    public void show() {
        super.display();
        this.debtorSelectionPanel.updateModel();
    }

    public void gotNewDebtor() {
        this.addDebtorScreen.start();
    }

    public void gotDebtor(AbstractDebtor debtor) {
        this.individualDebtorScreen.start((AbstractDebtor)PersistenceManager.reacquire((PersistentObjectI)debtor));
    }

    public void gotBack() {
        this.display();
        this.debtorSelectionPanel.updateModel();
    }

    public void setUp() {
        super.setUp();
        this.debtorSelectionPanel.updateModel();
        PropertyIntegrationUtils.synchronize();
        this.nav.refresh();
    }

    public void clearFilters() {
        this.debtorSelectionPanel.clearSearch();
        this.nav.refresh();
    }

    public void printReport() {
        List<AbstractDebtor> debtorsToPrint = this.debtorSelectionPanel.getDebtors();
        ArrayList<VirtualPrinter> printers = Terminal.getLocalHost().getAvaliableWindowsReceiptPrinters();
        if (printers.size() > 1) {
            List buttons = AbstractScrollPaneModel.constructButtons((Collection)printers);
            OnePressPopupWindow printerDialog = new OnePressPopupWindow("Select Printer", (Collection)buttons, 1, 3, false);
            CustomButton selectedButton = (CustomButton)printerDialog.start();
            VirtualPrinter selectedPrinter = (VirtualPrinter)selectedButton.getData();
            printers = new ArrayList<VirtualPrinter>();
            printers.add(selectedPrinter);
        }
        try {
            DocketProcessor.printDebtorSummary(debtorsToPrint, (Collection)printers);
        }
        catch (Exception err) {
            Dialogs.displayOkDialog((String)"An error occured and the debtor summary report could not be printed.", (String)"Print Error");
        }
    }
}

