/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.debtor.adddebtor;

import au.com.ordermate.util.Price;
import javax.swing.JComponent;
import ordermate.database.RequiredFields;
import ordermate.database.finance.debtors.AbstractDebtor;
import ordermate.database.finance.debtors.CustomerDebtorInterface;
import ordermate.database.finance.debtors.group.DebtorGroup;
import ordermate.database.finance.debtors.implementation.CustomerDebtor;
import ordermate.database.finance.debtors.implementation.SimpleDebtor;
import ordermate.database.sales.Customer;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import waitermate.gui.dialogs.DebtorTermsDialog;
import waitermate.gui.screens.customer.SelectCustomer;
import waitermate.gui.screens.debtor.adddebtor.AddDebtorNav;
import waitermate.gui.screens.debtor.adddebtor.AddDebtorPanel;
import waitermate.gui.screens.debtor.adddebtor.DebtorGroupDialog;
import waitermate.guikit.AbstractScreen;
import waitermate.guikit.NavBar;
import waitermate.guikit.dialogs.Dialogs;
import waitermate.guikit.dialogs.KeypadDialog;
import waitermate.guikit.dialogs.PopupWindow;

public class AddDebtor
extends AbstractScreen {
    public final Signal saveDebtorSignal = Signals.createSignal(AbstractDebtor.class, (String)"debtor");
    public final Signal backSignal = Signals.createSignal();
    private AddDebtorNav nav = new AddDebtorNav();
    private AddDebtorPanel gui = new AddDebtorPanel();
    private PopupWindow addTermsPopup = null;
    private KeypadDialog termsKeyPad = null;
    private DebtorGroupDialog groupDialog;
    private SelectCustomer selectCustomer = null;
    private AbstractDebtor theDebtor = new SimpleDebtor();

    public AddDebtor() {
        this.nav.ok.connect((Object)this, "gotOK");
        this.nav.back.connect(this.backSignal);
        this.nav.cancel.connect(this.backSignal);
        this.gui.panelValiditySignal.connect((Object)this, "gotValidityChanged");
        this.gui.setGroup.connect((Object)this, "gotSetDebtorGroup");
        this.gui.newGroup.connect((Object)this, "gotNewGroup");
        this.gui.setAccountName.connect((Object)this, "setAccountName");
        this.gui.setNoteRequired.connect((Object)this, "setNoteRequired");
        this.gui.newCustomer.connect((Object)this, "gotAddCustomer");
        this.gui.changeTerms.connect((Object)this, "gotAddTerms");
        this.gui.setCreditLimit.connect((Object)this, "setCreditLimit");
        this.nav.addCustomerSignal.connect((Object)this, "gotAddCustomer");
        this.nav.removeCustomerSignal.connect((Object)this, "gotRemoveCustomer");
        this.nav.addTermsSignal.connect((Object)this, "gotAddTerms");
    }

    public void start(AbstractDebtor debtor) {
        this.theDebtor = debtor == null ? new SimpleDebtor() : debtor;
        this.gui.setDebtor(this.theDebtor);
        this.nav.setupButtons(this.theDebtor);
        super.display();
    }

    public void resume() {
        this.gui.setRequiredFields((RequiredFields)this.theDebtor);
        this.nav.setupButtons(this.theDebtor);
        this.gui.revalidate();
        this.gui.repaint();
    }

    public void start() {
        this.start(null);
    }

    public AbstractDebtor getDebtor() {
        return this.theDebtor;
    }

    public void display() {
        super.display();
    }

    public JComponent getMainArea() {
        return this.gui;
    }

    public NavBar getNavBar() {
        return this.nav;
    }

    public void gotAddDebtor(AbstractDebtor debtor) {
        debtor.save();
    }

    public void gotOK() {
        if (!this.theDebtor.getGroup().isPersistent()) {
            DebtorGroup grp = DebtorGroup.getMatchingGroup((DebtorGroup)this.theDebtor.getGroup());
            if (grp != null) {
                this.theDebtor.setGroup(grp);
            } else {
                this.theDebtor.getGroup().save();
            }
        }
        this.theDebtor.save();
        this.saveDebtorSignal.emit((Object)this.theDebtor);
    }

    public void gotValidityChanged() {
        this.nav.getOkButton().setEnabled(this.gui.hasPanelMetRequirements());
    }

    public void gotSetDebtorGroup() {
        this.groupDialog = new DebtorGroupDialog(this.theDebtor);
        this.groupDialog.start();
        DebtorGroup newGroup = this.groupDialog.getSelectedGroup();
        if (newGroup != null) {
            this.theDebtor.setGroup(newGroup);
            this.gui.setDebtorGroup(newGroup);
        } else if (this.groupDialog.createNew()) {
            this.theDebtor.setGroup(null);
            this.gui.setDebtorGroup(null);
        }
        this.resume();
    }

    public void gotNewGroup(String newGroupName) {
        this.theDebtor.setGroup(new DebtorGroup(newGroupName, this.theDebtor));
        this.gui.setRequiredFields((RequiredFields)this.theDebtor);
    }

    public void gotAddCustomer() {
        if (this.selectCustomer == null) {
            this.selectCustomer = new SelectCustomer(CustomerDebtor.getRequiredCustomerFields());
            this.selectCustomer.back.connect((Object)this, "display");
            this.selectCustomer.selected.connect((Object)this, "gotCustomer");
        }
        if (this.theDebtor.hasCustomer()) {
            this.selectCustomer.editCustomer(((CustomerDebtorInterface)this.theDebtor).getCustomer());
        } else {
            this.selectCustomer.start();
        }
    }

    public void gotRemoveCustomer() {
        this.theDebtor = this.theDebtor.addCustomer(null);
        this.start(this.theDebtor);
    }

    public void gotAddTerms() {
        if (this.addTermsPopup == null) {
            this.addTermsPopup = new PopupWindow();
            this.addTermsPopup.setOkButtonVisible(true);
            this.addTermsPopup.setCancelButtonVisible(false);
        }
        this.termsKeyPad = new DebtorTermsDialog();
        this.addTermsPopup.setComponent((JComponent)this.termsKeyPad);
        if (this.addTermsPopup.start()) {
            int terms = this.termsKeyPad.getValueAsInt();
            AbstractDebtor.Terms newTerms = new AbstractDebtor.Terms(terms);
            this.theDebtor.setTermsValue(newTerms);
            this.gui.setTerms(newTerms);
        }
        this.resume();
    }

    public void gotCustomer(Customer newCustomer) {
        if (!this.theDebtor.canAddCustomer()) {
            throw new IllegalArgumentException("Could not set customer for this debtor type " + this.theDebtor.getType());
        }
        this.theDebtor = this.theDebtor.addCustomer(newCustomer);
        this.start(this.theDebtor);
    }

    public void setCreditLimit() {
        double newLimit = Dialogs.getPriceDouble((String)"", (double)this.theDebtor.getCreditLimit().doubleValue());
        if (newLimit != Double.MIN_VALUE) {
            Price creditLimit = new Price(newLimit);
            this.theDebtor.setCreditLimit(creditLimit);
            this.gui.setCreditLimit(creditLimit);
        }
        this.resume();
    }

    public void setAccountName(String newName) {
        this.theDebtor.setLabel(newName);
        this.gui.setRequiredFields((RequiredFields)this.theDebtor);
    }

    public void setNoteRequired(Boolean required) {
        this.theDebtor.setNoteRequired(required.booleanValue());
    }
}

