/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.debtor.adddebtor;

import au.com.ordermate.util.Price;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import ordermate.database.RequiredFields;
import ordermate.database.finance.debtors.AbstractDebtor;
import ordermate.database.finance.debtors.group.DebtorGroup;
import ordermate.database.finance.debtors.implementation.CustomerDebtor;
import ordermate.database.finance.debtors.implementation.SimpleDebtor;
import ordermate.database.sales.Customer;
import ordermate.database.users.AllPermissions;
import ordermate.gui.modify.security.SecurityButtonDecorator;
import ordermate.gui.modify.security.StandardSecurityDecorator;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import waitermate.gui.mandatory.AbstractInfoPanelTSFriendly;
import waitermate.guikit.components.CustomCheckButton;

public class AddDebtorPanel
extends AbstractInfoPanelTSFriendly {
    private JToggleButton accountName;
    private JToggleButton creditLimit;
    private JToggleButton debtorGroup;
    private JLabel customerLabel;
    private JLabel termsLabel;
    private AbstractDebtor debtor;
    private boolean newDebtorGroup;
    private SecurityButtonDecorator customerButtonDecorator;
    private SecurityButtonDecorator termsButtonDecorator;
    public final Signal setGroup = Signals.createSignal();
    public final Signal newGroup = Signals.createSignal(String.class, (String)"new debtor group");
    public final Signal newCustomer = Signals.createSignal();
    public final Signal changeTerms = Signals.createSignal();
    public final Signal setCreditLimit = Signals.createSignal();
    public final Signal setAccountName = Signals.createSignal(String.class, (String)"Account Name");
    public final Signal<Boolean, ?, ?, ?, ?> setNoteRequired = Signals.createSignal(Boolean.class, (String)"noteRequired");
    private final CustomCheckButton requiresNote;

    public AddDebtorPanel() {
        super("Add a new debtor account");
        this.debtor = new SimpleDebtor();
        this.autoCompletePanel.setVisible(false);
        this.accountName = this.constructButton("", AbstractDebtor.Properties.LABEL);
        this.creditLimit = this.constructButton("", AbstractDebtor.Properties.CREDIT_LIMIT);
        this.debtorGroup = this.constructButton("", AbstractDebtor.Properties.GROUP);
        this.requiresNote = new CustomCheckButton();
        this.requiresNote.setName("requiresNote");
        this.requiresNote.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        AddDebtorPanel.this.setNoteRequired.emit((Object)AddDebtorPanel.this.requiresNote.isSelected());
                    }
                });
            }
        });
        this.customerButtonDecorator = new SecurityButtonDecorator((AbstractButton)this.constructButton("", CustomerDebtor.Properties.CUSTOMER), AllPermissions.DEBTOR_SET_CUSTOMER);
        this.termsButtonDecorator = new SecurityButtonDecorator((AbstractButton)this.constructButton("", CustomerDebtor.Properties.TERMS), AllPermissions.DEBTOR_SET_TERMS);
        JLabel accountLabel = new JLabel("Account Name:", 4);
        JLabel creditLabel = new JLabel("Credit Limit:", 4);
        JLabel requiresNoteLabel = new JLabel("Invoice requires note:", 4);
        this.customerLabel = new JLabel("Customer:", 4);
        this.termsLabel = new JLabel("Terms:", 4);
        this.add((Component)accountLabel, new Rectangle(1, 1, 4, 4));
        this.add((Component)new StandardSecurityDecorator((JComponent)this.accountName, AllPermissions.DEBTOR_EDIT_DETAILS), new Rectangle(5, 1, 4, 4));
        this.add((Component)new JLabel("Account Group:", 4), new Rectangle(1, 6, 4, 4));
        this.add((Component)new StandardSecurityDecorator((JComponent)this.debtorGroup, AllPermissions.DEBTOR_EDIT_DETAILS), new Rectangle(5, 6, 4, 4));
        this.add((Component)creditLabel, new Rectangle(1, 11, 4, 4));
        this.add((Component)new StandardSecurityDecorator((JComponent)this.creditLimit, AllPermissions.CHANGE_CREDIT_LIMIT), new Rectangle(5, 11, 4, 4));
        this.add((Component)requiresNoteLabel, new Rectangle(1, 16, 4, 4));
        this.add((Component)new StandardSecurityDecorator((JComponent)this.requiresNote, AllPermissions.DEBTOR_EDIT_DETAILS), new Rectangle(5, 16, 4, 4));
        this.setSelectedButton(this.accountName);
        this.setFieldsRequired(AbstractDebtor.REQUIRED_FIELDS);
    }

    public void setDebtor(AbstractDebtor theDebtor) {
        this.debtor = theDebtor;
        this.setRequiredFields((RequiredFields)this.debtor);
        this.accountName.setText(this.debtor.getLabel());
        this.creditLimit.setText(this.debtor.getCreditLimit().toString());
        this.requiresNote.setSelected(this.debtor.isNoteRequired());
        this.setDebtorGroup(this.debtor.getGroup());
        if (this.debtor.hasCustomer()) {
            this.setCustomer(((CustomerDebtor)this.debtor).getCustomer());
        } else {
            this.setCustomer(null);
            this.remove((Component)this.customerButtonDecorator);
            this.remove(this.customerLabel);
        }
        if (this.debtor.hasTerms()) {
            this.setTerms(this.debtor.getTermsValue());
        } else {
            this.remove(this.termsLabel);
            this.remove((Component)this.termsButtonDecorator);
        }
        this.setSelectedButton(this.accountName);
        this.invalidate();
    }

    public String getDebtorGroup() {
        return this.debtorGroup.getText();
    }

    public void setDebtorGroup(DebtorGroup group) {
        if (group == null) {
            this.debtorGroup.setText("");
            this.theKeyboard.clear();
            this.theKeyboard.enableKeys(true);
            this.newDebtorGroup = true;
        } else {
            this.debtorGroup.setText(group.getLabel());
            this.newDebtorGroup = false;
        }
        this.doRequiredFieldsVisualFeedback();
    }

    public void setCreditLimit(Price newLimit) {
        this.creditLimit.setText(newLimit.toString());
    }

    public String getAccountName() {
        return this.accountName.getText();
    }

    protected void setRequiredFields(RequiredFields theFields) {
        this.debtor = (AbstractDebtor)theFields;
    }

    @Override
    protected RequiredFields getRequiredObject() {
        return this.debtor;
    }

    @Override
    protected void doAutoSuggest(String suggestFrom) {
    }

    @Override
    public boolean hasPanelMetRequirements() {
        return this.getRequiredObject().getMeetsRequirements(this.getFieldsRequired());
    }

    public void setTerms(AbstractDebtor.Terms terms) {
        this.termsButtonDecorator.getButton().setText(terms.toString());
        if (this.termsButtonDecorator.getParent() == null) {
            this.add((Component)this.termsLabel, new Rectangle(9, 1, 4, 4));
            this.add((Component)this.termsButtonDecorator, new Rectangle(13, 1, 4, 4));
        }
        this.doRequiredFieldsVisualFeedback();
    }

    public void removeTerms() {
        this.termsButtonDecorator.getButton().setText("");
        this.remove(this.termsLabel);
        this.remove((Component)this.termsButtonDecorator);
    }

    public void setCustomer(Customer customer) {
        if (customer != null) {
            this.customerButtonDecorator.getButton().setText(customer.getLabel());
            if (this.customerButtonDecorator.getParent() == null) {
                this.add((Component)this.customerLabel, new Rectangle(9, 6, 4, 4));
                this.add((Component)this.customerButtonDecorator, new Rectangle(13, 6, 4, 9));
            }
        } else {
            this.customerButtonDecorator.getButton().setText("");
            this.remove((Component)this.customerButtonDecorator);
            this.remove(this.customerLabel);
        }
        this.doRequiredFieldsVisualFeedback();
    }

    @Override
    protected void newInput() {
        if (this.getTarget().equals(this.accountName)) {
            this.setAccountName.emit((Object)this.accountName.getText());
        } else if (this.newDebtorGroup && this.getTarget().equals(this.debtorGroup)) {
            this.newGroup.emit((Object)this.debtorGroup.getText());
        }
        super.newInput();
    }

    @Override
    protected void setSelectedButton(AbstractButton button) {
        super.setSelectedButton(button);
        if (button == this.debtorGroup) {
            this.theKeyboard.enableKeys(false);
            this.setGroup.emit();
        } else if (button == this.creditLimit) {
            this.theKeyboard.enableKeys(false);
            this.setCreditLimit.emit();
        } else if (button == this.customerButtonDecorator.getButton()) {
            this.theKeyboard.enableKeys(false);
            this.newCustomer.emit();
        } else if (button == this.termsButtonDecorator.getButton()) {
            this.theKeyboard.enableKeys(false);
            this.changeTerms.emit();
        } else {
            this.theKeyboard.enableKeys(true);
        }
    }
}

