/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.debtor.components;

import java.awt.Component;
import java.util.Calendar;
import java.util.Date;
import ordermate.database.finance.debtors.AbstractDebtor;
import ordermate.database.finance.debtors.DebtorConfig;
import ordermate.database.finance.debtors.implementation.CustomerDebtor;
import waitermate.gui.screens.debtor.components.AbstractDebtorInfoPanel;
import waitermate.gui.screens.debtor.components.SelectDebtorButtonRenderer;

public class DebtorInfoPanel
extends AbstractDebtorInfoPanel {
    private final SelectDebtorButtonRenderer renderer = new SelectDebtorButtonRenderer();

    public DebtorInfoPanel(AbstractDebtor debtor) {
        super("Debtor Info", debtor, true);
        this.renderer.setupComponent((Component)this.getDebtorNameButton(), debtor, 0);
    }

    @Override
    public void setDebtor(AbstractDebtor newDebtor) {
        super.setDebtor(newDebtor);
        if (this.renderer != null) {
            this.renderer.setupComponent((Component)this.getDebtorNameButton(), newDebtor, 0);
        }
    }

    @Override
    protected void updateButtonState() {
        if (this.getDebtor() instanceof CustomerDebtor) {
            CustomerDebtor custDebtor = (CustomerDebtor)this.getDebtor();
            this.setCustomerData(custDebtor.getCustomer());
        } else {
            this.setVisibleCustomerFieldPanel(false);
            this.setCustomerData(null);
        }
    }

    protected void resetDateFilter() {
        Calendar cal = Calendar.getInstance();
        cal.add(5, Integer.parseInt(DebtorConfig.getInstance().getDaysPaidSalesToShow()) * -1);
        this.setDateFilter(new Date(cal.getTime().getTime()));
    }

    @Override
    public void setAccountName(String name) {
    }
}

