/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.debtor.components;

import au.com.ordermate.util.Price;
import java.awt.GridLayout;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import ordermate.database.finance.debtors.AbstractDebtor;
import ordermate.database.finance.debtors.DebtorsSummary;
import ordermate.gui.themes.OrderMateTheme;

public class DebtorSummaryPanel
extends JPanel {
    JLabel outstandingLabel = new JLabel();
    JLabel overdueLabel = new JLabel();
    DebtorsSummary summary;

    public DebtorSummaryPanel() {
        this.setLayout(new GridLayout(3, 1, 10, 10));
        JLabel title = new JLabel("Debtors Summary");
        title.setFont(OrderMateTheme.getLargeFont());
        this.add(title);
        this.add(this.outstandingLabel);
        this.add(this.overdueLabel);
    }

    public void summarize(AbstractDebtor debtor) {
        ArrayList<AbstractDebtor> debtors = new ArrayList<AbstractDebtor>(1);
        debtors.add(debtor);
        this.summarize(debtors);
    }

    public void summarize(List debtors) {
        this.summary = DebtorsSummary.summarize((List)debtors);
        this.updateGui();
    }

    private void updateGui() {
        this.outstandingLabel.setText("Total: " + this.summary.getOutstanding().toString());
        if (!this.summary.getOverdue().equals((Object)Price.ZERO)) {
            this.overdueLabel.setText("Overdue: " + this.summary.getOverdue().toString());
        } else {
            this.overdueLabel.setText("Overdue: NONE");
        }
    }
}

