/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.debtor.debtortransactions;

import au.com.ordermate.util.Price;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import ordermate.database.finance.debtors.AbstractDebtor;
import ordermate.database.reports.debtor.DebtorOutstandingItemsReport;

class DebtorDocketHelper {
    DebtorDocketHelper() {
    }

    protected static String buildDocketXML(AbstractDebtor debtor, List<DebtorOutstandingItemsReport> allUnpaidItems) {
        StringBuilder docketText = new StringBuilder();
        docketText.append("Outstanding Debtor Sales Report");
        docketText.append("\n\n");
        docketText.append("Debtor Name: ").append(debtor.getLabel());
        docketText.append("\n\n");
        double totalValue = 0.0;
        for (DebtorOutstandingItemsReport report : allUnpaidItems) {
            docketText.append(report.getQty()).append(" x ").append(report.getInventoryItem().getLabel()).append(" - ").append(report.getTotalPrice());
            docketText.append("\n");
            totalValue += report.getTotalPrice().doubleValue();
        }
        docketText.append("\n\n").append("Total: ").append(new Price(totalValue, 0.01)).append("\n\n").append("Some items shown may be partially paid.");
        SimpleDateFormat dateFormat = new SimpleDateFormat("dd-MM-yyyy");
        SimpleDateFormat timeFormat = new SimpleDateFormat("h:mm a");
        Date currentTime = new Date();
        docketText.append("\n\n" + dateFormat.format(currentTime) + " " + timeFormat.format(currentTime) + "\n");
        docketText.append("Powered By OrderMate www.ordermate.com.au\n");
        return docketText.toString();
    }
}

