/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.debtor.debtortransactions;

import au.com.ordermate.gui.GraphPaperLayout;
import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.util.DateTimeUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.util.Date;
import javax.swing.JLabel;
import javax.swing.JPanel;
import ordermate.database.finance.debtors.AbstractDebtor;
import ordermate.database.finance.debtors.transactions.DebtorPayment;
import ordermate.database.finance.debtors.transactions.DebtorSale;
import ordermate.database.reports.general.PriceReport;
import ordermate.gui.scroll.CustomScrollPane;
import ordermate.gui.scroll.CustomScrollPaneModel;
import ordermate.gui.themes.OrderMateTheme;
import waitermate.gui.screens.debtor.components.DebtorSnapShotSideBar;
import waitermate.gui.screens.debtor.debtortransactions.DebtorHistoryModel;

class DebtorTransactionPanel
extends JPanel {
    private CustomScrollPane scrollPane;
    private final DebtorSnapShotSideBar sideBar = new DebtorSnapShotSideBar();
    private final JLabel totalSalesLabel;
    private final JLabel totalPaymentsLabel;

    DebtorTransactionPanel(DebtorHistoryModel model) {
        super((LayoutManager)new GraphPaperLayout(new Dimension(4, 12), 0, 0));
        this.sideBar.setName("debtorTxnSideBar");
        this.sideBar.setInitialDate(DateTimeUtils.addTime((Date)new Date(), (int)2, (int)-1));
        this.add((Component)this.sideBar, new Rectangle(0, 0, 1, 11));
        this.scrollPane = new CustomScrollPane((CustomScrollPaneModel)model);
        this.scrollPane.setName("debtorTranListPane");
        this.add((Component)this.scrollPane, new Rectangle(1, 1, 3, 10));
        JPanel titlePanel = new JPanel((LayoutManager)new GraphPaperLayout(new Dimension(100, 1)));
        JLabel salesLabel = new JLabel("Sales");
        salesLabel.setFont(OrderMateTheme.getLargeFont());
        JLabel paymentsLabel = new JLabel("Payments");
        paymentsLabel.setFont(OrderMateTheme.getLargeFont());
        JLabel balanceLabel = new JLabel("Balance");
        balanceLabel.setFont(OrderMateTheme.getLargeFont());
        titlePanel.add((Component)salesLabel, new Rectangle(15, 0, 20, 1));
        titlePanel.add((Component)paymentsLabel, new Rectangle(60, 0, 20, 1));
        titlePanel.add((Component)balanceLabel, new Rectangle(85, 0, 15, 1));
        this.add((Component)titlePanel, new Rectangle(1, 0, 3, 1));
        JPanel totalsHolder = new JPanel((LayoutManager)new GraphPaperLayout(new Dimension(100, 1)));
        this.totalPaymentsLabel = new JLabel("Total Payments: ");
        this.totalSalesLabel = new JLabel("Total Sales: ");
        this.totalPaymentsLabel.setName("totalPayments");
        this.totalPaymentsLabel.setForeground(Color.gray);
        this.totalSalesLabel.setName("totalSales");
        this.totalSalesLabel.setForeground(Color.gray);
        totalsHolder.add((Component)this.totalSalesLabel, new Rectangle(15, 0, 20, 1));
        totalsHolder.add((Component)this.totalPaymentsLabel, new Rectangle(60, 0, 20, 1));
        this.add((Component)totalsHolder, new Rectangle(1, 11, 3, 1));
    }

    void setDebtor(AbstractDebtor debtor) {
        ObjectQuery query = Query.select((PropertiedObject.Property)DebtorPayment.Properties.ID, (String)"ID").sum(DebtorPayment.Properties.AMOUNT, "price").equals(DebtorPayment.Properties.DEBTOR, (Object)debtor);
        PriceReport paid = (PriceReport)PersistenceManager.getObject(PriceReport.class, (String)query.toString());
        this.totalPaymentsLabel.setText("Total Payments: " + paid.getPrice());
        query = Query.select((PropertiedObject.Property)DebtorSale.Properties.ID, (String)"ID").sum(DebtorSale.Properties.TOTAL, "price").equals(DebtorSale.Properties.DEBTOR, (Object)debtor);
        PriceReport sales = (PriceReport)PersistenceManager.getObject(PriceReport.class, (String)query.toString());
        this.totalSalesLabel.setText("Total Sales: " + sales.getPrice());
    }

    DebtorSnapShotSideBar getSideBar() {
        return this.sideBar;
    }

    CustomScrollPane getScrollPane() {
        return this.scrollPane;
    }
}

