/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.debtor.debtortransactions;

import au.com.ordermate.OrderMateLog;
import au.com.ordermate.oquery.search.ObjectQuerySearcher;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PersistentObjectI;
import au.com.ordermate.units.SalesQuantity;
import au.com.ordermate.util.Price;
import au.com.ordermate.xmlintegration.piggy.GuestSuggestion;
import au.com.ordermate.xmlintegration.piggy.SearchType;
import java.awt.Component;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import ordermate.OrderMate;
import ordermate.database.EventContext;
import ordermate.database.Lockable;
import ordermate.database.finance.CreditLimited;
import ordermate.database.finance.debtors.AbstractDebtor;
import ordermate.database.finance.debtors.DebtorPaymentAgent;
import ordermate.database.finance.debtors.DebtorPaymentRefundAgent;
import ordermate.database.finance.debtors.DebtorSalesRefundAgent;
import ordermate.database.finance.debtors.DebtorTransferAgent;
import ordermate.database.finance.debtors.implementation.CustomerDebtor;
import ordermate.database.finance.debtors.implementation.RoomAccount;
import ordermate.database.finance.debtors.transactions.DebtorPayment;
import ordermate.database.finance.debtors.transactions.DebtorSale;
import ordermate.database.finance.transactions.FinanceTransaction;
import ordermate.database.finance.transactions.FinanceTransactionContext;
import ordermate.database.hardware.Terminal;
import ordermate.database.hardware.VirtualPrinter;
import ordermate.database.misc.SystemCurrentInfo;
import ordermate.database.misc.SystemProperty;
import ordermate.database.misc.enums.PropertyIntegrationType;
import ordermate.database.sales.Account;
import ordermate.database.sales.AccountType;
import ordermate.database.sales.Customer;
import ordermate.database.sales.RefundAccount;
import ordermate.database.sales.SalesItemQuantity;
import ordermate.database.sales.SalesLineItem;
import ordermate.database.sales.Sellable;
import ordermate.database.sales.SellableWrapperFactory;
import ordermate.database.searchers.reports.debtor.DebtorOutstandingItemsReportSearcher;
import ordermate.database.users.User;
import ordermate.docketprocessor.DocketProcessor;
import ordermate.gui.SaveAccount;
import ordermate.gui.button.CustomButton;
import ordermate.gui.scroll.AbstractScrollPaneModel;
import ordermate.integration.piggy.PiggyResult;
import ordermate.integration.piggy.PiggyService;
import ordermate.integration.piggy.PiggyServiceBuilder;
import ordermate.integration.piggy.PiggyServiceProvider;
import ordermate.services.finance.debtors.DebtorDateFilterStrategy;
import ordermate.services.finance.debtors.DebtorSalesFilter;
import ordermate.services.finance.debtors.StatusDebtorSalesFilter;
import ordermate.signals.Signal;
import waitermate.LoginManager;
import waitermate.WaiterMate;
import waitermate.gui.dialogs.DateSelectDialog;
import waitermate.gui.dialogs.UnlockDialog;
import waitermate.gui.screens.customer.add.AddCustomer;
import waitermate.gui.screens.debtor.adddebtor.AddDebtor;
import waitermate.gui.screens.debtor.debtortransactions.DebtorDocketHelper;
import waitermate.gui.screens.debtor.debtortransactions.DebtorHistoryModel;
import waitermate.gui.screens.debtor.debtortransactions.DebtorHistoryRenderer;
import waitermate.gui.screens.debtor.debtortransactions.DebtorTransactionNav;
import waitermate.gui.screens.debtor.debtortransactions.DebtorTransactionPanel;
import waitermate.gui.screens.ordering.saveaccount.WaitermateSaveAccount;
import waitermate.gui.screens.ordering.transferitems.selectitems.SelectItems;
import waitermate.gui.screens.payment.debtorTransaction.DebtorTransaction;
import waitermate.gui.screens.payment.transactions.CreditLimitPanel;
import waitermate.gui.screens.payment.transactions.DebtorPaymentScreen;
import waitermate.guikit.AbstractScreen;
import waitermate.guikit.NavBar;
import waitermate.guikit.NotificationManager;
import waitermate.guikit.dialogs.Dialogs;
import waitermate.guikit.dialogs.OnePressPopupWindow;
import waitermate.guikit.showitem.ShowItemsUtils;

public class DebtorTransactionsScreen
extends AbstractScreen {
    private AbstractDebtor debtor = null;
    private RefundAccount refund = null;
    private final DebtorTransactionNav nav;
    private final DebtorTransactionPanel txnPanel;
    private final DebtorPaymentScreen paymentScreen = new DebtorPaymentScreen();
    private final Signal debtorScreenCancelled = DebtorTransaction.createCancelledSignal();
    private final Signal debtorSelected = DebtorTransaction.createDebtorSelectedSignal();
    private final SelectItems refundSelectItems = new SelectItems();
    private AddCustomer editCustomerScreen;
    private final AddDebtor editDebtorScreen = new AddDebtor();
    private final DebtorHistoryModel model;
    private final DebtorHistoryRenderer renderer;
    private PiggyService piggyService;
    private SellableWrapperFactory sellableFactory = new SellableWrapperFactory();
    private String dateFormat = "yyyy-MM-dd'T'HH:mm:ss";
    private SimpleDateFormat sdf = new SimpleDateFormat(this.dateFormat);

    public DebtorTransactionsScreen() {
        this.nav = new DebtorTransactionNav();
        this.renderer = new DebtorHistoryRenderer();
        this.model = new DebtorHistoryModel(this.renderer);
        this.txnPanel = new DebtorTransactionPanel(this.model);
        this.txnPanel.getSideBar().getInfoPanel().customerSignal.connect((Object)this, "gotEditCustomer");
        this.txnPanel.getSideBar().getInfoPanel().debtorSignal.connect((Object)this, "gotEditDebtor");
        this.txnPanel.getSideBar().getInfoPanel().dateChangedSignal.connect((Object)this, "gotDateFilterChanged");
        this.editDebtorScreen.saveDebtorSignal.connect((Object)this, "start");
        this.editDebtorScreen.backSignal.connect((Object)this, "gotBack");
        this.nav.viewDetailsSignal.connect((Object)this, "gotViewDetails");
        this.nav.selectAllSignal.connect((Object)this, "gotSelectAll");
        this.nav.selectNoneSignal.connect((Object)this, "gotSelectNone");
        this.nav.back.connect((Object)this, "unlock");
        this.nav.paySignal.connect((Object)this, "gotPay");
        this.paymentScreen.back.connect((Object)this, "gotBack");
        this.paymentScreen.doneSignal.connect((Object)this, "gotDone");
        this.nav.transferSignal.connect((Object)this, "gotTransferStart");
        this.debtorScreenCancelled.connect((Object)this, "gotBack");
        this.debtorSelected.connect((Object)this, "gotTransferComplete");
        this.nav.refundSignal.connect((Object)this, "gotRefundStart");
        this.refundSelectItems.items.connect((Object)this, "gotRefundSalesComplete");
        this.refundSelectItems.back.connect((Object)this, "gotBack");
        this.nav.paymentStatusFilter.connect((Object)this, "gotPaymentStatusFilter");
        this.nav.printStmtSignal.connect((Object)this, "gotPrintStatement");
        this.nav.printActStmtSignal.connect((Object)this, "gotPrintActivityStatement");
        this.nav.printOutstandingItemsSignal.connect((Object)this, "gotPrintOutstandingItems");
        if (SystemProperty.getInstance().getPropertyIntegration().equals((Object)PropertyIntegrationType.PIGGY)) {
            this.nav.viewReservationDetailSignal.connect((Object)this, "gotViewReservationDetail");
            this.initPiggyService();
        }
        NotificationManager.getInstance().newUserSignal.connect((Object)this, "gotNewUser");
    }

    private void initPiggyService() {
        PiggyServiceBuilder piggyServiceBuilder = new PiggyServiceBuilder().setStoreId(Long.valueOf(SystemCurrentInfo.getInstance().getRedbackId()));
        PiggyServiceProvider.setPiggyServiceBuilder((PiggyServiceBuilder)piggyServiceBuilder);
        this.piggyService = PiggyServiceProvider.getPiggyService();
    }

    public void start(AbstractDebtor newDebtor) {
        this.debtor = newDebtor;
        this.nav.setupPayButton(LoginManager.getInstance().getUser());
        AbstractDebtor localDebtor = (AbstractDebtor)PersistenceManager.reacquire((PersistentObjectI)this.debtor);
        PersistenceManager.preloadFKListReferences((PersistentObject)localDebtor, (Class[])new Class[0]);
        this.setAndRelockDebtor(localDebtor);
        this.display();
    }

    private void setAndRelockDebtor(AbstractDebtor newDebtor) {
        newDebtor.relock(LoginManager.getInstance().getUser());
        this.debtor = newDebtor;
        this.txnPanel.getSideBar().setDebtor(this.debtor);
    }

    public void setDebtor(AbstractDebtor newDebtor) {
        this.setAndRelockDebtor(newDebtor);
        this.updateModel();
        this.display();
    }

    protected AbstractDebtor getDebtor() {
        return this.debtor;
    }

    public JComponent getMainArea() {
        return this.txnPanel;
    }

    public NavBar getNavBar() {
        return this.nav;
    }

    public void gotEditCustomer() {
        Customer customer = new Customer();
        if (this.debtor instanceof CustomerDebtor) {
            CustomerDebtor customerDebtor = (CustomerDebtor)this.debtor;
            customer = customerDebtor.getCustomer();
        }
        if (this.editCustomerScreen == null) {
            this.editCustomerScreen = new AddCustomer();
            this.editCustomerScreen.back.connect((Object)this, "gotBack");
            this.editCustomerScreen.customerSaved.connect((Object)this, "gotCustomer");
        }
        this.editCustomerScreen.edit(customer);
    }

    public void gotEditDebtor() {
        this.editDebtorScreen.start(this.debtor);
    }

    public void gotBack() {
        this.reaquireDebtor();
        this.updateModel();
        this.display();
    }

    public void gotDone() {
        this.reaquireDebtor();
        this.updateModel();
        this.setDebtor(this.debtor);
    }

    public void gotCustomer(Customer customer) {
        if (this.debtor instanceof CustomerDebtor) {
            ((CustomerDebtor)this.debtor).setCustomer(customer);
        } else if (customer != null) {
            this.debtor = new CustomerDebtor(customer, this.debtor);
        }
        this.debtor.save();
        this.display();
    }

    public void gotViewDetails() {
        List<DebtorPayment> selectedPayments = this.renderer.getSelectedPayments();
        if (selectedPayments.size() > 0) {
            new ShowItemsUtils((SaveAccount)WaitermateSaveAccount.getInstance()).showDebtorFinanceTransactions(this.getDebtor(), selectedPayments);
        } else {
            ArrayList<DebtorSale> selectedSales = new ArrayList<DebtorSale>(this.renderer.getSelectedSales());
            new ShowItemsUtils((SaveAccount)WaitermateSaveAccount.getInstance()).showDebtorAccounts(selectedSales);
        }
    }

    public void gotSelectAll() {
        this.model.selectAllSales(true);
    }

    public void gotSelectNone() {
        this.model.selectAllSales(false);
        this.model.selectAllPayments(false);
    }

    public void updateModel() {
        if (this.debtor != null) {
            List<DebtorSale> filteredSales = this.getFilteredPaidSales(this.debtor);
            filteredSales.addAll(this.getFilteredUnpaidSales(this.debtor));
            this.model.setData(filteredSales, this.debtor.getUnsettledPayments(), new Price(0.0, 0.0));
        } else {
            this.model.setObjects(new ArrayList());
        }
        this.txnPanel.setDebtor(this.debtor);
        this.txnPanel.getScrollPane().displayLastPage();
        if ("ROOM".equals(this.debtor.getType())) {
            this.nav.enablePayButton(false);
        } else {
            this.nav.enablePayButton(true);
        }
    }

    private List<DebtorSale> getFilteredPaidSales(AbstractDebtor debtor) {
        StatusDebtorSalesFilter filter = this.getDefaultDebtorFilter();
        filter.setDateFilterStrategy(DebtorDateFilterStrategy.InvoiceDate);
        filter.setDate(this.txnPanel.getSideBar().getStartDateFilter());
        filter.setEndDate(new Date());
        return debtor.getFilteredPaidSales((DebtorSalesFilter)filter);
    }

    private StatusDebtorSalesFilter getDefaultDebtorFilter() {
        StatusDebtorSalesFilter filter = new StatusDebtorSalesFilter();
        filter.setPaymentStatus(this.nav.getSelectedPaymentStatus());
        return filter;
    }

    private List<DebtorSale> getFilteredUnpaidSales(AbstractDebtor debtor) {
        StatusDebtorSalesFilter filter = this.getDefaultDebtorFilter();
        return debtor.getFilteredUnpaidSales((DebtorSalesFilter)filter);
    }

    public void refreshModel() {
        this.model.refresh();
    }

    public void gotPay() {
        DebtorPaymentAgent agent = new DebtorPaymentAgent(this.debtor);
        if (this.renderer.getSelectedSales().isEmpty()) {
            agent.setSelectedSales((Collection)this.debtor.getUnpaidSales());
        } else {
            agent.setSelectedSales(this.renderer.getSelectedSales());
        }
        this.paymentScreen.startTransactions(agent);
    }

    public void gotRefundStart() {
        if (this.renderer.getSelectedSales().size() != 0) {
            this.doRefundSales();
        } else if (this.renderer.getSelectedPayments().size() != 0) {
            this.doRefundPayments();
        } else {
            Dialogs.displayOkDialog((String)"Select the sales or payments that you want to refund.", (String)"No sales selected.");
        }
    }

    public void doRefundSales() {
        boolean showPartialRefundWarning = false;
        boolean showRefundingRefundWarning = false;
        String partialRefundWarning = "Some of the items in the selected sales have already been refunded.";
        String refundingRefundWarning = "<HTML>You are attempting to refund a refund transaction.<P>Instead, please pay the items through to the debtor.</HTML>";
        Iterator<DebtorSale> debtorSalesIt = this.renderer.getSelectedSales().iterator();
        ArrayList<SalesLineItem> itemList = new ArrayList<SalesLineItem>();
        while (debtorSalesIt.hasNext()) {
            DebtorSale debtorSale = debtorSalesIt.next();
            if (debtorSale.hasAllRefunded()) {
                String message = "<HTML>One of the selected sales has already been entirely refunded.<P>Cannot refund it again.</HTML>";
                Dialogs.displayOkDialog((String)"<HTML>One of the selected sales has already been entirely refunded.<P>Cannot refund it again.</HTML>", (String)"Cannot refund sale again.");
                return;
            }
            Account account = debtorSale.getSaleAccount();
            if (debtorSale.getTotal().compareTo(account.getTotal()) < 0) {
                String message = "<HTML>One of the selected sales was partitally paid by Room Account.<P>Cannot refund partial payments.</HTML>";
                Dialogs.displayOkDialog((String)"<HTML>One of the selected sales was partitally paid by Room Account.<P>Cannot refund partial payments.</HTML>", (String)"Cannot refund partial payments.");
                return;
            }
            if (debtorSale.getSaleAccount().getAccountType().equals((Object)AccountType.refundType)) {
                showRefundingRefundWarning = true;
            } else if (debtorSale.hasSomeRefunded()) {
                showPartialRefundWarning = true;
            }
            List items = debtorSale.getSaleAccount().getItems();
            for (SalesLineItem item : items) {
                SalesQuantity nonRefundedQty = SalesQuantity.ZERO;
                for (SalesItemQuantity qty : item.getSalesItemQuantities()) {
                    if (qty.isRefunded()) continue;
                    nonRefundedQty = nonRefundedQty.add(qty.getQuantity());
                }
                if (!nonRefundedQty.notEquals(SalesQuantity.ZERO)) continue;
                itemList.add(item);
            }
        }
        if (showRefundingRefundWarning) {
            Dialogs.displayOkDialog((String)"<HTML>You are attempting to refund a refund transaction.<P>Instead, please pay the items through to the debtor.</HTML>", (String)"Cannot refund a refund.");
            return;
        }
        if (showPartialRefundWarning && !Dialogs.displayChoiceDialog((String)"Some of the items in the selected sales have already been refunded.", (String)"Do you want to proceed?", (boolean)true)) {
            return;
        }
        this.refundSelectItems.startSelection((List<Sellable>)this.sellableFactory.getSellables(itemList), "Select the items to refund");
    }

    public void doRefundPayments() {
        if (this.renderer.getSelectedPayments().size() != 0) {
            ArrayList<FinanceTransaction> txns = new ArrayList<FinanceTransaction>();
            for (DebtorPayment nextPayment : this.renderer.getSelectedPayments()) {
                FinanceTransaction nextTran = nextPayment.getFinanceTransaction();
                if (nextTran.isRefundedDebtorPayment()) {
                    Dialogs.displayOkDialog((String)"Cannot refund a payment that has already been refunded", (String)"Cannot refund payment");
                    return;
                }
                if (nextTran.getPaid().lessThan((Object)Price.ZERO_DOLLAR)) {
                    Dialogs.displayOkDialog((String)"Cannot refund a payment that is refunding another payment.", (String)"Cannot refund payment");
                    return;
                }
                txns.add(nextTran);
            }
            DebtorPaymentRefundAgent agent = new DebtorPaymentRefundAgent(this.debtor);
            agent.refundFinanceTransactions(txns, LoginManager.getEventContext());
            this.paymentScreen.startTransactions(agent);
        }
    }

    public void gotRefundSalesComplete(Set<Sellable> setToRefund) {
        DebtorSalesRefundAgent agent = new DebtorSalesRefundAgent(this.debtor, this.renderer.getSelectedSales());
        ArrayList<SalesLineItem> itemsToRefund = new ArrayList<SalesLineItem>();
        for (Sellable sellable : setToRefund) {
            if (!(sellable.getSellingObject() instanceof SalesLineItem)) continue;
            itemsToRefund.add((SalesLineItem)sellable.getSellingObject());
        }
        if (SystemProperty.getInstance().getPropertyIntegration().equals((Object)PropertyIntegrationType.PIGGY)) {
            if (this.debtor.getType().equals("ROOM")) {
                RoomAccount roomAccount = (RoomAccount)this.debtor;
                GuestSuggestion guestSuggestion = new GuestSuggestion();
                guestSuggestion.setRoomAccountId(roomAccount.getRoomAccountID());
                guestSuggestion.setGuestName(roomAccount.getName());
                guestSuggestion.setGuestNumber(roomAccount.getGroup().getLabel());
                PiggyResult piggyResult = this.piggyService.refundSale(roomAccount.getID(), guestSuggestion, itemsToRefund);
                if (!piggyResult.isSuccess()) {
                    Dialogs.displayOkDialog((String)"Please try it again later", (String)"Refund the sales in the third party faild ");
                    return;
                }
            }
        }
        FinanceTransactionContext context = new FinanceTransactionContext(LoginManager.getEventContext());
        this.refund = agent.createRefundAccount(itemsToRefund, (EventContext)context);
        String debtorNote = "";
        if (this.debtor.isNoteRequired()) {
            debtorNote = Dialogs.getString((String)"Enter note:");
        }
        agent.addRefundSale(this.refund, itemsToRefund, context, debtorNote);
        agent.refund();
        this.refund.unlock();
        this.refund = null;
        this.txnPanel.getSideBar().setDebtor(this.debtor);
        this.updateModel();
        this.display();
    }

    public void gotTransferStart() {
        if (this.renderer.getSelectedSales().size() != 0) {
            DebtorTransaction.getInstance().start(null, this.debtorScreenCancelled, this.debtorSelected, null, null, "Select debtor to transfer to");
        } else if (this.renderer.getSelectedPayments().size() != 0) {
            boolean doTransfer;
            Price paymentTotal = Price.ZERO_DOLLAR;
            for (DebtorPayment payment : this.renderer.getSelectedPayments()) {
                paymentTotal = paymentTotal.add(payment.getFinanceTransaction().getPaid());
            }
            boolean bl = doTransfer = !this.debtor.exceedsCreditLimit(paymentTotal) || CreditLimitPanel.doCreditLimitDialog((CreditLimited)this.debtor, this.debtor.getAmountOutstanding().add(paymentTotal), this.debtor.getLabel(), true, "Payment transfer exceeds credit limit of " + this.debtor.getLabel());
            if (doTransfer) {
                DebtorTransaction.getInstance().start(null, this.debtorScreenCancelled, this.debtorSelected, null, null, "Select debtor to transfer to");
            }
        } else {
            Dialogs.displayOkDialog((String)"Please select the debtor sales to transfer.", (String)"No debtor sales selected.");
        }
    }

    public void unlock() {
        this.debtor.unlock();
        this.debtor = null;
    }

    public void gotTransferComplete(AbstractDebtor destinationDebtor) {
        if (!destinationDebtor.isLocked(LoginManager.getInstance().getUser()) && destinationDebtor.isLocked() || destinationDebtor.equals((Object)this.getDebtor())) {
            UnlockDialog dialog = new UnlockDialog();
            dialog.displayLockInfo((Lockable)destinationDebtor, "Debtor");
            return;
        }
        if (destinationDebtor.relock(LoginManager.getInstance().getUser())) {
            DebtorTransferAgent agent = new DebtorTransferAgent(this.debtor, this.renderer.getSelectedSales());
            if (this.renderer.getSelectedSales().size() != 0) {
                boolean doTransfer;
                boolean bl = doTransfer = !destinationDebtor.exceedsCreditLimit(agent.getTransferSaleTotal()) || CreditLimitPanel.doCreditLimitDialog((CreditLimited)destinationDebtor, agent.getTransferSaleTotal(), destinationDebtor.getLabel(), true, "Sales transfer exceeds credit limit of " + destinationDebtor.getLabel());
                if (doTransfer) {
                    boolean isOK;
                    if (PropertyIntegrationType.PIGGY.equals((Object)SystemProperty.getInstance().getPropertyIntegration()) && "ROOM".equals(this.debtor.getType()) && "ROOM".equals(destinationDebtor.getType()) && !(isOK = this.doPiggyRoomTransfer((RoomAccount)this.debtor, (RoomAccount)destinationDebtor))) {
                        Dialogs.displayOkDialog((String)"Room Account Transfer Failed", (String)("Sales transfer from room account " + this.debtor + " to " + destinationDebtor + "is failed."));
                        return;
                    }
                    agent.transferSales(destinationDebtor, this.renderer.getSelectedSales(), LoginManager.getEventContext());
                    this.displayTransferSuccessDialog(this.debtor, destinationDebtor, true);
                }
            } else if (this.renderer.getSelectedPayments().size() != 0) {
                agent.transferPayments(destinationDebtor, this.renderer.getSelectedPayments(), LoginManager.getEventContext());
                this.displayTransferSuccessDialog(this.debtor, destinationDebtor, false);
            } else {
                throw new IllegalStateException("Should not be receiving gotTransferComplete signal when neither sales nor payments are selected");
            }
            this.reaquireDebtor();
            destinationDebtor.unlock();
        }
        this.updateModel();
        this.display();
    }

    private GuestSuggestion findRoomGuest(RoomAccount roomAccount) {
        PiggyResult piggyResult = null;
        try {
            piggyResult = this.piggyService.searchGuest(roomAccount.getRoomNumber(), SearchType.ROOM_NUMBER);
        }
        catch (Exception ex) {
            OrderMateLog.LOG.warn("Problem while looking up guest.", (Throwable)ex);
            return null;
        }
        List sourceGuestSuggestions = piggyResult.getPiggyResponse().getGuestSuggestions();
        for (GuestSuggestion guestSuggestion : sourceGuestSuggestions) {
            if (!roomAccount.getLabel().equals(guestSuggestion.getGuestName())) continue;
            return guestSuggestion;
        }
        return null;
    }

    private boolean doPiggyRoomTransfer(RoomAccount source, RoomAccount destination) {
        GuestSuggestion sourceGuest = this.findRoomGuest(source);
        if (sourceGuest == null) {
            Dialogs.displayOkDialog((String)("Source GuestName(" + source.getName() + ") RoomNumber(" + source.getRoomNumber() + ") is not found."), (String)"Source Guest Not Found");
            return false;
        }
        GuestSuggestion destinationGuest = this.findRoomGuest(destination);
        if (destinationGuest == null) {
            Dialogs.displayOkDialog((String)("Destination GuestName(" + source.getName() + ") RoomNumber(" + source.getRoomNumber() + ") is not found."), (String)"Destination Guest Not Found");
            return false;
        }
        for (DebtorSale sourceSale : this.renderer.getSelectedSales()) {
            Account transferAccount = sourceSale.getSaleAccount();
            try {
                PiggyResult refundResult = this.piggyService.refundSale(transferAccount.getID(), sourceGuest, transferAccount.getAllItems());
                PiggyResult payResult = this.piggyService.chargeGuest(transferAccount.getID(), destinationGuest, sourceSale.getTotal().toBigDecimal(), transferAccount.getAllItems());
                if (refundResult.isSuccess() && payResult.isSuccess()) continue;
                return false;
            }
            catch (Exception ex) {
                OrderMateLog.LOG.warn("Problem while doing room account transfer.", (Throwable)ex);
                return false;
            }
        }
        return true;
    }

    private void reaquireDebtor() {
        AbstractDebtor localDebtor = (AbstractDebtor)PersistenceManager.reacquire((PersistentObjectI)this.debtor);
        PersistenceManager.preloadFKListReferences((PersistentObject)localDebtor, (Class[])new Class[0]);
        this.setDebtor(localDebtor);
    }

    private void displayTransferSuccessDialog(AbstractDebtor source, AbstractDebtor destination, boolean isSales) {
        String transferDesc = "";
        transferDesc = isSales ? " sales " : " payments ";
        String text = "<HTML>Transfered" + transferDesc + "<BR>from: " + source.getLabel() + "<BR>to: " + destination.getLabel() + "</HTML>";
        Dialogs.displayOkDialog((String)text, (String)"Transfer successful");
    }

    protected void gotPaymentStatusFilter() {
        this.updateModel();
    }

    public void gotDateFilterChanged() {
        this.updateModel();
    }

    public void gotPrintStatement() {
        try {
            if (this.debtor.hasOutstanding()) {
                this.debtor.printStatementDockets(LoginManager.getEventContext(), this.getDocketPrinters());
            } else {
                JPanel toDisplay = new JPanel();
                toDisplay.add(new JLabel(""));
                Dialogs.displayOkDialog((String)"No outstanding sales.  There is no statement to print.", (String)"No outstanding sales");
            }
        }
        catch (Exception e) {
            WaitermateSaveAccount.getInstance().handlePrinterError(e, "debtor " + this.debtor.getLabel());
        }
    }

    private Set<VirtualPrinter> getDocketPrinters() {
        LinkedHashSet<VirtualPrinter> printerSet = new LinkedHashSet<VirtualPrinter>();
        printerSet.addAll(Terminal.getLocalHost().getAvaliableWindowsReceiptPrinters());
        printerSet.addAll(Terminal.getLocalHost().getAvailableReceiptPrinters());
        if (printerSet.size() > 1) {
            List buttons = AbstractScrollPaneModel.constructButtons(printerSet);
            OnePressPopupWindow printerDialog = new OnePressPopupWindow("Select Receipt Printer", (Collection)buttons, 1, 3, false);
            CustomButton selectedButton = (CustomButton)printerDialog.start();
            VirtualPrinter selectedPrinter = (VirtualPrinter)selectedButton.getData();
            printerSet.clear();
            printerSet.add(selectedPrinter);
        }
        return printerSet;
    }

    public void gotPrintActivityStatement() {
        if (this.debtor != null) {
            DateSelectDialog dialog = new DateSelectDialog(true);
            dialog.setText("Select start date");
            Date fromDate = null;
            Date toDate = null;
            if (dialog.go(null)) {
                fromDate = dialog.getNewDate();
                dialog.setText("Select end date");
                if (dialog.go(null)) {
                    toDate = dialog.getNewDate();
                }
            }
            if (fromDate != null && toDate != null) {
                if (fromDate.compareTo(toDate) > 0) {
                    Date tempDate = fromDate;
                    fromDate = toDate;
                    toDate = tempDate;
                }
                try {
                    this.debtor.printActivityStatementDockets(fromDate, toDate, LoginManager.getEventContext(), this.getDocketPrinters());
                }
                catch (IOException ex) {
                    OrderMateLog.LOG.warn("Problem while printing the debtor Activity statement.", (Throwable)ex);
                }
            }
        }
    }

    public void setUp() {
        this.nav.reset();
        this.updateModel();
    }

    public void gotNewUser(User user) {
        if (this.debtor != null) {
            this.debtor.relock(user);
        }
        if (this.refund != null) {
            this.refund.relock(user);
        }
    }

    private void gotPrintOutstandingItems() {
        if (this.debtor != null) {
            try {
                DebtorOutstandingItemsReportSearcher searcher = new DebtorOutstandingItemsReportSearcher();
                searcher.setDebtorSearch(this.debtor);
                List allUnpaidItems = PersistenceManager.getObjectList((ObjectQuerySearcher)searcher);
                if (!allUnpaidItems.isEmpty()) {
                    DocketProcessor.printSimpleDocketWithHeader((String)DebtorDocketHelper.buildDocketXML(this.debtor, allUnpaidItems));
                } else {
                    Dialogs.displayOkDialog((String)"Debtor currently has no outstanding items.", (String)"Outstanding Debtor Sales");
                }
            }
            catch (Exception ex) {
                OrderMate.LOG.error("Error occured printing debtor outstanding items docket.", (Throwable)ex);
            }
        }
    }

    private void gotViewReservationDetail() {
        if (!this.isRoomAccount()) {
            String error = "The debtor is not room debtor";
            Dialogs.displayOkDialog((String)error, (String)"Cannot View Reservation Detail");
        } else {
            RoomAccount tempdebtor = (RoomAccount)this.debtor;
            try {
                if (tempdebtor.getExtID() == null) {
                    String error = "The extid of the room account is null";
                    Dialogs.displayOkDialog((String)error, (String)"Cannot View Reservation Detail");
                    return;
                }
                PiggyResult piggyResult = this.piggyService.retrieveReservationDetail(tempdebtor.getExtID());
                List guestSuggestionList = piggyResult.getPiggyResponse().getGuestSuggestions();
                if (guestSuggestionList != null && guestSuggestionList.size() > 0) {
                    GuestSuggestion guestSuggestion = (GuestSuggestion)guestSuggestionList.get(0);
                    String result = "Guest Name: " + guestSuggestion.getGuestName() + System.lineSeparator() + "Room Number: " + guestSuggestion.getRoomNumber() + System.lineSeparator() + "Arrival Date: " + this.sdf.format(guestSuggestion.getGuestArrivalDate().toGregorianCalendar().getTime()) + System.lineSeparator() + "Departure Date: " + this.sdf.format(guestSuggestion.getGuestDepartureDate().toGregorianCalendar().getTime()) + System.lineSeparator() + "Balance Amount: " + guestSuggestion.getBalanceAmount() + System.lineSeparator() + "Credit Limit: " + guestSuggestion.getCreditLimit() + System.lineSeparator() + "Status: " + guestSuggestion.getReservationStatus() + System.lineSeparator();
                    OrderMate.LOG.info(result);
                    JOptionPane.showMessageDialog((Component)((Object)this.nav), result, "Reservation Details", 1);
                }
            }
            catch (Exception e1) {
                WaiterMate.LOG.error("Error trying to retrieve reservation detail", (Throwable)e1);
            }
        }
    }

    private boolean isRoomAccount() {
        if (this.debtor != null) {
            return this.debtor.getType().equals("ROOM");
        }
        return false;
    }
}

