/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.discount;

import au.com.ordermate.util.Price;
import java.util.List;
import ordermate.database.finance.priceadjustment.InventoryPriceAdjustment;
import ordermate.database.finance.priceadjustment.PriceAdjustable;
import ordermate.database.finance.priceadjustment.PriceAdjustmentUnit;
import ordermate.database.finance.priceadjustment.SalesPriceAdjustment;
import ordermate.database.sales.Account;
import ordermate.database.sales.SalesItem;
import waitermate.LoginManager;
import waitermate.guikit.dialogs.Dialogs;

public class DiscountGuiUtils {
    private static void setOpenPriceDollarDiscountForAccount(double valueFromUser, InventoryPriceAdjustment adj, Account currentAccount) {
        Price price = new Price(valueFromUser, 0.01);
        String label = adj.getLabel();
        Price origPrice = adj.getDollarAmount();
        adj.setDollarAmount(price);
        SalesPriceAdjustment spa = adj.createSalesPriceAdjustment((PriceAdjustable)currentAccount, LoginManager.getEventContext());
        adj.setDollarAmount(origPrice);
        spa.setLabel(label);
        adj.setLabel(label);
    }

    private static void setOpenPricePercentageDiscountForAccount(double valueFromUser, InventoryPriceAdjustment adj, Account currentItem) {
        String label = adj.getLabel();
        double origPercentage = adj.getPercentage();
        adj.setPercentage(Double.valueOf(valueFromUser));
        SalesPriceAdjustment spa = adj.createSalesPriceAdjustment((PriceAdjustable)currentItem, LoginManager.getEventContext());
        adj.setPercentage(Double.valueOf(origPercentage));
        spa.setLabel(label);
        adj.setLabel(label);
    }

    private static void setOpenPriceDollarDiscountForItem(double valueFromUser, InventoryPriceAdjustment adj, SalesItem currentItem) {
        Price price = new Price(valueFromUser, 0.01);
        String label = adj.getLabel();
        Price origPrice = adj.getDollarAmount();
        adj.setDollarAmount(price);
        SalesPriceAdjustment spa = adj.createSalesPriceAdjustment((PriceAdjustable)currentItem, LoginManager.getEventContext());
        adj.setDollarAmount(origPrice);
        spa.setLabel(label);
        adj.setLabel(label);
    }

    private static void setOpenPricePercentageDiscountForItem(double valueFromUser, InventoryPriceAdjustment adj, SalesItem currentItem) {
        String label = adj.getLabel();
        double origPercentage = adj.getPercentage();
        adj.setPercentage(Double.valueOf(valueFromUser));
        SalesPriceAdjustment spa = adj.createSalesPriceAdjustment((PriceAdjustable)currentItem, LoginManager.getEventContext());
        adj.setPercentage(Double.valueOf(origPercentage));
        spa.setLabel(label);
        adj.setLabel(label);
    }

    private static String getMessage(String message, double lowerLimit, double upperLimit) {
        if (lowerLimit == upperLimit) {
            return "";
        }
        return String.format(message, lowerLimit, upperLimit);
    }

    public static double getDollarAmountFromUser(double defaultAmount, double lowerLimit, double upperLimit) {
        String message = DiscountGuiUtils.getMessage("Value between %.2f and %.2f  ", lowerLimit, upperLimit);
        return Dialogs.getDoubleValueWithinRange((String)message, (double)defaultAmount, (double)lowerLimit, (double)upperLimit);
    }

    public static double getPercentageFromUser(double defaultAmount, double lowerLimit, double upperLimit) {
        String message = DiscountGuiUtils.getMessage("Value between %.2f and %.2f  %% ", lowerLimit, upperLimit);
        return Dialogs.getPercentageValueWithinRange((String)message, (double)defaultAmount, (double)lowerLimit, (double)upperLimit);
    }

    public static InventoryPriceAdjustment getNewPriceForOpenPriceDiscountAccount(InventoryPriceAdjustment adj, Account account) {
        double upperLimit;
        double lowerLimit;
        double defaultDoubleValue;
        double valueFromUser;
        if (adj.getUnit().equals((Object)PriceAdjustmentUnit.DOLLAR_UNIT)) {
            double upperLimit2;
            double lowerLimit2;
            double defaultDoubleValue2 = account.getDue().doubleValue();
            double valueFromUser2 = DiscountGuiUtils.getDollarAmountFromUser(defaultDoubleValue2, lowerLimit2 = 0.0, upperLimit2 = account.getDue().doubleValue());
            if (valueFromUser2 != Double.MIN_VALUE) {
                DiscountGuiUtils.setOpenPriceDollarDiscountForAccount(valueFromUser2, adj, account);
            }
        } else if (adj.getUnit().equals((Object)PriceAdjustmentUnit.PERCENTAGE_UNIT) && (valueFromUser = DiscountGuiUtils.getPercentageFromUser(defaultDoubleValue = 100.0, lowerLimit = 0.0, upperLimit = 100.0)) != Double.MIN_VALUE) {
            DiscountGuiUtils.setOpenPricePercentageDiscountForAccount(valueFromUser, adj, account);
        }
        return adj;
    }

    public static InventoryPriceAdjustment getNewPriceForOpenPriceDiscountForItem(InventoryPriceAdjustment adj, SalesItem currentItem) {
        double upperLimit;
        double lowerLimit;
        double defaultDoubleValue;
        double valueFromUser;
        if (adj.getUnit().equals((Object)PriceAdjustmentUnit.DOLLAR_UNIT)) {
            double upperLimit2;
            double lowerLimit2;
            double defaultDoubleValue2 = currentItem.getPricePerItem().doubleValue();
            double valueFromUser2 = DiscountGuiUtils.getDollarAmountFromUser(defaultDoubleValue2, lowerLimit2 = 0.0, upperLimit2 = currentItem.getPricePerItem().doubleValue());
            if (valueFromUser2 != Double.MIN_VALUE) {
                DiscountGuiUtils.setOpenPriceDollarDiscountForItem(valueFromUser2, adj, currentItem);
            }
        } else if (adj.getUnit().equals((Object)PriceAdjustmentUnit.PERCENTAGE_UNIT) && (valueFromUser = DiscountGuiUtils.getPercentageFromUser(defaultDoubleValue = 100.0, lowerLimit = 0.0, upperLimit = 100.0)) != Double.MIN_VALUE) {
            DiscountGuiUtils.setOpenPricePercentageDiscountForItem(valueFromUser, adj, currentItem);
        }
        return adj;
    }

    public static InventoryPriceAdjustment getNewPriceForOpenPriceDiscountForItemList(InventoryPriceAdjustment adj, List<SalesItem> salesItemList) {
        block4: {
            double upperLimit;
            double lowerLimit;
            double defaultDoubleValue;
            double valueFromUser;
            block3: {
                if (!adj.getUnit().equals((Object)PriceAdjustmentUnit.DOLLAR_UNIT)) break block3;
                double defaultDoubleValue2 = 0.0;
                double lowerLimit2 = 0.0;
                double upperLimit2 = 0.0;
                double valueFromUser2 = DiscountGuiUtils.getDollarAmountFromUser(defaultDoubleValue2, lowerLimit2, upperLimit2);
                if (valueFromUser2 == Double.MIN_VALUE) break block4;
                for (SalesItem currentItem : salesItemList) {
                    DiscountGuiUtils.setOpenPriceDollarDiscountForItem(valueFromUser2, adj, currentItem);
                }
                break block4;
            }
            if (adj.getUnit().equals((Object)PriceAdjustmentUnit.PERCENTAGE_UNIT) && (valueFromUser = DiscountGuiUtils.getPercentageFromUser(defaultDoubleValue = 100.0, lowerLimit = 0.0, upperLimit = 100.0)) != Double.MIN_VALUE) {
                for (SalesItem currentItem : salesItemList) {
                    DiscountGuiUtils.setOpenPricePercentageDiscountForItem(valueFromUser, adj, currentItem);
                }
            }
        }
        return adj;
    }
}

