/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.login;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.sound.sampled.AudioInputStream;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import ordermate.audio.AudioUtils;

public class FlashAndDingListener
implements ActionListener {
    private final int countsUntilDing;
    private final JComponent componentToFlash;
    private final Color flashDownColor;
    private final Color flashUpColor;
    private String soundClip;
    private int count = 0;
    private boolean isFlashDown = false;

    public FlashAndDingListener(JComponent component, String theSoundClip, Color flashDown, Color flashUp, int countsToDing) {
        this.countsUntilDing = countsToDing;
        this.componentToFlash = component;
        this.soundClip = theSoundClip;
        this.flashDownColor = flashDown;
        this.flashUpColor = flashUp;
    }

    private void doDing() {
        if (this.soundClip == null) {
            return;
        }
        AudioInputStream audio = AudioUtils.getStream(this.getClass(), (String)this.soundClip);
        if (audio == null) {
            this.soundClip = null;
            return;
        }
        AudioUtils.playClip((AudioInputStream)audio);
    }

    private void doFlash() {
        final Color toSet = this.isFlashDown ? this.flashDownColor : this.flashUpColor;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                FlashAndDingListener.this.componentToFlash.setBackground(toSet);
            }
        });
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.doFlash();
        if (this.count == 0) {
            this.doDing();
        }
        ++this.count;
        boolean bl = this.isFlashDown = !this.isFlashDown;
        if (this.count >= this.countsUntilDing) {
            this.count = 0;
        }
    }

    public void clear() {
        this.count = 0;
    }
}

