/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.login;

import au.com.ordermate.configuration.Config;
import au.com.ordermate.util.image.GifLoader;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import ordermate.database.finance.priceadjustment.PriceAdjustmentManager;
import ordermate.database.hardware.Terminal;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import waitermate.LoginManager;
import waitermate.gui.WaitermateAccountGui;
import waitermate.gui.notify.WhatsNew;
import waitermate.gui.screens.login.WaitermateLoginPanel;
import waitermate.guikit.AbstractScreen;
import waitermate.guikit.NavBar;
import waitermate.guikit.NotificationManager;
import waitermate.guikit.ScreenResource;

public class Login
extends AbstractScreen {
    private Long numNewOrders = null;
    public Signal validLogin = Signals.createSignal();
    private WaitermateLoginPanel gui;

    public Login() {
        boolean pinLogin = Terminal.getLocalHost().getShowPin();
        this.gui = new WaitermateLoginPanel(pinLogin, new GifLoader());
        NotificationManager.getInstance().newUserSignal.connect((Object)this, "gotLogin");
        this.gui.pinLogin.connect((Object)this, "gotPin");
    }

    public void display() {
        ScreenResource.stopAllPopoutWindows();
        super.display();
        if (WhatsNew.needsToShow()) {
            new WhatsNew().showWhatsNew();
        }
    }

    void gotPin(String pin) {
        if (!pin.equals("\u0000") && pin.length() > 0) {
            LoginManager.getInstance().gotPinLogin(pin);
        }
    }

    void gotLogin() {
        this.gui.clearPin();
        this.gui.stopPaintTimer();
        this.gui.stopOnlineOrderPending();
        if (this.isDisplaying()) {
            this.validLogin.emit();
        }
    }

    public void setUp() {
        WaitermateAccountGui.getInstance().accountChanged(null, null);
        this.gui.startPaintTimer();
        this.gui.updateMessageOfTheDay();
        this.gui.stopOnlineOrderPending();
        ScreenResource.showMenu((boolean)false);
        if (Config.isConfigSetup() && Config.getBooleanValue((String)"load_adj_on_login")) {
            PriceAdjustmentManager.getInstance().getAllPriceAdjustments();
        }
        if (this.numNewOrders != null && this.numNewOrders.intValue() > 0) {
            this.gui.startOnlineOrderPending(this.numNewOrders);
        }
    }

    public void tearDown() {
        this.numNewOrders = null;
        this.gui.stopOnlineOrderPending();
        this.gui.stopPaintTimer();
        ScreenResource.showMenu((boolean)true);
    }

    public String getName() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public JComponent getMainArea() {
        return this.gui;
    }

    public NavBar getNavBar() {
        return null;
    }

    public boolean hasNavBar() {
        return false;
    }

    public void gotNewOnlineOrders(final Long numberOfOrders) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Login.this.numNewOrders = numberOfOrders;
                if (Login.this.isDisplaying()) {
                    if (Login.this.numNewOrders != null && Login.this.numNewOrders.intValue() > 0) {
                        Login.this.gui.startOnlineOrderPending(Login.this.numNewOrders);
                    } else {
                        Login.this.gui.stopOnlineOrderPending();
                    }
                }
            }
        });
    }
}

