/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.login;

import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.util.StringUtils;
import au.com.ordermate.util.file.FileUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.TimerTask;
import javax.swing.JComponent;
import ordermate.OrderMate;
import ordermate.database.integration.webservice.WebserviceIntegrationConfig;
import ordermate.database.integration.webservice.WebserviceIntegrationType;
import ordermate.database.misc.resource.ConfigResource;
import ordermate.database.misc.resource.ConfigResourceSet;
import ordermate.database.misc.resource.ConfigResourceType;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.FTPReply;
import waitermate.gui.customerdisplay.advertising.AdvertPanel;
import waitermate.gui.customerdisplay.advertising.AdvertisementBag;
import waitermate.gui.customerdisplay.advertising.AdvertisementManager;
import waitermate.gui.screens.login.StoreTagAdFilter;

public class LoginAdvertisingManager
extends AdvertisementManager {
    private static final String NAME = "WM-Login-Ads";
    private static final String ADVERTS = "OM-Ads";
    private static final long INITIAL_DELAY = 30000L;
    private static final long DELAY = 120000L;
    private static final long BETWEEN_DELAY = 100L;
    private ConfigResourceSet advertSet;
    private long lastUpdateTime = 0L;
    private final List<String> SUPPORTED_TYPES;
    private boolean notShowing = true;
    Locale locale = Locale.getDefault();

    public LoginAdvertisingManager() {
        this.SUPPORTED_TYPES = new ArrayList<String>();
        this.SUPPORTED_TYPES.add("jpg");
        this.SUPPORTED_TYPES.add("gif");
        this.SUPPORTED_TYPES.add("png");
        this.SUPPORTED_TYPES.add("avi");
        this.advertSet = (ConfigResourceSet)PersistenceManager.getObject(ConfigResourceSet.class, (String)Query.select(ConfigResourceSet.class).equals(ConfigResourceSet.Properties.LABEL, (Object)NAME).toString());
        if (this.advertSet == null) {
            this.advertSet = new ConfigResourceSet(NAME, null);
            this.advertSet.save();
        }
        this.adBag.addFilter(new StoreTagAdFilter());
    }

    @Override
    public void start() {
        this.started = true;
        this.killAdvertTasks();
        if (this.needsReload) {
            this.reload();
        }
        this.delaySchedule();
    }

    public void flipBanner() {
        this.changeAdvertisement(AdvertisementManager.AdvertType.Advertisement);
    }

    @Override
    protected void changeAdvertisement(AdvertisementManager.AdvertType type) {
        if (this.notShowing) {
            ((AdvertPanel)this.getAdvertPanel()).setConfigResource(null);
            this.advertTask = new AdvertisementManager.UpdateAdTask(AdvertisementManager.AdvertType.Advertisement);
            this.rescheduleTask(null, this.advertTask, 100L);
            this.notShowing = false;
        } else {
            super.changeAdvertisement(type);
        }
    }

    @Override
    public void stop() {
        this.notShowing = true;
        ((AdvertPanel)this.getAdvertPanel()).setConfigResource(null);
        super.stop();
    }

    private void delaySchedule() {
        this.advertTask = new AdvertisementManager.UpdateAdTask(AdvertisementManager.AdvertType.Advertisement);
        this.adTimer.schedule((TimerTask)this.advertTask, 30000L);
    }

    @Override
    protected long getDelay() {
        return 120000L;
    }

    @Override
    protected AdvertPanel createAdvertisementPanel() {
        AdvertPanel comp = new AdvertPanel(null, 100, 0.1f, 0.9f);
        comp.setDefaultImage(null);
        return comp;
    }

    @Override
    protected AdvertPanel createBannerPanel() {
        AdvertPanel comp = new AdvertPanel(null, 100, 0.1f, 0.9f);
        comp.setDefaultImage(null);
        return comp;
    }

    @Override
    public JComponent getBannerPanel() {
        throw new IllegalStateException("Login Ad Man only supports adverts currently");
    }

    @Override
    protected void reload() {
        this.killAdvertTasks();
        if (this.lastUpdateTime + 86400000L < System.currentTimeMillis()) {
            OrderMate.LOG.info("Reloading advertisements");
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    LoginAdvertisingManager.this.downloadAdverts();
                    LoginAdvertisingManager.this.adBag.initialiseBag(LoginAdvertisingManager.this.getSet(AdvertisementManager.AdvertType.Advertisement));
                    LoginAdvertisingManager.this.change();
                }
            };
            new Thread(runnable, "Resync Adverts").start();
            this.lastUpdateTime = System.currentTimeMillis();
        } else {
            this.delaySchedule();
        }
    }

    void downloadAdverts() {
        this.adBag.initialiseBag(null);
        WebserviceIntegrationConfig config = this.getConfig();
        if (StringUtils.isEmpty((String)config.getUrl())) {
            OrderMate.LOG.warn("Will not run notices, url of endpoint is empty");
            return;
        }
        String common = config.getEndpointUrl();
        String countrySpecific = common.replace("/common", "/" + this.locale.getCountry());
        if (!this.tryDownloadFrom(config, countrySpecific)) {
            if (common.equals(countrySpecific)) {
                OrderMate.LOG.info("Couldn't download notices from " + countrySpecific + ", aborting");
            } else {
                OrderMate.LOG.info("Couldn't download notices from " + countrySpecific + " will attempt common");
                if (!this.tryDownloadFrom(config, common)) {
                    OrderMate.LOG.info("Bizarre. Couldn't download from " + common + ", giving up");
                }
            }
        } else {
            OrderMate.LOG.info("Downloaded notices from " + countrySpecific);
        }
    }

    private boolean tryDownloadFrom(WebserviceIntegrationConfig config, String directory) {
        String user = config.getUsername();
        String pass = config.getPassword();
        FTPClient ftp = new FTPClient();
        try {
            ftp.connect(config.getUrl());
            int reply = ftp.getReplyCode();
            if (!FTPReply.isPositiveCompletion((int)reply)) {
                ftp.disconnect();
                OrderMate.LOG.warn("Notices repository failed - cannot connect");
                return false;
            }
            ftp.enterLocalPassiveMode();
            if (!ftp.login(user, pass)) {
                OrderMate.LOG.warn("Notices repository failed - cannot login");
                return false;
            }
            String advertDir = "/" + directory + "/";
            if (!ftp.changeWorkingDirectory(advertDir)) {
                OrderMate.LOG.warn("Notices Repo failed - cannot change to directory to " + advertDir);
                return false;
            }
            FTPFile[] files = ftp.listFiles();
            this.processAllFilesInFtp(files, ftp, this.advertSet);
            this.advertSet.save();
            ftp.logout();
        }
        catch (IOException ex) {
            OrderMate.LOG.error("Login AdMan has an error", (Throwable)ex);
            return false;
        }
        this.adBag.initialiseBag(this.advertSet);
        return true;
    }

    private void processAllFilesInFtp(FTPFile[] files, FTPClient ftpClient, ConfigResourceSet workingAdvertSet) {
        OrderMate.LOG.info("processAllFilesinFtp :: " + files.length);
        for (FTPFile ftpFile : files) {
            if (ftpFile.isDirectory() || !this.isNewFile(ftpFile) && !this.isFileModified(ftpFile, workingAdvertSet)) continue;
            this.downloadFile(ftpFile, ftpClient, workingAdvertSet);
        }
        this.deleteStaleFiles(files);
    }

    private void deleteStaleFiles(FTPFile[] files) {
        File localFilesDirectory = new File(FileUtils.getTempDir() + "/" + ADVERTS + "/");
        File[] localFiles = localFilesDirectory.listFiles();
        for (File localFile : localFiles) {
            if (!this.isStaleFile(files, localFile)) continue;
            this.removeStaleFile(localFile);
        }
        for (ConfigResource resource : new ArrayList(this.advertSet.getResources())) {
            boolean found = false;
            for (FTPFile file : files) {
                if (!file.getName().equals(resource.getLabel())) continue;
                found = true;
                break;
            }
            if (found) continue;
            this.advertSet.removeResource(resource);
        }
    }

    private boolean isStaleFile(FTPFile[] ftpFiles, File localFile) {
        String localFileName = localFile.getName();
        for (FTPFile ftpFile : ftpFiles) {
            if (ftpFile.isDirectory() || !ftpFile.getName().equals(localFileName)) continue;
            return false;
        }
        return true;
    }

    private boolean removeStaleFile(File localFile) {
        for (ConfigResource resource : new ArrayList(this.advertSet.getResources())) {
            if (!localFile.getName().equals(resource.getLabel())) continue;
            this.advertSet.removeResource(resource);
            break;
        }
        return localFile.delete();
    }

    private boolean isFileModified(FTPFile ftpFile, ConfigResourceSet localFiles) {
        String ftpFileName = ftpFile.getName();
        List resourceList = localFiles.getResources();
        File localfile = new File(FileUtils.getTempDir() + "/" + ADVERTS + "/" + ftpFileName);
        for (ConfigResource configResource : resourceList) {
            if (!ftpFileName.equals(configResource.getLabel()) || !localfile.exists() || localfile.length() != ftpFile.getSize()) continue;
            return false;
        }
        return true;
    }

    private boolean isNewFile(FTPFile ftpFile) {
        String ftpFileName = ftpFile.getName();
        List resourceList = this.advertSet.getResources();
        File localfile = new File(FileUtils.getTempDir() + "/" + ADVERTS + "/" + ftpFileName);
        for (ConfigResource resource : resourceList) {
            if (!ftpFileName.equals(resource.getLabel())) continue;
            return !localfile.exists();
        }
        return true;
    }

    private void downloadFile(FTPFile newFile, FTPClient ftp, ConfigResourceSet localFiles) {
        if (newFile.isDirectory()) {
            OrderMate.LOG.info("Skipping directory download . . ." + newFile.getName());
            return;
        }
        String fileName = newFile.getName();
        File localfile = new File(FileUtils.getTempDir() + "/" + ADVERTS + "/" + fileName);
        if (fileName.length() > 3) {
            String suffix = fileName.substring(fileName.length() - 3).toLowerCase();
            if (!this.SUPPORTED_TYPES.contains(suffix)) {
                OrderMate.LOG.info("FileType " + suffix + " is not supported : " + newFile.getName());
                return;
            }
            File parent = localfile.getParentFile();
            if (!parent.exists()) {
                OrderMate.LOG.info("Creating Parent Folder : " + parent.getName());
                parent.mkdir();
            }
            try {
                FileOutputStream fout = new FileOutputStream(localfile);
                ftp.setFileType(2);
                if (ftp.retrieveFile(newFile.getName(), (OutputStream)fout)) {
                    OrderMate.LOG.info("Retreived ad " + newFile);
                } else {
                    OrderMate.LOG.info("Failed to retrieve ad " + newFile);
                }
                fout.flush();
                this.addFileToResourceSet(newFile, suffix, localFiles);
            }
            catch (Exception ex) {
                OrderMate.LOG.info("Error occurred while downloading file : " + ex.getMessage(), (Throwable)ex);
            }
        }
    }

    private void addFileToResourceSet(FTPFile file, String suffix, ConfigResourceSet localFiles) throws IOException {
        ConfigResource newResource = new ConfigResource(file.getName(), ConfigResourceType.IMAGE);
        File localfile = new File(FileUtils.getTempDir() + "/" + ADVERTS + "/" + file.getName());
        if (suffix.endsWith("avi")) {
            newResource.setResourceType(ConfigResourceType.ANIMATION);
        }
        newResource.setResourceSet(localFiles);
        newResource.setResourcePath(localfile.getCanonicalPath());
        localFiles.addResource(newResource);
        localFiles.save();
    }

    @Override
    protected ConfigResourceSet getSet(AdvertisementManager.AdvertType adType) {
        if (AdvertisementManager.AdvertType.Advertisement.equals((Object)adType)) {
            return this.advertSet;
        }
        return null;
    }

    protected WebserviceIntegrationConfig getConfig() {
        WebserviceIntegrationConfig config = (WebserviceIntegrationConfig)PersistenceManager.getObject(WebserviceIntegrationConfig.class, (String)Query.select(WebserviceIntegrationConfig.class).equals(WebserviceIntegrationConfig.Properties.DESCRIPTION, (Object)NAME).toString());
        if (config == null) {
            config = new WebserviceIntegrationConfig();
            config.setDescription(NAME);
            config.setUrl("ftp.ordermatecentral.com");
            config.setUsername("software");
            config.setPassword("quTh3fra");
            config.setEndpointUrl("Adverts/common");
            config.setWebserviceType(WebserviceIntegrationType.Basic);
            config.save();
        }
        return config;
    }

    AdvertisementBag getAdBag() {
        return this.adBag;
    }
}

