/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.login;

import au.com.ordermate.gui.GraphPaperLayout;
import au.com.ordermate.util.HtmlBuilder;
import au.com.ordermate.util.HtmlUtils;
import au.com.ordermate.util.connectivity.DesktopHelper;
import au.com.ordermate.util.image.IconLoader;
import au.com.ordermate.util.image.ImageHelper;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.DateFormat;
import java.util.Date;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import ordermate.OrderMate;
import ordermate.database.hardware.Terminal;
import ordermate.database.integration.online.OnlineIntegrationConfig;
import ordermate.database.misc.SystemProperty;
import ordermate.gui.keypad.Keypad;
import ordermate.gui.themes.OrderMateTheme;
import ordermate.internationalization.Internationalization;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import waitermate.WaiterMateInputAdapter;
import waitermate.gui.screens.login.FlashAndDingListener;
import waitermate.gui.screens.login.NetworkStatus;
import waitermate.guikit.components.CustomCheckButton;
import waitermate.guikit.dialogs.Dialogs;
import waitermate.guikit.dialogs.KeypadDialog;

class LoginPanel
extends JPanel
implements ActionListener {
    private static final String ONLINE_ORDER_SOUND = "/waitermate/sounds/onlineOrderPending.wav";
    private static final String EULA_URL = "http://files.ordermatepos.com/docs/EULA.HTML";
    private static final String EULA_WEBSITE_ERROR = "Eula webpage was unable to be loaded please find the eula at website below";
    private static final String PLEASE_CLICK_TEXT = "Please click here to browse our ";
    private static final String KNOWLEDGEBASE_A_TAG = "<a href='http://help.ordermate.com.au/hc/en-us'>Knowledge Base</a>";
    private static final String ORDERMATE_A_TAG = "<a href='www.ordermate.com.au'>OrderMate</a>";
    private static final int KEYPAD_WIDTH = 300;
    private static final int KEYPAD_HEIGHT = 330;
    private static final int MOTD_HEIGHT = 80;
    private static final int FLASH_DELAY = 250;
    private static final Color FLASH_COLOR_1 = Color.BLUE;
    private static final Color FLASH_COLOR_2 = Color.ORANGE;
    private Keypad loginKeypad;
    private KeypadDialog loginPanel;
    final Signal<String, ?, ?, ?, ?> pinLogin = Signals.createSignal(String.class, (String)"pin");
    private JLabel timeLabel;
    private JLabel messageOfTheDay;
    private ImageIcon originalGraphic;
    private Image logo;
    private boolean hasPinLogin;
    private JButton netConfigButton;
    private JLabel onlineOrderLabel;
    private CustomCheckButton eulaCheckButton;
    Timer paintSwingTimer;
    private Timer onlineOrderPendingTimer;
    private FlashAndDingListener onlineOrderListener;
    private final DateFormat dateFormatter = DateFormat.getDateTimeInstance(0, 1);
    private final String WAITERMATE_VERSION = Internationalization.getLiteralFor((String)"WAITERMATE_VERSION") + " " + OrderMate.VERSION + " - ";
    private String webLinkColour = "Blue";

    public LoginPanel(boolean doPinLogin) {
        this.setLayout((LayoutManager)new GraphPaperLayout(20, 20));
        this.setBackground(this.getGreyscaleBackground());
        this.hasPinLogin = doPinLogin;
        if (Terminal.getLocalHost().isDarkLogo()) {
            this.setBackground(Color.BLACK);
            this.webLinkColour = "#6464ff";
        } else {
            this.setBackground(OrderMateTheme.ORDERMATE_RED);
            this.webLinkColour = "Blue";
        }
        this.originalGraphic = IconLoader.get((String)"/ordermate/images/logo_2024_transparent.png");
        this.makeTimeLabel();
        if (this.hasPinLogin) {
            this.makeLoginPanel();
        }
        this.makeMessageOfTheDay();
        this.makeSupportLabel();
        this.makeEulaLabel();
        this.makeExtras();
        this.makeOnlineOrderLabel();
    }

    private void makeTimeLabel() {
        this.timeLabel = new JLabel(this.getStatusText());
        this.timeLabel.setFont(this.timeLabel.getFont().deriveFont(0));
        this.timeLabel.setForeground(Color.WHITE);
        this.add((Component)this.timeLabel, new Rectangle(1, 0, 20, 1));
        this.paintSwingTimer = new Timer(1000, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoginPanel.this.timeLabel.setText(LoginPanel.this.getStatusText());
            }
        });
        this.paintSwingTimer.setInitialDelay(0);
    }

    private void makeLoginPanel() {
        Keypad.KeypadBuilder builder = new Keypad.KeypadBuilder();
        builder.setShowOkButton(true);
        this.loginKeypad = builder.build();
        this.loginPanel = new KeypadDialog(this.loginKeypad, 0);
        this.loginPanel.setup(false);
        this.loginPanel.setUnits(Internationalization.getLiteralFor((String)"LOGIN") + ": ");
        this.loginPanel.setLabelForeground(Color.WHITE);
        this.loginPanel.pinInput(true);
        this.loginPanel.setAlignmentX(0.0f);
        this.loginPanel.setOpaque(false);
        this.loginPanel.setPreferredSize(new Dimension(300, 330));
        this.loginPanel.setMaximumSize(new Dimension(300, 330));
        JPanel keypadHolder = new JPanel();
        keypadHolder.setLayout(new BoxLayout(keypadHolder, 1));
        keypadHolder.add(Box.createGlue());
        keypadHolder.add((Component)this.loginPanel);
        keypadHolder.setOpaque(false);
        this.add((Component)keypadHolder, new Rectangle(1, 1, 9, 12));
        this.loginKeypad.okPressed.connect((Object)this, "gotPin");
    }

    private void makeMessageOfTheDay() {
        this.messageOfTheDay = new JLabel();
        this.messageOfTheDay.setPreferredSize(new Dimension(300, 80));
        this.messageOfTheDay.setForeground(Color.WHITE);
        this.messageOfTheDay.setFont(OrderMateTheme.getLargeFont());
        this.messageOfTheDay.setVerticalTextPosition(1);
        JLabel motdLabel = new JLabel(Internationalization.getLiteralFor((String)"MESSAGE_OF_THE_DAY_CAPITALD") + ":");
        motdLabel.setFont(OrderMateTheme.getMediumFont());
        motdLabel.setForeground(Color.WHITE);
        this.add((Component)motdLabel, new Rectangle(1, 14, 8, 1));
        this.add((Component)this.messageOfTheDay, new Rectangle(1, 15, 8, 3));
    }

    private void makeSupportLabel() {
        String supportText = SystemProperty.getInstance().getSupportMessage1() + HtmlUtils.newline((int)1) + SystemProperty.getInstance().getSupportMessage2() + HtmlUtils.newline((int)1) + PLEASE_CLICK_TEXT + KNOWLEDGEBASE_A_TAG + HtmlUtils.newline((int)1) + ORDERMATE_A_TAG;
        JEditorPane support = new JEditorPane();
        support.setContentType("text/html");
        support.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
        support.setEditable(false);
        support.setOpaque(false);
        support.setText(supportText);
        support.setFont(this.timeLabel.getFont().deriveFont(0));
        support.setForeground(Color.WHITE);
        support.setAlignmentX(2.0f);
        support.setBorder(BorderFactory.createEmptyBorder());
        support.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent hle) {
                if (HyperlinkEvent.EventType.ACTIVATED.equals(hle.getEventType())) {
                    String link = hle.getDescription();
                    DesktopHelper.getInstance().browseUrl(link);
                }
            }
        });
        this.add((Component)support, new Rectangle(1, 18, 8, 2));
    }

    private void makeExtras() {
        this.netConfigButton = new JButton(IconLoader.get((String)"/waitermate/images/cloud.png"));
        OrderMateTheme.setupTransparentButton((AbstractButton)this.netConfigButton);
        this.netConfigButton.addActionListener(this);
        this.add((Component)this.netConfigButton, new Rectangle(18, 0, 2, 2));
        NetworkStatus.getInstance().networkStatusChanged.connect((Object)this, "gotNetworkStatusChanged");
    }

    private void makeOnlineOrderLabel() {
        this.onlineOrderLabel = new JLabel(Internationalization.getLiteralFor((String)"NEW_ONLINE_ORDER"), IconLoader.get((String)"/waitermate/images/onlineOrderPending.png"), 0);
        this.onlineOrderLabel.setName("onlineOrderNotification");
        this.onlineOrderLabel.setOpaque(true);
        this.onlineOrderLabel.setVisible(false);
        this.onlineOrderLabel.setVerticalTextPosition(3);
        this.onlineOrderLabel.setForeground(Color.GRAY);
        this.onlineOrderLabel.setHorizontalTextPosition(0);
        this.onlineOrderLabel.setHorizontalAlignment(0);
        this.add((Component)this.onlineOrderLabel, new Rectangle(15, 14, 4, 4));
    }

    private void makeEulaLabel() {
        this.eulaCheckButton = new CustomCheckButton(true);
        this.eulaCheckButton.setSelectedIcon((Icon)IconLoader.get((String)"/waitermate/images/ok32_White.png"));
        this.eulaCheckButton.setIcon((Icon)IconLoader.get((String)"/waitermate/images/cancel32_White.png"));
        this.eulaCheckButton.setName("eulaCheckButton");
        this.eulaCheckButton.setPreferredSize(new Dimension(34, 34));
        this.eulaCheckButton.setSize(new Dimension(34, 34));
        this.eulaCheckButton.addActionListener((ActionListener)this);
        this.eulaCheckButton.setFocusable(false);
        this.eulaCheckButton.setFocusPainted(false);
        this.eulaCheckButton.setContentAreaFilled(false);
        this.eulaCheckButton.setBorder((Border)new LineBorder(Color.WHITE, 2));
        JLabel eulaLabel = new JLabel(Internationalization.getLiteralFor((String)"ACCEPT_TERMS"));
        eulaLabel.setFont(this.timeLabel.getFont().deriveFont(0));
        eulaLabel.setHorizontalAlignment(4);
        eulaLabel.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 0));
        eulaLabel.setForeground(Color.WHITE);
        JLabel eulaDisplayLabel = new JLabel(new HtmlBuilder().appendColor(Internationalization.getLiteralFor((String)"ORDERMATE_EULA"), this.webLinkColour).toString());
        eulaDisplayLabel.setName("eulaDisplayLabel");
        eulaDisplayLabel.setPreferredSize(new Dimension(eulaDisplayLabel.getPreferredSize().width + 7, 30));
        eulaDisplayLabel.setFont(this.timeLabel.getFont().deriveFont(0));
        eulaDisplayLabel.setHorizontalAlignment(2);
        eulaDisplayLabel.setForeground(Color.WHITE);
        eulaDisplayLabel.setBorder(BorderFactory.createEmptyBorder(0, 3, 0, 4));
        eulaDisplayLabel.setCursor(Cursor.getPredefinedCursor(12));
        eulaDisplayLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                LoginPanel.this.displayEulaDialog();
            }
        });
        JPanel eulaHolder = new JPanel(new FlowLayout(2, 0, 0));
        eulaHolder.setOpaque(false);
        eulaHolder.add((Component)this.eulaCheckButton);
        eulaHolder.add(eulaLabel);
        eulaHolder.add(eulaDisplayLabel);
        this.add((Component)eulaHolder, new Rectangle(7, 19, 13, 1));
    }

    private void eulaSelectionLoginPinToggle() {
        this.loginKeypad.setEnabled(this.eulaCheckButton.isSelected());
        WaiterMateInputAdapter.getInstance().enableInputParsing(this.eulaCheckButton.isSelected());
        this.loginPanel.setValue("");
    }

    private void displayEulaDialog() {
        HtmlBuilder builder = new HtmlBuilder();
        builder.appendBold("END USER LICENCE AGREEMENT").appendLineBreak().append(Internationalization.getLiteralFor((String)"EULA_FOUND_AT")).append(" ").appendColor("www.ordermate.com.au/eula", "Blue").center();
        Dialogs.displayHtmlDocDialog((String)builder.toString(), (String)EULA_URL, (String)EULA_WEBSITE_ERROR);
    }

    public void gotPin() {
        String pin = this.loginPanel.getValueAsString();
        this.loginPanel.setValue("");
        this.pinLogin.emit((Object)pin);
    }

    private Color getGreyscaleBackground() {
        Color baseColor = UIManager.getColor("TextArea.background");
        int avg = (baseColor.getRed() + baseColor.getGreen() + baseColor.getBlue()) / 3;
        return new Color(avg, avg, avg);
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        boolean resample = this.getWidth() != width || this.getHeight() != height;
        super.setBounds(x, y, width, height);
        if (resample) {
            this.logo = null;
            this.resampleLogo();
        }
    }

    private void resampleLogo() {
        ImageHelper helper = new ImageHelper();
        helper.setAntiAliasingRH(RenderingHints.VALUE_ANTIALIAS_ON);
        double scaleW = (double)(this.getWidth() / 2) / (double)this.originalGraphic.getIconWidth();
        double scaleH = (double)(this.getHeight() / 2) / (double)this.originalGraphic.getIconHeight();
        double linearScale = scaleW <= scaleH ? scaleW : scaleH;
        double nonLinearScale = linearScale * Math.log(linearScale + 2.25);
        this.logo = helper.rescaleImage(this.originalGraphic.getImage(), nonLinearScale);
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        g.setColor(this.getBackground());
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        Graphics2D g2 = (Graphics2D)g;
        g2.setComposite(AlphaComposite.SrcOver);
        if (this.logo == null) {
            this.resampleLogo();
        }
        g2.drawImage(this.logo, this.getWidth() - this.logo.getWidth(null) - this.getWidth() / 20, this.getHeight() / 2 - this.logo.getHeight(null) / 2, null);
    }

    private String getStatusText() {
        Date today = new Date();
        return this.WAITERMATE_VERSION + this.dateFormatter.format(today);
    }

    public void gotNetworkStatusChanged() {
        NetworkStatus status = NetworkStatus.getInstance();
        if (!status.isUpdating()) {
            ImageIcon newIcon = !status.isWanConnected() ? IconLoader.get((String)"/waitermate/images/badcloud.png") : IconLoader.get((String)"/waitermate/images/cloud.png");
            this.netConfigButton.setIcon(newIcon);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.netConfigButton) {
            NetworkStatus.getInstance().showDialog();
        } else if (e.getSource() == this.eulaCheckButton) {
            this.eulaSelectionLoginPinToggle();
        }
    }

    public void startPaintTimer() {
        this.paintSwingTimer.start();
    }

    public void stopPaintTimer() {
        this.paintSwingTimer.stop();
    }

    public void updateMessageOfTheDay() {
        if (SystemProperty.getInstance().getMessageOfTheDay() != null && SystemProperty.getInstance().getMessageOfTheDay().trim().length() > 0) {
            this.messageOfTheDay.setText(HtmlUtils.html((String)SystemProperty.getInstance().getMessageOfTheDay()));
        } else {
            this.messageOfTheDay.setText("");
        }
    }

    void startOnlineOrderPending(Long numNewOrders) {
        if (numNewOrders == null) {
            return;
        }
        if (this.onlineOrderPendingTimer == null) {
            String sound = null;
            if (OnlineIntegrationConfig.getDefaultInstance().isPlaySound()) {
                sound = ONLINE_ORDER_SOUND;
            }
            this.onlineOrderListener = new FlashAndDingListener(this.onlineOrderLabel, sound, FLASH_COLOR_1, FLASH_COLOR_2, 240);
            this.onlineOrderPendingTimer = new Timer(0, this.onlineOrderListener);
            this.onlineOrderPendingTimer.setDelay(250);
            this.onlineOrderPendingTimer.setCoalesce(true);
        }
        StringBuilder SB = new StringBuilder(Internationalization.getLiteralFor((String)"THERE"));
        SB.append(" ");
        if (numNewOrders.intValue() == 1) {
            SB.append(Internationalization.getLiteralFor((String)"IS_ONE_NEW_ONLINE_ORDER_PENDING"));
        } else {
            SB.append(Internationalization.getLiteralFor((String)"ARE")).append(" ").append(numNewOrders).append(" ").append(Internationalization.getLiteralFor((String)"NEW_ONLINE_ORDERS_PENDING"));
        }
        this.onlineOrderLabel.setText(HtmlUtils.html((String)SB.toString()));
        this.onlineOrderLabel.setVisible(true);
        this.onlineOrderPendingTimer.start();
    }

    void stopOnlineOrderPending() {
        if (this.onlineOrderPendingTimer != null) {
            this.onlineOrderPendingTimer.stop();
            this.onlineOrderListener.clear();
        }
        this.onlineOrderLabel.setVisible(false);
    }

    public void clearPin() {
        if (this.loginKeypad != null) {
            this.loginKeypad.setValue("");
        }
    }
}

