/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.login;

import au.com.ordermate.OrderMateLog;
import au.com.ordermate.util.IPAddressUtils;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutionException;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.Timer;
import ordermate.database.hardware.Terminal;
import ordermate.internationalization.Internationalization;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import waitermate.WaiterMate;
import waitermate.gui.screens.login.NetworkStatusPanel;
import waitermate.guikit.dialogs.Dialogs;

public class NetworkStatus {
    private volatile boolean isUpdating;
    private NetworkStatusData data = new NetworkStatusData();
    private static final int PING_TIMEOUT = 10000;
    private static final int UPDATE_TIME = 120000;
    private Timer updateTimer;
    private NetworkStatusPanel statusPanel;
    private BlockingQueue workQueue = new ArrayBlockingQueue(1, true);
    private static NetworkStatus instance = new NetworkStatus();
    public Signal networkStatusChanged = Signals.createSignal();

    private NetworkStatus() {
        this.data.setThisAddress("0.0.0.0");
        this.data.setHostAddress("0.0.0.0");
        this.data.setWanConnected(false);
        this.updateTimer = new Timer(120000, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                NetworkStatus.this.updateStatus();
            }
        });
        this.updateStatus();
        new Thread(new Runnable(){

            @Override
            public void run() {
                while (true) {
                    try {
                        while (true) {
                            NetworkUpdateRunner runnable = (NetworkUpdateRunner)NetworkStatus.this.workQueue.take();
                            runnable.run();
                        }
                    }
                    catch (Exception ex) {
                        OrderMateLog.LOG.error("An exception occurred in the network status updater", (Throwable)ex);
                        continue;
                    }
                    break;
                }
            }
        }, "Network status updater").start();
    }

    public static NetworkStatus getInstance() {
        return instance;
    }

    private void updateStatus() {
        this.updateTimer.stop();
        this.setUpdating(true);
        NetworkUpdateRunner updater = new NetworkUpdateRunner();
        this.workQueue.offer(updater);
    }

    private void finishedUpdating() {
        this.setUpdating(false);
        this.updateTimer.start();
    }

    public boolean isUpdating() {
        return this.isUpdating;
    }

    private void setUpdating(boolean value) {
        this.isUpdating = value;
        if (this.statusPanel != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    NetworkStatus.this.statusPanel.statusChanged();
                }
            });
        }
        this.networkStatusChanged.emit();
    }

    public boolean isHostResolved() {
        return this.data.isHostResolved;
    }

    public boolean isWanConnected() {
        return this.data.isWanConnected;
    }

    public String getThisAddress() {
        return this.data.thisAddress;
    }

    public String getHostAddress() {
        return this.data.hostAddress;
    }

    public void showDialog() {
        if (this.statusPanel == null) {
            this.statusPanel = new NetworkStatusPanel();
        }
        if (!this.isUpdating) {
            this.updateStatus();
        }
        this.statusPanel.statusChanged();
        this.updateExternalIP();
        Dialogs.displayDialog((JComponent)this.statusPanel, (String)Internationalization.getLiteralFor((String)"NETWORK_STATUS"), (boolean)false);
    }

    private void updateExternalIP() {
        this.statusPanel.setExternalIP(Internationalization.getLiteralFor((String)"UPDATING_ETC"));
        new SwingWorker(){

            public Object doInBackground() {
                String externalIP = "";
                if (NetworkStatus.this.isWanConnected()) {
                    externalIP = IPAddressUtils.getIPAddress();
                }
                return externalIP;
            }

            @Override
            protected void done() {
                try {
                    NetworkStatus.this.statusPanel.setExternalIP(this.get() + "");
                }
                catch (ExecutionException ex) {
                    OrderMateLog.LOG.warn("Error setting the text on external IP label.", (Throwable)ex);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }.execute();
    }

    void setWanConnected(boolean enabled) {
        if (this.data != null) {
            this.data.setWanConnected(enabled);
        }
    }

    static class NetworkStatusData {
        private volatile String thisAddress;
        private volatile String hostAddress;
        private volatile boolean isWanConnected;
        private volatile boolean isHostResolved;

        NetworkStatusData() {
        }

        public void setThisAddress(String address) {
            this.thisAddress = address;
        }

        public String getThisAddress() {
            return this.thisAddress;
        }

        public void setHostAddress(String address) {
            this.hostAddress = address;
        }

        public String getHostAddress() {
            return this.hostAddress;
        }

        public void setWanConnected(boolean connected) {
            this.isWanConnected = connected;
        }

        public boolean isWanConnected() {
            return this.isWanConnected;
        }

        public void setHostResolved(boolean isResolved) {
            this.isHostResolved = isResolved;
        }

        public boolean isHostResolved() {
            return this.isHostResolved;
        }
    }

    class NetworkUpdateRunner
    implements Runnable {
        NetworkUpdateRunner() {
        }

        @Override
        public void run() {
            InetAddress address;
            NetworkStatus.this.data.setHostResolved(false);
            try {
                address = InetAddress.getByName(Terminal.getServerMateTerminal().getIPAddress());
                NetworkStatus.this.data.setHostAddress(address.getHostAddress());
                NetworkStatus.this.data.setHostResolved(address.isReachable(10000));
            }
            catch (UnknownHostException ex) {
                NetworkStatus.this.data.setHostAddress("Error: Unknown Host");
                NetworkStatus.this.data.setHostResolved(false);
            }
            catch (IOException ex) {
                NetworkStatus.this.data.setHostAddress("Error: Cannot reach host");
                NetworkStatus.this.data.setHostResolved(false);
            }
            try {
                address = InetAddress.getLocalHost();
                NetworkStatus.this.data.setThisAddress(address.getHostAddress());
            }
            catch (UnknownHostException e) {
                NetworkStatus.this.data.setThisAddress("0.0.0.0");
            }
            this.checkWanConnection();
            NetworkStatus.this.finishedUpdating();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean canConnectTo(URL url) {
            boolean wanUp = false;
            HttpURLConnection connection = null;
            try {
                connection = (HttpURLConnection)url.openConnection();
                connection.connect();
                wanUp = true;
            }
            catch (UnknownHostException ex) {
                OrderMateLog.LOG.info("Couldn't find host: " + url.toExternalForm() + "  MSG:" + ex.getMessage());
            }
            catch (IOException ex) {
                OrderMateLog.LOG.info("NetworkStatus.canConnectTo : IOException while reaching host:" + ex.getMessage());
            }
            finally {
                if (connection != null) {
                    connection.disconnect();
                }
            }
            return wanUp;
        }

        private void checkWanConnection() {
            NetworkStatus.this.data.setWanConnected(false);
            try {
                if (this.canConnectTo(new URL("http://www.ordermate.com.au")) || this.canConnectTo(new URL("http://www.google.com.au"))) {
                    NetworkStatus.this.data.setWanConnected(true);
                }
            }
            catch (MalformedURLException ex) {
                WaiterMate.LOG.error("This should happen as the URL's look well formed to me", (Throwable)ex);
            }
        }
    }
}

