/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.login;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import javax.swing.JLabel;
import org.jdesktop.animation.timing.Animator;
import org.jdesktop.animation.timing.TimingTarget;

public class PasswordLabel
extends JLabel {
    private static final int ANIM_TIME = 150;
    private volatile boolean isMoving = false;
    private volatile int origXPos = 0;
    private volatile int circleWidth = 0;
    private volatile boolean isDeleting = false;
    private volatile int currentInputAmount = 0;
    private volatile double sizeMultiplier = 1.0;
    private Animator anim;
    private WhooshTarget theTimer = new WhooshTarget();

    public PasswordLabel() {
        this.anim = new Animator(150, (TimingTarget)this.theTimer);
        this.anim.setAcceleration(0.5f);
        this.anim.setDeceleration(0.5f);
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (this.getText() != null && !this.getText().isEmpty()) {
            g.setColor(this.getForeground());
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            int width = this.getCircleWidth(g);
            int chars = this.getText().length();
            if (chars != this.currentInputAmount) {
                if (this.anim.isRunning()) {
                    this.anim.stop();
                }
                if (chars < this.currentInputAmount) {
                    this.isDeleting = true;
                }
                this.isMoving = true;
                this.sizeMultiplier = 0.0;
                this.anim.start();
            }
            this.currentInputAmount = chars;
            int totalWidth = 2 * width * chars;
            int xPos = (this.getWidth() - totalWidth + width) / 2;
            if (this.isDeleting) {
                ++chars;
            }
            for (int i = 0; i < chars; ++i) {
                Color alphaColor;
                int modWidth = width;
                int modX = 0;
                if (i + 1 == this.currentInputAmount && !this.isDeleting) {
                    modWidth = (int)((double)width * this.sizeMultiplier);
                    alphaColor = new Color(this.getForeground().getRed(), this.getForeground().getGreen(), this.getForeground().getBlue(), (int)(255.0 * this.sizeMultiplier));
                    g.setColor(alphaColor);
                    modX = (int)(-(this.sizeMultiplier - 1.0) * 30.0);
                } else if (i == this.currentInputAmount && this.isDeleting) {
                    modWidth = (int)((double)width * (1.0 - this.sizeMultiplier));
                    alphaColor = new Color(this.getForeground().getRed(), this.getForeground().getGreen(), this.getForeground().getBlue(), (int)(255.0 * (1.0 - this.sizeMultiplier)));
                    g.setColor(alphaColor);
                    modX = (int)(this.sizeMultiplier * 30.0);
                }
                if (this.isMoving) {
                    xPos = (int)((double)this.origXPos + (double)(xPos - this.origXPos) * this.sizeMultiplier);
                }
                g.fillOval(xPos + width * i * 2 + modX, width / 2, modWidth, modWidth);
            }
        } else if (this.getText().isEmpty() && this.currentInputAmount != 0) {
            this.currentInputAmount = 0;
        }
    }

    @Override
    public void setText(String text) {
        this.origXPos = (this.getWidth() - 2 * this.getCircleWidth() * this.getText().length() + this.getCircleWidth()) / 2;
        super.setText(text);
    }

    private int getCircleWidth(Graphics g) {
        this.circleWidth = g.getFontMetrics().charWidth('m');
        return this.circleWidth;
    }

    private int getCircleWidth() {
        return this.circleWidth;
    }

    private class WhooshTarget
    implements TimingTarget {
        private WhooshTarget() {
        }

        public void begin() {
            PasswordLabel.this.sizeMultiplier = 0.0;
        }

        public void end() {
            PasswordLabel.this.sizeMultiplier = 1.0;
            PasswordLabel.this.isDeleting = false;
            PasswordLabel.this.isMoving = false;
            PasswordLabel.this.repaint();
        }

        public void timingEvent(float fraction) {
            PasswordLabel.this.sizeMultiplier = fraction;
            PasswordLabel.this.repaint();
        }

        public void repeat() {
        }
    }
}

