/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.ordering;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import ordermate.database.sales.Account;
import ordermate.gui.DecoratorLocation;
import ordermate.gui.scroll.CustomScrollPane;
import ordermate.gui.scroll.CustomScrollPaneModel;
import ordermate.gui.scroll.DefaultScrollPaneModel;
import ordermate.gui.themes.OrderMateTheme;
import ordermate.signals.Signal;
import ordermate.signals.Signals;

class ChooseAccount
extends JPanel
implements ActionListener {
    Signal<Account, ?, ?, ?, ?> accountSelected = Signals.createSignal(Account.class, (String)"selectedAccount");
    private CustomScrollPane scrolly;
    private DefaultScrollPaneModel model;
    private ButtonGroup buttonGroup;
    private List<JToggleButton> accountButtons;
    private List<Account> accounts = new ArrayList<Account>();
    private Account selectedAccount;

    ChooseAccount() {
        super(new BorderLayout());
        this.accountButtons = new ArrayList<JToggleButton>();
        this.model = new DefaultScrollPaneModel(1, 6);
        this.scrolly = new CustomScrollPane((CustomScrollPaneModel)this.model);
        this.scrolly.setDecorationLocation(DecoratorLocation.NorthSouth);
        this.add((Component)this.scrolly, "Center");
    }

    public void setAccounts(List<? extends Account> theAccounts, Account startingAccount) {
        this.selectedAccount = null;
        this.accounts.clear();
        if (theAccounts != null) {
            this.accounts.addAll(theAccounts);
        }
        this.rebuildButtons();
        int index = this.accounts.indexOf(startingAccount);
        if (index >= 0) {
            this.accountButtons.get(index).setSelected(true);
        }
    }

    public List<? extends Account> getAccounts() {
        return this.accounts;
    }

    public void addAccount(Account account) {
        this.accounts.add(account);
        this.rebuildButtons();
    }

    private void rebuildButtons() {
        this.buttonGroup = new ButtonGroup();
        this.accountButtons.clear();
        for (Account account : this.accounts) {
            JToggleButton button = new JToggleButton(account.getLabel());
            OrderMateTheme.setupTouchScreenButton((AbstractButton)button);
            this.buttonGroup.add(button);
            button.addActionListener(this);
            this.accountButtons.add(button);
        }
        this.model.setItems(this.accountButtons);
        this.scrolly.setModel((CustomScrollPaneModel)this.model);
    }

    public boolean hasAccounts() {
        return !this.accounts.isEmpty();
    }

    public int count() {
        return this.accounts.size();
    }

    public void setSelectedAccount(Account value) {
        int index = this.accounts.indexOf(value);
        if (index >= 0) {
            if (!this.accountButtons.get(index).isSelected()) {
                this.accountButtons.get(index).setSelected(true);
            }
            this.selectedAccount = this.accounts.get(index);
        }
    }

    public Account getSelectedAccount() {
        return this.selectedAccount;
    }

    private void accountChanged() {
        this.accountSelected.emit((Object)this.selectedAccount);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int index = this.accountButtons.indexOf(e.getSource());
        if (index >= 0) {
            this.selectedAccount = this.accounts.get(index);
            this.accountChanged();
        }
    }

    public int getNumAccounts() {
        return this.accounts.size();
    }
}

