/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.ordering;

import au.com.ordermate.gui.GuiHandler;
import au.com.ordermate.guicore.task.AbstractTask;
import ordermate.OrderMate;
import ordermate.database.EventContext;
import ordermate.database.finance.giftvoucher.GiftVoucherTransaction;
import ordermate.database.finance.giftvoucher.VoucherResponse;
import ordermate.database.sales.Account;
import ordermate.integration.voucher.VoucherAdministratorRMI;

public class VoucherTransactionReturner {
    private final GuiHandler gui;

    public VoucherTransactionReturner(GuiHandler yourHandler) {
        this.gui = yourHandler;
    }

    public void returnTransaction(final GiftVoucherTransaction voucherTxn, final EventContext eventContext) {
        AbstractTask task = new AbstractTask(){

            public String getName() {
                return "Returning Transaction";
            }

            protected void performTask() throws Exception {
                VoucherResponse response = voucherTxn.isConfirmed() ? VoucherAdministratorRMI.getInstance().reverseTransaction(voucherTxn, eventContext) : VoucherAdministratorRMI.getInstance().cancelTransaction(voucherTxn, eventContext);
                OrderMate.LOG.info("Returning Transaction, got:" + response.getError());
                if (response.getTxn() != null) {
                    Account acc = voucherTxn.getAccount();
                    acc.removeVoucherTransaction(voucherTxn);
                    acc.addVoucherTransaction(response.getTxn());
                } else {
                    OrderMate.LOG.warn("Cannot return the transaction" + response.getDescription());
                    VoucherTransactionReturner.this.gui.displayOkDialog(response.getDescription(), "Cannot return Transaction!");
                }
            }

            protected int getTotalSubTasks() {
                return 1;
            }
        };
        this.gui.doProgressTask(task);
    }
}

