/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.ordering.accountadmin;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import ordermate.OrderMate;
import ordermate.database.finance.priceadjustment.SalesPriceAdjustment;
import ordermate.database.finance.priceadjustment.sales.SalesPriceAdjustmentI;
import ordermate.database.inventory.InventoryItem;
import ordermate.database.inventory.triggers.activation.TriggerActivationContext;
import ordermate.database.misc.HOConfig;
import ordermate.database.misc.SystemProperty;
import ordermate.database.sales.Account;
import ordermate.database.sales.Customer;
import ordermate.database.sales.CustomerUpdateManager;
import ordermate.database.sales.ItemGroup;
import ordermate.database.sales.PhoneAccount;
import ordermate.database.sales.Sellable;
import ordermate.database.sales.SellableWrapperFactory;
import ordermate.database.sales.TableAccount;
import ordermate.database.sales.loyalty.LoyaltyPointAdministrator;
import ordermate.internationalization.Internationalization;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import waitermate.LoginManager;
import waitermate.gui.WaitermateAccountGui;
import waitermate.gui.additems.search.InventoryItemSearchPanel;
import waitermate.gui.customerdisplay.WaiterMateCustomerDisplay;
import waitermate.gui.dialogs.AutoComboSelector;
import waitermate.gui.dialogs.PhoneDeliveryTypeDialog;
import waitermate.gui.screens.admin.printer.reprintdockets.ReprintDocket;
import waitermate.gui.screens.customer.SelectCustomer;
import waitermate.gui.screens.ordering.accountadmin.AccountAdminPanel;
import waitermate.gui.screens.ordering.accountadmin.discountitems.AdjustmentItems;
import waitermate.gui.screens.ordering.accountadmin.holditems.HoldItems;
import waitermate.gui.screens.ordering.giftvoucher.WaiterMateGiftVouchers;
import waitermate.gui.screens.ordering.refunditems.RefundItems;
import waitermate.gui.screens.ordering.saveaccount.WaitermateSaveAccount;
import waitermate.gui.screens.ordering.transferitems.TransferItems;
import waitermate.gui.screens.selectaccount.table.CoversHelper;
import waitermate.guikit.AbstractScreen;
import waitermate.guikit.NavBar;
import waitermate.guikit.ScreenResource;
import waitermate.guikit.dialogs.AccountComments;
import waitermate.guikit.dialogs.Dialogs;

public class AccountAdmin
extends AbstractScreen {
    private Account currentAccount;
    private Signal back;
    private Signal done;
    private Signal<Account, InventoryItem, ?, ?, ?> itemFound;
    private Signal voucherTopup;
    private final Signal display = Signals.createSignal();
    private final AccountAdminPanel gui;
    private NavBar navBar;
    private AdjustmentItems discountItems;
    private HoldItems holdItems;
    private ReprintDocket reprintDocket;
    private final Signal autoComboDone = Signals.createSignal();
    private PhoneDeliveryTypeDialog popupWindow;
    private InventoryItemSearchPanel searchPanel;
    private SellableWrapperFactory sellableFactory;
    public static final AccountAdmin instance = new AccountAdmin();

    public static AccountAdmin getInstance() {
        return instance;
    }

    public void tearDown() {
        try {
            CustomerUpdateManager.getInstance().customerUpdated.disconnect((Object)this);
        }
        catch (Exception ex) {
            OrderMate.LOG.error("Error occurred disconecting from customerUpdated signal.", (Throwable)ex);
        }
        super.tearDown();
    }

    private AccountAdmin() {
        this.navBar = new NavBar();
        this.navBar.addLeft((Component)this.navBar.getBackButton());
        this.display.connect((Object)this, "display");
        this.gui = new AccountAdminPanel();
        this.navBar.back.connect((Object)this, "gotBack");
        this.gui.transferItems.connect((Object)this, "gotTransferItems");
        this.gui.changeNumPatrons.connect((Object)this, "gotNumPatrons");
        this.gui.discountItems.connect((Object)this, "gotDiscountItems");
        this.gui.holdItems.connect((Object)this, "gotHoldItems");
        this.gui.setCustomer.connect((Object)this, "gotSetCustomer");
        this.gui.setDeliverable.connect((Object)this, "gotSetDeliverable");
        this.gui.removeCustomer.connect((Object)this, "gotRemoveCustomer");
        this.gui.reprintPrep.connect((Object)this, "gotReprint");
        this.gui.createCombo.connect((Object)this, "gotMakeCombo");
        this.gui.breakCombo.connect((Object)this, "gotBreakCombo");
        this.gui.findItem.connect((Object)this, "gotFindItem");
        this.gui.sendMessage.connect((Object)this, "gotSendMessage");
        this.gui.refundItems.connect((Object)this, "gotRefundItems");
        this.gui.giftVouchersAdmin.connect((Object)this, "gotGiftVoucher");
        this.gui.accountComments.connect((Object)this, "gotAccountComments");
        if (SystemProperty.getInstance().formAutoCombosFromAdmin()) {
            this.autoComboDone.connect((Object)this, "setupGUI");
        }
    }

    void startAdmin() {
        if (this.currentAccount != null) {
            this.startAdmin(this.currentAccount, this.done, this.back, this.itemFound, this.voucherTopup);
        }
    }

    void gotBack() {
        this.back.emit();
    }

    public void startAdmin(Account newCurrentAccount, Signal doneSignal, Signal backSignal, Signal<Account, InventoryItem, ?, ?, ?> itemFoundSignal, Signal voucherTopupSignal) {
        if (doneSignal == null) {
            throw new IllegalArgumentException("Done signal should not be null");
        }
        if (backSignal == null) {
            throw new IllegalArgumentException("Back signal should not be null");
        }
        if (newCurrentAccount == null) {
            throw new IllegalArgumentException("Account should not be null");
        }
        this.currentAccount = newCurrentAccount;
        this.done = doneSignal;
        this.back = backSignal;
        this.itemFound = itemFoundSignal;
        this.voucherTopup = voucherTopupSignal;
        this.setupGUI();
        this.display();
    }

    public void display() {
        super.display();
        try {
            CustomerUpdateManager.getInstance().customerUpdated.connect((Object)this, "gotUpdateCustomer");
        }
        catch (Exception ex) {
            OrderMate.LOG.error("Error occurred connecting from customerUpdated signal.", (Throwable)ex);
        }
    }

    void gotTransferItems() {
        if (this.currentAccount.isOnHold()) {
            Dialogs.displayOkDialog((String)Internationalization.getLiteralFor((String)"CANNOT_TRANSFER_ITEMS_FROM_AN_ACCOUNT_ON_HOLD"), (String)Internationalization.getLiteralFor((String)"THE_ACCOUNT_IS_ON_HOLD"));
        } else if (!this.currentAccount.getItemHelper().getUnpaidItems().isEmpty()) {
            if (WaitermateSaveAccount.getInstance().addInfo(this.currentAccount)) {
                WaitermateSaveAccount.getInstance().saveAccount(this.currentAccount, LoginManager.getEventContext());
                WaitermateSaveAccount.getInstance().printPrep(this.currentAccount);
                TransferItems.getInstance().startTransfer(this.currentAccount, this.done, this.display, false);
            }
        } else {
            Dialogs.displayOkDialog((String)Internationalization.getLiteralFor((String)"THERE_ARE_NO_ITEMS_TO_TRANSFER"), (String)Internationalization.getLiteralFor((String)"NO_ITEMS"));
        }
    }

    void gotNumPatrons() {
        TableAccount account = (TableAccount)this.currentAccount;
        CoversHelper ch = new CoversHelper();
        ch.promptForCovers(account.getNumPatrons(), account.getSeats(), account.getTable());
        if (ch.getCovers() > -1) {
            ch.updateAccount(account);
        } else {
            this.back.emit();
        }
    }

    void gotDiscountItems() {
        if (!this.currentAccount.getItemHelper().getUnpaidItems().isEmpty()) {
            if (this.discountItems == null) {
                this.discountItems = new AdjustmentItems();
                this.discountItems.cancel.connect((Object)this, "gotBack");
                this.discountItems.done.connect((Object)this, "gotBack");
                this.discountItems.removeItemAdjustment.connect((Object)this, "gotRemoveItemAdjustement");
            }
            this.discountItems.startDiscountAccount((ItemGroup)this.currentAccount);
        } else {
            Dialogs.displayOkDialog((String)Internationalization.getLiteralFor((String)"THERE_ARE_NO_ITEMS_TO_DISCOUNT"), (String)Internationalization.getLiteralFor((String)"NO_ITEMS"));
        }
    }

    void gotHoldItems() {
        if (this.currentAccount.isOnHold()) {
            Dialogs.displayOkDialog((String)Internationalization.getLiteralFor((String)"CANNOT_HOLD_ITEMS_IN_AN_ACCOUNT_THAT_IS_ON_HOLD"), (String)Internationalization.getLiteralFor((String)"ENTIRE_ACCOUNT_IS_ON_HOLD"));
            return;
        }
        if (this.sellableFactory == null) {
            this.sellableFactory = new SellableWrapperFactory();
        }
        List allSellables = this.sellableFactory.getSellables((ItemGroup)this.currentAccount);
        ArrayList<Sellable> toBeHeld = new ArrayList<Sellable>();
        for (Sellable item : allSellables) {
            if (item.isPersistent() || !item.canBeHeld()) continue;
            toBeHeld.add(item);
        }
        if (toBeHeld.isEmpty()) {
            Dialogs.displayOkDialog((String)("<html>" + Internationalization.getLiteralFor((String)"ONLY_ITEMS_WHICH_HAVE_BEEN_SAVED_CAN_BE_HELD") + "<br>" + Internationalization.getLiteralFor((String)"ALL_ITEMS_IN_THE_ACCOUNT_HAVE_BEEN_SAVED") + "</html>"), (String)Internationalization.getLiteralFor((String)"CANNOT_HOLD_ITEMS"));
        } else {
            if (this.holdItems == null) {
                this.holdItems = new HoldItems();
                this.holdItems.cancel.connect((Object)this, "gotBack");
                this.holdItems.done.connect((Object)this, "gotBack");
            }
            this.holdItems.startHoldAccount(toBeHeld);
        }
    }

    public JComponent getMainArea() {
        return this.gui;
    }

    public NavBar getNavBar() {
        return this.navBar;
    }

    public void gotSetCustomer() {
        final Customer newCustomer = SelectCustomer.startModal(this.currentAccount.getCustomerRequirements(), false);
        if (newCustomer != null) {
            this.currentAccount.setCustomer(newCustomer, LoginManager.getEventContext());
            if (HOConfig.getInstance().isConfigured()) {
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        LoyaltyPointAdministrator.getInstance().updatePointsForCustomer(newCustomer);
                    }
                }).start();
            }
            this.gotUpdateCustomer(newCustomer);
            CustomerUpdateManager.getInstance().addCustomerToUpdate(newCustomer);
        }
    }

    public void gotUpdateCustomer(Customer customer) {
        WaitermateAccountGui.getInstance().accountChanged(this.currentAccount);
        this.setupGUI();
    }

    void gotSetDeliverable() {
        if (!(this.currentAccount instanceof PhoneAccount)) {
            return;
        }
        PhoneAccount account = (PhoneAccount)this.currentAccount;
        if (account.hasDelivery()) {
            String s = Internationalization.getLiteralFor((String)"CANNOT_CHANGE_THIS_ACCOUNT_AS_IT_HAS_A_DELIVERY_ASSOCIATED_WITH_IT");
            Dialogs.displayOkDialog((String)s, (String)Internationalization.getLiteralFor((String)"ACCOUNT_HAS_DELIVERY"));
            return;
        }
        if (this.popupWindow == null) {
            this.popupWindow = new PhoneDeliveryTypeDialog();
        }
        account.setDeliverable(this.popupWindow.isDeliverySelected(), LoginManager.getEventContext());
    }

    void gotRemoveCustomer() {
        this.currentAccount.clearCustomerFields(LoginManager.getEventContext());
        WaitermateAccountGui.getInstance().accountChanged(this.currentAccount);
        this.setupGUI();
    }

    void setupGUI() {
        if (SystemProperty.getInstance().isCustomerAssignmentPerSeat()) {
            this.gui.setup(this.currentAccount.getAccountType(), this.currentAccount.hasCustomer(), false, false);
        } else {
            AutoComboSelector selector = this.configureAutoComboSelector();
            this.gui.setup(this.currentAccount.getAccountType(), this.currentAccount.hasCustomer(), selector.canMakeCombos(), selector.canBreakCombos());
        }
    }

    public void gotReprint() {
        if (this.reprintDocket == null) {
            this.reprintDocket = new ReprintDocket();
            this.reprintDocket.done.connect((Object)this, "gotBack");
        }
        this.reprintDocket.start(this.currentAccount);
    }

    public void gotMakeCombo() {
        this.configureAutoComboSelector().startMake();
    }

    public void gotBreakCombo() {
        this.configureAutoComboSelector().startBreak();
    }

    public void gotFindItem(Boolean resetSearch) {
        if (!this.isDisplaying()) {
            this.display();
        }
        if (this.searchPanel == null) {
            this.searchPanel = new InventoryItemSearchPanel();
            this.searchPanel.objectSelected.connect((Object)this, "gotItemFromSearch");
            this.searchPanel.back.connect((Object)this, "gotBackFromSearch");
        }
        TriggerActivationContext context = new TriggerActivationContext(LoginManager.getEventContext(), new Date(), (ItemGroup)this.currentAccount);
        this.searchPanel.startSearch(context, null, resetSearch != null ? resetSearch : true);
        ScreenResource.startModalWindow((JPanel)this.searchPanel);
    }

    public void gotItemFromSearch(InventoryItem item) {
        this.gotBackFromSearch();
        this.itemFound.emit((Object)this.currentAccount, (Object)item);
    }

    public void gotBackFromSearch() {
        ScreenResource.stopWindow((JComponent)this.searchPanel);
    }

    public void gotRemoveItemAdjustement(SalesPriceAdjustmentI adjustment) {
        this.currentAccount.removePriceAdjustment((SalesPriceAdjustment)adjustment, LoginManager.getEventContext());
    }

    public void gotSendMessage() {
        if (WaiterMateCustomerDisplay.isActive()) {
            WaiterMateCustomerDisplay.getInstance().sendMessage();
        }
    }

    public void gotRefundItems() {
        RefundItems.getInstance().startRefund(this.currentAccount, this.display, this.display);
    }

    private AutoComboSelector configureAutoComboSelector() {
        AutoComboSelector selector = AutoComboSelector.getInstance();
        selector.configureSignal(this.autoComboDone);
        selector.setContext((ItemGroup)this.currentAccount, null, LoginManager.getEventContext());
        return selector;
    }

    public void gotGiftVoucher() {
        WaiterMateGiftVouchers giftVouchersStartPoint = new WaiterMateGiftVouchers(this.currentAccount, this.voucherTopup);
        giftVouchersStartPoint.start();
    }

    public void gotAccountComments() {
        new AccountComments(this.currentAccount).displayAccountComments(LoginManager.getInstance().getUser());
    }
}

