/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.ordering.accountadmin;

import au.com.ordermate.util.image.IconLoader;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JComponent;
import ordermate.database.hardware.Terminal;
import ordermate.database.misc.SystemProperty;
import ordermate.database.misc.enums.DeterminePatrons;
import ordermate.database.sales.AccountType;
import ordermate.database.sales.BarTabAccount;
import ordermate.database.sales.PhoneAccount;
import ordermate.database.sales.TableAccount;
import ordermate.database.sales.customer.assignment.CustomerAssignmentHelper;
import ordermate.database.users.AllPermissions;
import ordermate.gui.modify.security.StandardSecurityDecorator;
import ordermate.gui.scroll.CustomScrollPane;
import ordermate.gui.scroll.CustomScrollPaneModel;
import ordermate.gui.scroll.DefaultScrollPaneModel;
import ordermate.internationalization.Internationalization;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import waitermate.gui.customerdisplay.WaiterMateCustomerDisplay;
import waitermate.gui.modify.security.SwipeOverSecurityDecorator;

class AccountAdminPanel
extends CustomScrollPane
implements ActionListener {
    private JButton transferItemsButton;
    private StandardSecurityDecorator transferItemsDec;
    private JButton numPatronsButton;
    private JButton discountItemsButton;
    private StandardSecurityDecorator discountItemsDec;
    private JButton holdItemsButton;
    private JButton setCustomerButton;
    private JButton setDeliverableButton;
    private JButton removeCustomerButton;
    private JButton reprintButton;
    private JButton createComboButton;
    private JButton breakComboButton;
    private JButton findItemButton;
    private JButton sendMessageButton;
    private JButton accountCommentsButton;
    private JButton refundItemsButton;
    private StandardSecurityDecorator refundItemsDec;
    private StandardSecurityDecorator reprintDec;
    private StandardSecurityDecorator createComboButtonDec;
    private StandardSecurityDecorator breakComboButtonDec;
    private StandardSecurityDecorator setCustomerDec;
    private JButton giftVouchersAdminButton;
    private StandardSecurityDecorator giftVouchersAdminDec;
    DefaultScrollPaneModel scrollModel;
    public final Signal transferItems = Signals.createSignal();
    public final Signal changeNumPatrons = Signals.createSignal();
    public final Signal discountItems = Signals.createSignal();
    public final Signal holdItems = Signals.createSignal();
    public final Signal setCustomer = Signals.createSignal();
    public final Signal setDeliverable = Signals.createSignal();
    public final Signal removeCustomer = Signals.createSignal();
    public final Signal reprintPrep = Signals.createSignal();
    public final Signal createCombo = Signals.createSignal();
    public final Signal breakCombo = Signals.createSignal();
    public final Signal sendMessage = Signals.createSignal();
    public final Signal refundItems = Signals.createSignal();
    public final Signal giftVouchersAdmin = Signals.createSignal();
    public final Signal accountComments = Signals.createSignal();
    public final Signal<Boolean, ?, ?, ?, ?> findItem = Signals.createSignal(Boolean.class, (String)"resetSearch");

    public AccountAdminPanel() {
        super((CustomScrollPaneModel)new DefaultScrollPaneModel(3, 5));
        this.scrollModel = (DefaultScrollPaneModel)this.getModel();
        this.transferItemsButton = new JButton(Internationalization.getLiteralFor((String)"TRANSFER_ITEMS"));
        this.transferItemsButton.setIcon(IconLoader.get((String)"/waitermate/images/transfer.png"));
        this.transferItemsButton.addActionListener(this);
        this.transferItemsDec = new StandardSecurityDecorator((JComponent)this.transferItemsButton, AllPermissions.TRANSFER_ITEMS);
        this.refundItemsButton = new JButton(Internationalization.getLiteralFor((String)"REFUND_ITEMS"));
        this.refundItemsButton.setIcon(IconLoader.get((String)"/waitermate/images/redo.png"));
        this.refundItemsButton.addActionListener(this);
        this.refundItemsDec = new SwipeOverSecurityDecorator(this.refundItemsButton, AllPermissions.QUICK_REFUND, this.refundItems, new String[]{"AccountAdmin"});
        this.numPatronsButton = new JButton(Internationalization.getLiteralFor((String)"NUMBER_OF_COVERS"));
        this.numPatronsButton.setIcon(IconLoader.get((String)"/waitermate/images/customer.png"));
        this.numPatronsButton.addActionListener(this);
        this.discountItemsButton = new JButton(Internationalization.getLiteralFor((String)"DISCOUNT_ITEMS"));
        this.discountItemsButton.setIcon(IconLoader.get((String)"/waitermate/images/money.png"));
        this.discountItemsButton.addActionListener(this);
        this.discountItemsDec = new StandardSecurityDecorator((JComponent)this.discountItemsButton, AllPermissions.DISCOUNT);
        this.holdItemsButton = new JButton(Internationalization.getLiteralFor((String)"HOLD_ITEMS"));
        this.holdItemsButton.setIcon(IconLoader.get((String)"/waitermate/images/clock.png"));
        this.holdItemsButton.addActionListener(this);
        this.setCustomerButton = new JButton(Internationalization.getLiteralFor((String)"SET_CUSTOMER"));
        this.setCustomerButton.setIcon(IconLoader.get((String)"/waitermate/images/customer.png"));
        this.setCustomerButton.addActionListener(this);
        this.setCustomerDec = new SwipeOverSecurityDecorator(this.setCustomerButton, AllPermissions.SET_CUSTOMER_ON_ACCOUNT, this.setCustomer, new String[]{"AccountAdmin"});
        this.removeCustomerButton = new JButton(Internationalization.getLiteralFor((String)"REMOVE_CUSTOMER"));
        this.removeCustomerButton.addActionListener(this);
        this.removeCustomerButton.setIcon(IconLoader.get((String)"/waitermate/guikit/images/cancel.png"));
        this.setDeliverableButton = new JButton(Internationalization.getLiteralFor((String)"PICKUP_OR_DELIVERY"));
        this.setDeliverableButton.setIcon(IconLoader.get((String)"/waitermate/images/delivery.png"));
        this.setDeliverableButton.addActionListener(this);
        this.reprintButton = new JButton(Internationalization.getLiteralFor((String)"REPRINT_PREP_DOCKETS"));
        this.reprintButton.setIcon(IconLoader.get((String)"/waitermate/images/reprint.png"));
        this.reprintButton.addActionListener(this);
        this.reprintDec = new StandardSecurityDecorator((JComponent)this.reprintButton, AllPermissions.REPRINT_PREP_DOCKETS);
        this.createComboButton = new JButton(Internationalization.getLiteralFor((String)"MAKE_COMBOS"));
        this.createComboButton.setIcon(IconLoader.get((String)"/waitermate/images/comboMake.png"));
        this.createComboButton.addActionListener(this);
        this.createComboButtonDec = new StandardSecurityDecorator((JComponent)this.createComboButton, AllPermissions.MAKE_COMBOS);
        this.breakComboButton = new JButton(Internationalization.getLiteralFor((String)"BREAK_COMBOS"));
        this.breakComboButton.setIcon(IconLoader.get((String)"/waitermate/images/comboBreak.png"));
        this.breakComboButton.addActionListener(this);
        this.breakComboButtonDec = new StandardSecurityDecorator((JComponent)this.breakComboButton, AllPermissions.BREAK_COMBOS);
        this.findItemButton = new JButton(Internationalization.getLiteralFor((String)"FIND_ITEM"));
        this.findItemButton.setIcon(IconLoader.get((String)"/waitermate/images/find.png"));
        this.findItemButton.addActionListener(this);
        this.sendMessageButton = new JButton(Internationalization.getLiteralFor((String)"CUSTOMER_DISPLAY_MESSAGE"));
        this.sendMessageButton.setIcon(IconLoader.get((String)"/waitermate/images/barcode.png"));
        this.sendMessageButton.addActionListener(this);
        this.accountCommentsButton = new JButton(Internationalization.getLiteralFor((String)"COMMENTS"));
        this.accountCommentsButton.setIcon(IconLoader.get((String)"/waitermate/images/blue_speech_bubble_48.png"));
        this.accountCommentsButton.addActionListener(this);
        this.giftVouchersAdminButton = new JButton(Internationalization.getLiteralFor((String)"VOUCHER_PURCHASE"));
        this.giftVouchersAdminButton.setName("giftVouchers");
        this.giftVouchersAdminButton.setIcon(IconLoader.get((String)"/waitermate/images/voucher.png"));
        this.giftVouchersAdminDec = new SwipeOverSecurityDecorator(this.giftVouchersAdminButton, AllPermissions.VOUCHERS_GEN, this.giftVouchersAdmin, new String[]{"AccountAdmin"});
    }

    public void setup(AccountType acctType, boolean hasCustomer, boolean canMakeCombo, boolean canBreakCombo) {
        ArrayList<Object> components = new ArrayList<Object>();
        if (!Terminal.getLocalHost().hasQuickSale() || Terminal.getLocalHost().hasTableMode() || Terminal.getLocalHost().hasTakeawayMode() || Terminal.getLocalHost().hasPhoneMode() || Terminal.getLocalHost().hasBarTabsMode()) {
            components.add(this.transferItemsDec);
        }
        if (TableAccount.TYPE.equals((Object)acctType) || AccountType.onlineTableType.equals((Object)acctType)) {
            components.add(this.numPatronsButton);
        }
        if (!BarTabAccount.TYPE.equals((Object)acctType)) {
            components.add(this.holdItemsButton);
        }
        components.add(this.discountItemsDec);
        if (PhoneAccount.TYPE.equals((Object)acctType) && Terminal.getLocalHost().hasDeliveryMode()) {
            components.add(this.setDeliverableButton);
        }
        components.add(this.setCustomerDec);
        components.add(this.removeCustomerButton);
        this.removeCustomerButton.setEnabled(hasCustomer && !PhoneAccount.TYPE.equals((Object)acctType));
        boolean enableCustomerControls = !new CustomerAssignmentHelper().isAssignmentPerSeat(acctType);
        this.setCustomerDec.setEnabled(enableCustomerControls);
        this.removeCustomerButton.setEnabled(enableCustomerControls);
        if (SystemProperty.getInstance().formAutoCombosFromAdmin()) {
            this.createComboButtonDec.setEnabled(canMakeCombo);
            components.add(this.createComboButtonDec);
            this.breakComboButtonDec.setEnabled(canBreakCombo);
            components.add(this.breakComboButtonDec);
        }
        components.add(this.refundItemsDec);
        components.add(this.findItemButton);
        components.add(this.accountCommentsButton);
        if (WaiterMateCustomerDisplay.isActive()) {
            components.add(this.sendMessageButton);
        }
        if (!BarTabAccount.TYPE.equals((Object)acctType)) {
            components.add(this.reprintDec);
        }
        components.add(this.giftVouchersAdminDec);
        this.numPatronsButton.setEnabled(!DeterminePatrons.Item.equals((Object)SystemProperty.getInstance().getDeterminePatrons()));
        this.scrollModel.setItems(components);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        super.actionPerformed(e);
        if (e.getSource() == this.transferItemsButton) {
            this.transferItems.emit();
        } else if (e.getSource() == this.numPatronsButton) {
            this.changeNumPatrons.emit();
        } else if (e.getSource() == this.discountItemsButton) {
            this.discountItems.emit();
        } else if (e.getSource() == this.holdItemsButton) {
            this.holdItems.emit();
        } else if (e.getSource() != this.setCustomerButton) {
            if (e.getSource() == this.setDeliverableButton) {
                this.setDeliverable.emit();
            } else if (e.getSource() == this.removeCustomerButton) {
                this.removeCustomer.emit();
            } else if (e.getSource() == this.reprintButton) {
                this.reprintPrep.emit();
            } else if (e.getSource() == this.createComboButton) {
                this.createCombo.emit();
            } else if (e.getSource() == this.breakComboButton) {
                this.breakCombo.emit();
            } else if (e.getSource() == this.findItemButton) {
                this.findItem.emit((Object)Boolean.TRUE);
            } else if (e.getSource() == this.sendMessageButton) {
                this.sendMessage.emit();
            } else if (e.getSource() == this.accountCommentsButton) {
                this.accountComments.emit();
            }
        }
    }
}

