/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.ordering.accountadmin.discountitems;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import ordermate.database.finance.priceadjustment.InventoryPriceAdjustment;
import ordermate.database.finance.priceadjustment.PriceAdjustmentDirection;
import ordermate.database.finance.priceadjustment.PriceAdjustmentLevel;
import ordermate.database.finance.priceadjustment.SalesPriceAdjustment;
import ordermate.database.finance.priceadjustment.inventory.PriceAdjustmentType;
import ordermate.database.finance.priceadjustment.sales.SalesPriceAdjustmentI;
import ordermate.database.hardware.Terminal;
import ordermate.database.inventory.triggers.activation.TriggerActivationContext;
import ordermate.database.sales.ItemGroup;
import ordermate.database.sales.SalesCombo;
import ordermate.database.sales.SalesItem;
import ordermate.database.sales.SalesLineItem;
import ordermate.database.sales.SalesLineItemWrapper;
import ordermate.database.sales.SellableWrapperFactory;
import ordermate.internationalization.Internationalization;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import waitermate.LoginManager;
import waitermate.WaiterMate;
import waitermate.gui.screens.discount.DiscountGuiUtils;
import waitermate.gui.screens.ordering.accountadmin.discountitems.AdjustmentItemsPanel;
import waitermate.gui.screens.ordering.transferitems.selectitems.SelectItemsNav;
import waitermate.gui.screens.payment.selectadjustment.DiscountReasonPopup;
import waitermate.gui.screens.payment.selectadjustment.SelectPriceAdjustment;
import waitermate.guikit.AbstractScreen;
import waitermate.guikit.NavBar;
import waitermate.guikit.dialogs.Dialogs;

public class AdjustmentItems
extends AbstractScreen {
    public final Signal done = Signals.createSignal();
    public final Signal cancel = Signals.createSignal();
    public final Signal removeItemAdjustment = Signals.createSignal(SalesPriceAdjustmentI.class, (String)"removeItemAdjustment");
    private final AdjustmentItemsPanel gui;
    private final SelectItemsNav navBar;
    private Collection existingAdjustments;
    private final SelectPriceAdjustment selectDiscount;
    private ItemGroup theAccount;
    private Set items;
    private SellableWrapperFactory factory = new SellableWrapperFactory();

    public AdjustmentItems() {
        this.gui = new AdjustmentItemsPanel();
        this.gui.selectionChanged.connect((Object)this, "gotDiscountItemsSelected");
        this.gui.removeAdjustment.connect((Object)this, "gotRemoveAdjustment");
        this.navBar = new SelectItemsNav(false, true);
        this.navBar.cancel.connect((Object)this.cancel, "emit");
        this.navBar.ok.connect((Object)this, "gotOk");
        this.navBar.selectAll.connect((Object)this.gui, "selectAll");
        this.navBar.selectNone.connect((Object)this.gui, "selectNone");
        this.selectDiscount = new SelectPriceAdjustment(true);
        this.selectDiscount.back.connect((Object)this.cancel, "emit");
        this.selectDiscount.addAdjustment.connect((Object)this, "gotAdjustment");
        this.selectDiscount.removeAdjustment.connect((Object)this, "gotRemoveItemsAdjustment");
    }

    public void startDiscountAccount(ItemGroup discountAccount) {
        this.theAccount = discountAccount;
        this.gui.setCourse(0);
        this.gui.selectNone();
        List unpaidSalesItems = this.theAccount.getItemHelper().getUnpaidItems();
        this.gui.setItems(this.factory.getSellables(unpaidSalesItems));
        this.existingAdjustments = this.getExistingAdjustments(unpaidSalesItems);
        this.gui.setAdjustements(this.existingAdjustments);
        this.display();
    }

    void gotDiscountItemsSelected(Set selectedItems) {
        this.items = selectedItems;
    }

    void gotAdjustment(InventoryPriceAdjustment adjustment) {
        String reason = null;
        if (adjustment.hasValue() && adjustment.getDirection().equals((Object)PriceAdjustmentDirection.DISCOUNT) && adjustment.getType().equals((Object)PriceAdjustmentType.CUSTOM) && Terminal.getLocalHost().isPromptForCustomDiscountReason()) {
            if (DiscountReasonPopup.areReasonsAvailable()) {
                reason = DiscountReasonPopup.promptForReason();
                if (reason == null) {
                    this.done.emit();
                }
            } else {
                WaiterMate.LOG.warn("Cannot supply reason code for items discount as none are available.");
            }
        }
        ArrayList<SalesItem> salesItems = new ArrayList<SalesItem>(this.items.size());
        for (Object itemObject : this.items) {
            if (itemObject instanceof SalesLineItemWrapper) {
                SalesLineItemWrapper wapper = (SalesLineItemWrapper)itemObject;
                salesItems.addAll(wapper.getSalesItems());
                continue;
            }
            SalesLineItem lineItem = (SalesLineItem)itemObject;
            salesItems.addAll(lineItem.getSalesItems());
        }
        if (adjustment.getDirection().equals((Object)PriceAdjustmentDirection.DISCOUNT) && adjustment.getType().equals((Object)PriceAdjustmentType.NORMAL) && adjustment.isOpenPrice()) {
            DiscountGuiUtils.getNewPriceForOpenPriceDiscountForItemList(adjustment, salesItems);
        } else {
            SalesPriceAdjustment salesAdj = adjustment.createSalesPriceAdjustment(salesItems, LoginManager.getEventContext());
            salesAdj.setReason(reason, LoginManager.getEventContext());
        }
        this.done.emit();
    }

    void gotRemoveItemsAdjustment(SalesPriceAdjustmentI adjustment) {
        if (adjustment instanceof SalesPriceAdjustment) {
            SalesPriceAdjustment adj = (SalesPriceAdjustment)adjustment;
            for (SalesLineItemWrapper wrapper : this.items) {
                SalesLineItem item = wrapper.getSalesLineItem();
                item.removePriceAdjustment(adj, LoginManager.getEventContext());
            }
            this.done.emit();
        }
    }

    void gotRemoveAdjustment(SalesPriceAdjustmentI adjustment) {
        this.removeItemAdjustment.emit((Object)adjustment);
        this.done.emit();
    }

    void gotOk() {
        if (this.items.isEmpty()) {
            Dialogs.displayOkDialog((String)Internationalization.getLiteralFor((String)"TO_CONTINUE_YOU_MUST_SELECT_AN_ITEM"), (String)Internationalization.getLiteralFor((String)"NO_ITEMS_SELECTED"));
            return;
        }
        this.existingAdjustments = this.getExistingAdjustments(this.items);
        ArrayList allAdjustments = new ArrayList(this.existingAdjustments);
        allAdjustments.addAll(this.theAccount.getPriceAdjustments());
        boolean itemSetContainsCombos = false;
        Iterator it = this.items.iterator();
        while (it.hasNext()) {
            if (!(it.next() instanceof SalesCombo)) continue;
            itemSetContainsCombos = true;
            break;
        }
        this.selectDiscount.allowDollarValue(!itemSetContainsCombos);
        this.selectDiscount.start(this.existingAdjustments, allAdjustments, PriceAdjustmentDirection.DISCOUNT, PriceAdjustmentType.NORMAL, PriceAdjustmentLevel.ITEM_LEVEL, this.getTriggerActivationContext());
    }

    private Collection getExistingAdjustments(Collection itemList) {
        HashSet lineAdjustments = new HashSet();
        if (itemList != null) {
            for (Object nextItem : itemList) {
                SalesLineItem item = null;
                if (nextItem instanceof SalesLineItem) {
                    item = (SalesLineItem)nextItem;
                } else if (nextItem instanceof SalesItem) {
                    SalesItem salesItem = (SalesItem)nextItem;
                    item = salesItem.copy(LoginManager.getEventContext(), false);
                } else if (nextItem instanceof SalesLineItemWrapper) {
                    SalesLineItemWrapper salesWrapper = (SalesLineItemWrapper)nextItem;
                    item = salesWrapper.getSalesLineItem();
                }
                lineAdjustments.addAll(item.getPriceAdjustmentsNotIncludingPriceLevelAdjs());
            }
        }
        return lineAdjustments;
    }

    public JComponent getMainArea() {
        return this.gui;
    }

    public NavBar getNavBar() {
        return this.navBar;
    }

    private TriggerActivationContext getTriggerActivationContext() {
        return new TriggerActivationContext(LoginManager.getEventContext(), new Date(), (ItemGroup)this.theAccount.getAccount());
    }
}

