/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.ordering.accountitems;

import au.com.ordermate.configuration.Config;
import au.com.ordermate.gui.DummyGUIHandler;
import au.com.ordermate.gui.GraphPaperLayout;
import au.com.ordermate.gui.GuiHandler;
import au.com.ordermate.guicore.NameDecorator;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.units.SalesQuantity;
import au.com.ordermate.util.Price;
import au.com.ordermate.util.StringUtils;
import au.com.ordermate.util.connectivity.GoogleMapHelper;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingWorker;
import ordermate.OrderMate;
import ordermate.database.config.ExperimentalFeatureHelper;
import ordermate.database.finance.CreditLimited;
import ordermate.database.finance.CustomerPerSeatItemGroup;
import ordermate.database.finance.giftvoucher.GiftVoucherTransaction;
import ordermate.database.finance.transactions.CashTransaction;
import ordermate.database.finance.transactions.FinanceTransaction;
import ordermate.database.finance.transactions.FinanceTransactionContext;
import ordermate.database.finance.transactions.PreauthTransaction;
import ordermate.database.finance.transactions.PreauthTransactionHelper;
import ordermate.database.hardware.Terminal;
import ordermate.database.hardware.physical.CashDrawer;
import ordermate.database.integration.online.OnlineIntegrationConfig;
import ordermate.database.inventory.InventoryGroup;
import ordermate.database.inventory.InventoryItem;
import ordermate.database.inventory.InventoryItemUnit;
import ordermate.database.inventory.InventoryProfile;
import ordermate.database.inventory.PriceLevel;
import ordermate.database.inventory.combos.InventoryCombo;
import ordermate.database.inventory.triggers.activation.TriggerActivationContext;
import ordermate.database.misc.Course;
import ordermate.database.misc.SystemProperty;
import ordermate.database.misc.TerminalEventLog;
import ordermate.database.misc.enums.ItemBarcodeType;
import ordermate.database.sales.Account;
import ordermate.database.sales.AccountItemsHelper;
import ordermate.database.sales.AccountType;
import ordermate.database.sales.BarTabAccount;
import ordermate.database.sales.CourseHoldStrategyHelper;
import ordermate.database.sales.Customer;
import ordermate.database.sales.CustomerUpdateManager;
import ordermate.database.sales.Delivery;
import ordermate.database.sales.ItemGroup;
import ordermate.database.sales.OnlineAccount;
import ordermate.database.sales.PhoneAccount;
import ordermate.database.sales.SalesItem;
import ordermate.database.sales.SalesLineItem;
import ordermate.database.sales.SalesLineItemWrapper;
import ordermate.database.sales.Sellable;
import ordermate.database.sales.SellableWrapperFactory;
import ordermate.database.sales.TableAccount;
import ordermate.database.sales.TakeawayAccount;
import ordermate.database.sales.VoucherTransactionWrapper;
import ordermate.database.sales.customer.assignment.CustomerAssignmentContext;
import ordermate.database.sales.customer.assignment.CustomerAssignmentHelper;
import ordermate.database.sales.customer.assignment.CustomerAssignmentStrategy;
import ordermate.database.stock.StockUtilities;
import ordermate.database.tables.LogicalTable;
import ordermate.database.tables.LogicalTableState;
import ordermate.database.users.AllPermissions;
import ordermate.database.users.User;
import ordermate.gui.SaveAccount;
import ordermate.integration.loyalty.LoyaltyResyncTask;
import ordermate.internationalization.Internationalization;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import waitermate.LoginManager;
import waitermate.WaiterMate;
import waitermate.WaiterMateInputAdapter;
import waitermate.gui.WaitermateAccountGui;
import waitermate.gui.WaitermateGuiHandler;
import waitermate.gui.customerdisplay.WaiterMateCustomerDisplay;
import waitermate.gui.dialogs.AutoComboSelector;
import waitermate.gui.displayitems.SelectItemButtonRenderer;
import waitermate.gui.displayitems.accountitems.CourseItemsPanel;
import waitermate.gui.displayitems.accountitems.DefaultItemRenderer;
import waitermate.gui.displayitems.accountitems.SingleScreenItemRenderer;
import waitermate.gui.screens.ordering.VoucherTransactionReturner;
import waitermate.gui.screens.ordering.accountitems.AccountItemsNav;
import waitermate.gui.screens.ordering.accountitems.WaitermateUpsell;
import waitermate.gui.screens.ordering.additems.OrderedItemDetails;
import waitermate.gui.screens.ordering.additems.UpgradeCombo;
import waitermate.gui.screens.ordering.additems.selectitem.AbstractMenuItemSelectionPanel;
import waitermate.gui.screens.ordering.additems.selectitem.MultipleMenuItemSelectionPanel;
import waitermate.gui.screens.ordering.additems.selectitem.SimpleMenuItemSelectionPanel;
import waitermate.gui.screens.ordering.coupon.WaiterMateCoupons;
import waitermate.gui.screens.ordering.saveaccount.WaitermateSaveAccount;
import waitermate.gui.screens.ordering.seatadmin.SeatAdmin;
import waitermate.gui.screens.payment.transactions.CreditLimitPanel;
import waitermate.gui.screens.selectaccount.table.CoversHelper;
import waitermate.gui.screens.selectaccount.takeaway.bartabs.AssignBarTabToTable;
import waitermate.guikit.AbstractScreen;
import waitermate.guikit.NavBar;
import waitermate.guikit.ScreenResource;
import waitermate.guikit.dialogs.Dialogs;
import waitermate.guikit.showitem.ShowItemsUtils;
import waitermate.upsell.UpsellManager;

public class AccountItems
extends AbstractScreen {
    private static final Rectangle ITEMS_FULL_SCREEN = new Rectangle(0, 0, 100, 1);
    public final Signal<?, ?, ?, ?, ?> cancel = Signals.createSignal();
    public final Signal<?, ?, ?, ?, ?> ok = Signals.createSignal();
    public final Signal<Account, InventoryGroup, OrderedItemDetails, ?, ?> groupSelected = Signals.createSignal(Account.class, (String)"currentAccount", InventoryGroup.class, (String)"group", OrderedItemDetails.class, (String)"currentDetails");
    public final Signal<Account, InventoryItem, OrderedItemDetails, SalesQuantity, ?> newItemSelected = Signals.createSignal(Account.class, (String)"currentAccount", InventoryItem.class, (String)"newItem", OrderedItemDetails.class, (String)"newItemDetails", SalesQuantity.class, (String)"salesQty");
    public final Signal<Account, InventoryCombo, OrderedItemDetails, SalesQuantity, ?> newComboSelected = Signals.createSignal(Account.class, (String)"currentAccount", InventoryCombo.class, (String)"newCombo", OrderedItemDetails.class, (String)"itemDetails", SalesQuantity.class, (String)"salesQty");
    public final Signal<Account, InventoryItemUnit, OrderedItemDetails, SalesQuantity, ?> newItemUnitSelected = Signals.createSignal(Account.class, (String)"currentAccount", InventoryItemUnit.class, (String)"newItemUnit", OrderedItemDetails.class, (String)"comboDetails", SalesQuantity.class, (String)"salesQty");
    public final Signal<Account, OrderedItemDetails, ?, ?, ?> existingItemChanged = Signals.createSignal(Account.class, (String)"currentAccount", OrderedItemDetails.class, (String)"newItemDetails");
    private final Signal upgradeFinished = Signals.createSignal();
    public final Signal<Sellable, Account, ?, ?, ?> sellableSelected = Signals.createSignal(Sellable.class, (String)"item", Account.class, (String)"currentAccount");
    public final Signal<Account, ?, ?, ?, ?> paySelected = Signals.createSignal(Account.class, (String)"payAccount");
    public final Signal<Account, ?, ?, ?, ?> adminSelected = Signals.createSignal(Account.class, (String)"currentAccount");
    private Signal autoComboDone = Signals.createSignal();
    public Signal<Account, ?, ?, ?, ?> accountSelected = Signals.createSignal(Account.class, (String)"theAccount");
    private Signal seatAdminDone = Signals.createSignal();
    private final JComponent gui;
    private final AccountItemsNav navPanel;
    private CourseItemsPanel items;
    private AbstractMenuItemSelectionPanel groups;
    private int menuGroupWidth;
    private JPanel centerPanel;
    private DefaultItemRenderer itemRenderer;
    private Account currentAccount;
    private WaitermateUpsell upsell;
    private WaiterMateCoupons coupons;
    private SeatAdmin seatAdmin;
    private CustomerAssignmentHelper customerAssignmentHelper;
    private Customer oldCustomer;
    private AssignBarTabToTable assignBarTab;
    private SellableWrapperFactory sellableFactory = new SellableWrapperFactory();

    public AccountItems() {
        this.autoComboDone.connect((Object)this, "gotMakeComboDone");
        this.seatAdminDone.connect((Object)this, "gotSeatAdminDone");
        this.gui = new JPanel((LayoutManager)new GraphPaperLayout(new Dimension(100, 1)));
        this.rebuild();
        this.navPanel = new AccountItemsNav();
        this.navPanel.save.connect((Object)this, "gotOk");
        this.navPanel.back.connect((Object)this, "gotCancel");
        this.navPanel.cancel.connect((Object)this, "gotCancel");
        this.navPanel.pay.connect((Object)this, "gotPay");
        this.navPanel.config.connect((Object)this, "gotAdmin");
        this.navPanel.seatAdminSignal.connect((Object)this, "gotSeatAdmin");
        this.navPanel.print.connect((Object)this, "gotPrintBill");
        this.navPanel.showItems.connect((Object)this, "gotShowItems");
        this.navPanel.showPhoneMenu.connect((Object)this, "showPhoneMenu");
        this.navPanel.showDeliveryMenu.connect((Object)this, "showDeliveryMenu");
        this.navPanel.usePriceLevel.connect((Object)this, "usePriceLevel");
        this.navPanel.useCheapestPriceLevels.connect((Object)this, "useCheapestPriceLevel");
        this.navPanel.creditLimit.connect((Object)this, "gotCreditLimit");
        this.navPanel.makeCombo.connect((Object)this, "gotMakeCombo");
        this.navPanel.breakCombo.connect((Object)this, "gotBreakCombo");
        this.navPanel.printOrder.connect((Object)this, "gotPrintOrder");
        this.navPanel.customerLocation.connect((Object)this, "gotCustomerLocation");
        this.navPanel.renameTab.connect((Object)this, "gotRenameBartab");
        this.navPanel.holdAccount.connect((Object)this, "gotHoldAccount");
        this.navPanel.orderInfoSignal.connect((Object)this, "gotOrderInfo");
        this.navPanel.tableStateChanged.connect((Object)this, "gotTableStateChanged");
        this.navPanel.assignBarTabToTable.connect((Object)this, "gotAssignBarTabToTable");
        WaiterMateInputAdapter.getInstance().customerInput.connect((Object)this, "gotCustomerSwipe");
        WaiterMateInputAdapter.getInstance().barcodeInput.connect((Object)this, "gotBarcode");
        WaiterMateInputAdapter.getInstance().barcodedItemScanned.connect((Object)this, "gotBarcodedItemScanned");
        WaiterMateInputAdapter.getInstance().couponScanned.connect((Object)this, "gotCouponScanned");
        CustomerUpdateManager.getInstance().customerUpdated.connect((Object)this, "gotUpdateCustomer");
        this.upgradeFinished.connect((Object)this, "selectItems");
        this.customerAssignmentHelper = new CustomerAssignmentHelper();
    }

    public void rebuild() {
        boolean singleScreen;
        if (this.items != null) {
            this.items.seatTabChanged.disconnect((Object)this);
            this.items.holdCourseButtonSignal.disconnect((Object)this);
        }
        this.items = (singleScreen = Terminal.getLocalHost().getSingleScreenOrdering()) ? new CourseItemsPanel(new SingleScreenItemRenderer(true)) : new CourseItemsPanel();
        this.items.holdCourseButtonSignal.connect((Object)this, "gotHoldCourseButtonClicked");
        this.items.seatTabChanged.connect((Object)this, "gotSeatTabChanged");
        this.items.setDefaultMessage(Internationalization.getLiteralFor((String)"ACCOUNT_HAS_NO_ITEMS"));
        if (this.itemRenderer != null) {
            this.itemRenderer = (DefaultItemRenderer)this.items.getRenderer();
            this.itemRenderer.item.disconnect((Object)this);
            this.itemRenderer.quantity.disconnect((Object)this);
            this.itemRenderer.delete.disconnect((Object)this);
            this.itemRenderer.upgrade.disconnect((Object)this);
        }
        DefaultItemRenderer renderer = null;
        renderer = singleScreen ? new SingleScreenItemRenderer(true) : new DefaultItemRenderer(true);
        this.items.setRenderer(renderer);
        this.itemRenderer = (DefaultItemRenderer)this.items.getRenderer();
        this.itemRenderer.item.connect((Object)this, "gotItem");
        this.itemRenderer.quantity.connect((Object)this, "gotQuantity");
        this.itemRenderer.delete.connect((Object)this, "gotDelete");
        this.itemRenderer.upgrade.connect((Object)this, "gotUpgrade");
        if (this.groups != null) {
            this.groups.itemSelected.disconnect((Object)this);
            this.groups.comboSelected.disconnect((Object)this);
            if (this.groups.groupSelected != null && this.groups.groupSelected.isConnected((Object)this)) {
                this.groups.groupSelected.disconnect((Object)this);
            }
        }
        this.gui.removeAll();
        boolean showItemsQuantity = Terminal.getLocalHost().isShowQuantity();
        SelectItemButtonRenderer itemsRenderer = new SelectItemButtonRenderer(showItemsQuantity);
        if (singleScreen) {
            boolean tabbed = Terminal.getLocalHost().isTabbedMenuOrdering();
            this.groups = new MultipleMenuItemSelectionPanel(itemsRenderer, tabbed);
            this.menuGroupWidth = Terminal.getLocalHost().getQuickSaleMenuWidth();
            this.gui.add((Component)new NameDecorator((JComponent)this.groups, "ItemScreen"), new Rectangle(0, 0, this.menuGroupWidth, 1));
        } else {
            this.groups = new SimpleMenuItemSelectionPanel(1, 10, itemsRenderer);
            this.menuGroupWidth = 25;
            this.gui.add((Component)new NameDecorator((JComponent)this.groups, "menuGroups"), new Rectangle(0, 0, this.menuGroupWidth, 1));
            this.groups.groupSelected.connect((Object)this, "gotGroup");
        }
        this.groups.setNumKeypadVisible(singleScreen && Terminal.getLocalHost().isShowQuantityKeypad());
        this.groups.itemSelected.connect((Object)this, "gotNewItem");
        this.groups.comboSelected.connect((Object)this, "gotNewCombo");
        this.centerPanel = new JPanel(new BorderLayout());
        this.centerPanel.add((Component)this.items, "Center");
        this.gui.add((Component)this.centerPanel, new Rectangle(this.menuGroupWidth, 0, 100 - this.menuGroupWidth, 1));
    }

    public void connectToUpsell() {
        if (UpsellManager.getInstance() != null) {
            this.upsell = new WaitermateUpsell();
            this.ok.connect((Object)this.upsell, "gotNoAccount");
            this.cancel.connect((Object)this.upsell, "gotNoAccount");
            this.upsell.upgrade.connect((Object)this, "gotUpgrade");
            this.upsell.item.connect((Object)this, "gotNewItem");
            this.upsell.section.connect((Object)this, "gotGroup");
            this.upsell.component.connect((Object)this, "showUpsellComponent");
            UpsellManager.getInstance().upsellSuggested.connect((Object)this.upsell, "gotUpsell");
        }
    }

    public void gotHoldCourseButtonClicked(Boolean pressed) {
        if (!(this.currentAccount instanceof TableAccount)) {
            return;
        }
        TableAccount tableAccount = (TableAccount)this.currentAccount;
        tableAccount.setCoursePrintOnHold(this.items.getCurrentCourse(), pressed.booleanValue());
    }

    public void startSelectItems(Account newAccount) {
        this.currentAccount = newAccount;
        this.coupons = new WaiterMateCoupons(this.currentAccount);
        this.items.setCourse(this.getDefaultCourse());
        this.items.setSeat(0);
        this.updateCourseHoldButton();
        this.groups.showRootGroup(new TriggerActivationContext(LoginManager.getEventContext(), (ItemGroup)this.currentAccount), this.currentAccount.getOrderedItems(), Collections.EMPTY_LIST);
        this.selectItems();
        this.showLastPage();
        WaitermateAccountGui.getInstance().accountChanged(this.currentAccount);
    }

    private void updateCourseHoldButton() {
        if (!(this.currentAccount instanceof TableAccount)) {
            this.items.setCourseHoldButtonVisible(false);
            return;
        }
        TableAccount tableAccount = (TableAccount)this.currentAccount;
        int currentCourse = this.items.getCurrentCourse();
        if (CourseHoldStrategyHelper.isCourseHoldEnabled((TableAccount)tableAccount, (int)currentCourse)) {
            this.items.setCourseHoldButtonVisible(true);
            this.items.updateCourseHoldButton(tableAccount.isCoursePrintOnHold(currentCourse), tableAccount.getSalesAccountCourse(currentCourse).getLastPrintedTime());
        } else {
            this.items.setCourseHoldButtonVisible(false);
        }
    }

    public void setExtraComponent(JComponent component, String constraint) {
        if ("Center".equals(constraint) || constraint == null) {
            throw new IllegalArgumentException("Cannot replace the central component");
        }
        this.centerPanel.add((Component)component, constraint);
        this.centerPanel.invalidate();
        this.gui.invalidate();
    }

    private int getDefaultCourse() {
        Course defaultCourse = (Course)PersistenceManager.getObject(Course.class, (String)Query.select(Course.class).equalsParam(Course.Properties.DEFAULT_COURSE).toString(), (Object[])new Object[]{1});
        int result = 0;
        if (defaultCourse != null) {
            List allCourses = PersistenceManager.getObjectList(Course.class, (String)Query.select(Course.class).orderBy(Course.Properties.SEQUENCE).toString());
            for (Course course : allCourses) {
                if (course.getSequence() == defaultCourse.getSequence()) {
                    return result;
                }
                ++result;
            }
        }
        return result;
    }

    public Account getAccount() {
        return this.currentAccount;
    }

    public void selectItems() {
        if (Terminal.getLocalHost().getSeatNums() && this.currentAccount.usesSeatNums()) {
            this.items.setNumSeats(CoversHelper.getValueForSeats((ItemGroup)this.currentAccount));
        } else {
            this.items.setNumSeats(0);
        }
        this.enableHoldButton();
        this.enableOrderInfoButton();
        if (this.currentAccount.allowsOrderingItems()) {
            this.gui.remove(this.centerPanel);
            this.gui.add((Component)this.centerPanel, new Rectangle(this.menuGroupWidth, 0, 100 - this.menuGroupWidth, 1));
            this.groups.setVisible(true);
            this.navPanel.setPrintOrderVisible(true);
        } else {
            this.groups.setVisible(false);
            this.gui.remove(this.centerPanel);
            this.gui.add((Component)this.centerPanel, ITEMS_FULL_SCREEN);
            this.navPanel.setPrintOrderVisible(false);
        }
        if (this.currentAccount instanceof TableAccount) {
            this.navPanel.setNumPatrons(((TableAccount)this.currentAccount).getNumPatrons());
            this.navPanel.setAccountName(((TableAccount)this.currentAccount).getLabel());
            this.navPanel.showTableStatesButton(this.currentAccount.isPersistent());
            this.navPanel.showCoursesLinkedTableStates(true);
            this.navPanel.setSeatAdminEnabled(SystemProperty.getInstance().isCustomerAssignmentPerSeat());
            this.navPanel.setMakeCombosVisible(SystemProperty.getInstance().isCustomerAssignmentPerSeat() || Terminal.getLocalHost().isShowMakeComboInNav());
        } else {
            this.navPanel.setNumPatrons(0);
            if (this.currentAccount instanceof BarTabAccount && ((BarTabAccount)this.currentAccount).getLogicalTable() != null) {
                this.navPanel.setAccountName("Table " + ((BarTabAccount)this.currentAccount).getLogicalTable().getGroupAndLabel());
            } else if (this.currentAccount instanceof OnlineAccount && ((OnlineAccount)this.currentAccount).getLogicalTable() != null) {
                this.navPanel.setAccountName("Table " + ((OnlineAccount)this.currentAccount).getLogicalTable().getGroupAndLabel());
            } else {
                this.navPanel.setAccountName(null);
            }
            this.navPanel.showTableStatesButton(this.currentAccount.isPersistent() && this.currentAccount instanceof BarTabAccount && ((BarTabAccount)this.currentAccount).getLogicalTable() != null);
            if (this.currentAccount instanceof BarTabAccount) {
                this.navPanel.showCoursesLinkedTableStates(false);
            }
            this.navPanel.setSeatAdminEnabled(false);
            this.navPanel.setMakeCombosVisible(Terminal.getLocalHost().isShowMakeComboInNav());
        }
        boolean isBartab = AccountType.barTabType.equals((Object)this.currentAccount.getAccountType());
        this.navPanel.enableRenameBartabLabel(isBartab);
        this.navPanel.enableAssignBarTabToTableButton(isBartab && ((BarTabAccount)this.currentAccount).getLogicalTable() == null);
        this.navPanel.setupPayButton(LoginManager.getInstance().getUser(), this.currentAccount.isOpen());
        this.navPanel.enableAccountAdminButton(this.currentAccount.isOpen());
        this.navPanel.setDeliveryButtonsVisible(false);
        if (this.currentAccount instanceof PhoneAccount) {
            PhoneAccount account = (PhoneAccount)this.currentAccount;
            Terminal localhost = Terminal.getLocalHost();
            InventoryProfile delivery = InventoryProfile.getProfile((AccountType)PhoneAccount.DELIVERY_TYPE, (Terminal)localhost);
            if (localhost.hasDeliveryMode() && delivery != null && (!(this.currentAccount instanceof OnlineAccount) || ((OnlineAccount)this.currentAccount).getLogicalTable() == null)) {
                this.navPanel.setDeliveryButtonsVisible(true);
                if (account.isDeliverable()) {
                    this.showDeliveryMenu();
                } else {
                    this.showPhoneMenu();
                }
            }
        }
        if (this.currentAccount instanceof BarTabAccount) {
            this.navPanel.setCreditLimitButtonsVisible(true);
            this.navPanel.setMakeCombosVisible(false);
        } else {
            this.navPanel.setMakeCombosVisible(Terminal.getLocalHost().isShowMakeComboInNav());
            this.navPanel.setCreditLimitButtonsVisible(false);
        }
        AccountType type = this.currentAccount.getAccountType();
        this.navPanel.showCustomerLocationButton(type.equals((Object)AccountType.deliveryType) || type.equals((Object)AccountType.phoneType) || AccountType.isOnline((Account)this.currentAccount));
        this.display();
        this.itemsUpdatedAndShow();
        this.gotCustomer(this.getCurrentItemGroup().getCustomer(), false);
    }

    private void enableOrderInfoButton() {
        Terminal localhost = Terminal.getLocalHost();
        boolean showOrderInfo = false;
        if (AccountType.takeawayType.equals((Object)this.currentAccount.getAccountType())) {
            showOrderInfo = ((TakeawayAccount)this.currentAccount).isQuickSaleOriginated() ? localhost.showQuickOrderInfoButton() : localhost.isTakeawayStandName() || localhost.isTakeawayStandNum();
        } else if (AccountType.quickSaleDineInType.equals((Object)this.currentAccount.getAccountType())) {
            showOrderInfo = localhost.showQuickOrderInfoButton();
        }
        this.navPanel.setOrderInfoVisible(showOrderInfo);
    }

    private void enableHoldButton() {
        boolean buttonVisible = this.currentAccount.allowsOrderingItems() && this.currentAccount.allowsHold(Terminal.getLocalHost());
        this.navPanel.setHoldButtonVisible(buttonVisible);
        this.navPanel.setHoldButtonSelected(this.currentAccount.isOnHold());
    }

    private void enablifyMakeCombos() {
        if (Terminal.getLocalHost().isShowMakeComboInNav()) {
            final AutoComboSelector selector = AutoComboSelector.getInstance();
            new SwingWorker(){

                protected Object doInBackground() throws Exception {
                    selector.setContext(AccountItems.this.getCurrentItemGroup(), AccountItems.this.getCurrentItems(AccountItems.this.items.getCurrentSeat()), LoginManager.getEventContext());
                    return null;
                }

                @Override
                protected void done() {
                    AccountItems.this.navPanel.setMakeCombosEnabled(selector.canMakeCombos());
                    AccountItems.this.navPanel.setBreakCombosEnabled(selector.canBreakCombos());
                }
            }.execute();
        }
    }

    private boolean isPerSeatTable() {
        return SystemProperty.getInstance().isCustomerAssignmentPerSeat() && this.getAccount() instanceof TableAccount;
    }

    private ItemGroup getCurrentItemGroup() {
        Account itemGroup = this.getAccount();
        if (this.isPerSeatTable()) {
            TableAccount theTableAccount = (TableAccount)this.getAccount();
            itemGroup = new CustomerPerSeatItemGroup(theTableAccount, this.getCurrentCustomer(), new int[]{this.items.getCurrentSeat()});
        }
        return itemGroup;
    }

    private List<List<? extends SalesLineItem>> getCurrentItems(int currentSeat) {
        ArrayList<List<? extends SalesLineItem>> bundles = new ArrayList<List<? extends SalesLineItem>>();
        if (this.isPerSeatTable()) {
            HashMap itemsMap = new HashMap();
            Customer currentCustomer = this.getCurrentCustomer();
            for (SalesLineItem anItem : this.getAccount().getItemHelper().getUnpaidItems()) {
                int itemSeat = anItem.getSeat();
                if (currentCustomer != null) {
                    Customer itemCustomer = anItem.getCustomer();
                    if (!currentCustomer.equals((Object)itemCustomer)) continue;
                    if (currentSeat == itemSeat) {
                        if (!itemsMap.containsKey(itemCustomer)) {
                            itemsMap.put(itemCustomer, new ArrayList());
                        }
                        ((List)itemsMap.get(itemCustomer)).add(anItem);
                        continue;
                    }
                    if (!itemsMap.containsKey(itemSeat)) {
                        itemsMap.put(itemSeat, new ArrayList());
                    }
                    ((List)itemsMap.get(itemSeat)).add(anItem);
                    continue;
                }
                if (itemSeat != currentSeat) continue;
                if (!itemsMap.containsKey(itemSeat)) {
                    itemsMap.put(itemSeat, new ArrayList());
                }
                ((List)itemsMap.get(itemSeat)).add(anItem);
            }
            for (List itemList : itemsMap.values()) {
                bundles.add(itemList);
            }
        } else {
            bundles.add(this.getAccount().getItemHelper().getUnpaidItems());
        }
        return bundles;
    }

    private void enablifyPrintOrder() {
        if (Terminal.getLocalHost().isGeneralManualPrintPrep()) {
            boolean hasUnprintedItems = false;
            for (SalesLineItem item : this.currentAccount.getAllItems()) {
                if (item.isPrinted()) continue;
                hasUnprintedItems = true;
                break;
            }
            this.navPanel.setPrintOrderEnabled(hasUnprintedItems);
        }
    }

    public void gotMakeCombo() {
        AutoComboSelector selector = AutoComboSelector.getInstance();
        selector.configureSignal(this.autoComboDone);
        selector.setContext(this.getCurrentItemGroup(), this.getCurrentItems(this.items.getCurrentSeat()), LoginManager.getEventContext());
        selector.startMake();
    }

    public void gotMakeComboDone() {
        this.itemsUpdatedAndShow();
    }

    public void gotBreakCombo() {
        AutoComboSelector selector = AutoComboSelector.getInstance();
        selector.configureSignal(this.autoComboDone);
        selector.setContext(this.getCurrentItemGroup(), this.getCurrentItems(this.items.getCurrentSeat()), LoginManager.getEventContext());
        selector.startBreak();
    }

    public void showLastPage() {
        this.items.displayLastPage();
    }

    void gotCancel() {
        if (this.currentAccount.hasUnsavedFinanceTransaction()) {
            Dialogs.displayOkDialog((String)(Internationalization.getLiteralFor((String)"CANNOT_CANCEL_AN_ACCOUNT_WITH_NEW_TRANSACTIONS") + Internationalization.getLiteralFor((String)"REMOVE_THE_NEW_TRANSACTIONS_FIRST")), (String)Internationalization.getLiteralFor((String)"CANCEL_NOT_ALLOWED"));
            return;
        }
        if (!this.currentAccount.getItems().isEmpty() || this.currentAccount.isPersistent()) {
            boolean exit = Dialogs.displayChoiceDialog((String)("         " + Internationalization.getLiteralFor((String)"DO_YOU_REALLY_WANT_TO_CANCEL") + "        "), (String)Internationalization.getLiteralFor((String)"CANCEL"), (String)Internationalization.getLiteralFor((String)"YES"), (String)Internationalization.getLiteralFor((String)"NO"), (boolean)false);
            if (exit) {
                this.cancelAccount();
            }
        } else {
            this.cancelAccount();
        }
    }

    private void cancelAccount() {
        this.currentAccount.saveRemovedTransactions();
        this.cancel.emit();
        this.currentAccount = null;
    }

    void gotOk() {
        try {
            if (this.currentAccount.isOpen() && StockUtilities.checkAccountOversell((Account)this.currentAccount)) {
                CashDrawer cashdrawer = Terminal.getLocalHost().getAssignedCashDrawer(LoginManager.getInstance().getUser());
                if (this.currentAccount.getFinanceTransactions().isEmpty() && this.currentAccount.getDue().equals((Object)Price.ZERO_DOLLAR) && cashdrawer != null) {
                    CashTransaction cashTransaction = new CashTransaction(new FinanceTransactionContext(LoginManager.getEventContext(), cashdrawer), Price.ZERO_DOLLAR, Price.ZERO_DOLLAR, Price.ZERO_DOLLAR);
                    this.currentAccount.addFinanceTransaction((FinanceTransaction)cashTransaction);
                }
                this.saveOpenAccount(this.currentAccount);
            } else {
                this.saveClosedAccount(this.currentAccount);
            }
        }
        catch (IllegalStateException ise) {
            WaiterMate.LOG.error("SaveOpenAccount caused Exception :: Cause :: Account is not locked. User :: " + LoginManager.getInstance().getUser() + " " + ise.getMessage(), (Throwable)ise);
            WaiterMate.LOG.error("IllegalStateException :: This is a point of interest :: " + ise.getMessage(), (Throwable)ise);
            Dialogs.displayOkDialog((String)"The account has been unlocked by another user, all changes could not be saved", (String)"Error");
            LoginManager.getInstance().logout();
            ScreenResource.getTarget().setVisible(true);
            WaiterMate.guiSetupTask.getLoginState().display();
        }
        this.setLastPrintUpdatedTime();
    }

    private void setLastPrintUpdatedTime() {
        if (!(this.currentAccount instanceof TableAccount)) {
            return;
        }
        TableAccount tableAccount = (TableAccount)this.currentAccount;
        for (Course course : Course.getCourses()) {
            if (tableAccount.isCoursePrintOnHold(course)) continue;
            tableAccount.setLastPrintedTime(course.getCourseIndex(), new Date());
        }
    }

    private void saveClosedAccount(Account account) {
        boolean commitRefundChanges = false;
        if (account.hasItemsChanged()) {
            commitRefundChanges = Dialogs.displayChoiceDialog((String)("<html><h1>" + Internationalization.getLiteralFor((String)"REFUND") + "</h1><p>" + Internationalization.getLiteralFor((String)"MESSAGE_WARNING_ACCOUNT_DETAILS_SAVED_PART1") + "<br>" + Internationalization.getLiteralFor((String)"MESSAGE_WARNING_ACCOUNT_DETAILS_SAVED_PART2") + "<br>" + Internationalization.getLiteralFor((String)"MESSAGE_WARNING_ACCOUNT_DETAILS_SAVED_PART3") + "<br>" + Internationalization.getLiteralFor((String)"MESSAGE_WARNING_ACCOUNT_DETAILS_SAVED_PART4") + "</p>"), (String)Internationalization.getLiteralFor((String)"REFUND"), (boolean)false);
        }
        if (commitRefundChanges) {
            this.paySelected.emit((Object)account);
        } else {
            this.checkClosedAccount(account);
            this.ok.emit();
        }
    }

    private void checkClosedAccount(Account account) {
        if (account instanceof OnlineAccount && account.getEta() == null && WaitermateSaveAccount.getInstance().addInfo(account)) {
            WaitermateSaveAccount.getInstance().saveAccount(account, LoginManager.getEventContext());
        }
        if (this.checkShouldPrintPaidOnlineAccount(account)) {
            WaitermateSaveAccount.getInstance().printClosingReceipts(account);
            WaitermateSaveAccount.getInstance().printPrep(account);
        }
    }

    private boolean checkShouldPrintPaidOnlineAccount(Account account) {
        return account instanceof OnlineAccount && !account.isOnHold() && account.getEta() != null && account.hasPrintableItems() && OnlineIntegrationConfig.PrintingStrategy.ON_ETA_SET.equals((Object)OnlineIntegrationConfig.getConfigFor((String)((OnlineAccount)account).getSource()).getPrintingStrategy());
    }

    private boolean isTicketDataEntryRequired(Account account) {
        Terminal terminal = LoginManager.getEventContext().getTerminal();
        return terminal.isAutoPromptTA() && account.requiresTicketDataName(terminal) || account.requiresTicketDataStandNum(terminal);
    }

    private boolean saveOpenAccount(Account account) {
        if (WaitermateSaveAccount.getInstance().addInfo(account)) {
            if (this.isTicketDataEntryRequired(account) && !account.hasTicketData()) {
                WaitermateSaveAccount.getInstance().getTicketData(account);
            }
            if (!WaitermateSaveAccount.getInstance().shouldKeepOpen(account) && !account.isOnHold()) {
                WaitermateSaveAccount.getInstance().closeAccount(account, false, true, LoginManager.getEventContext());
            }
            if (this.currentAccount instanceof OnlineAccount && ((OnlineAccount)this.currentAccount).getLogicalTable() != null) {
                WaitermateSaveAccount.getInstance().transferOnlineAccountToTable((OnlineAccount)this.currentAccount);
                WaitermateSaveAccount.getInstance().closeAccount(account, false, false, LoginManager.getEventContext());
                WaitermateSaveAccount.getInstance().saveAccount(account, LoginManager.getEventContext());
            } else {
                if (this.currentAccount instanceof TableAccount) {
                    WaitermateSaveAccount.getInstance().printCourseDockets();
                }
                WaitermateSaveAccount.getInstance().saveAccount(account, LoginManager.getEventContext());
                if (!account.isOnHold()) {
                    WaitermateSaveAccount.getInstance().printClosingReceipts(account);
                    WaitermateSaveAccount.getInstance().printPrep(account);
                }
            }
            this.ok.emit();
            return true;
        }
        return false;
    }

    void gotGroup(InventoryGroup theGroup) {
        this.groupSelected.emit((Object)this.currentAccount, (Object)theGroup, (Object)new OrderedItemDetails(this.items.getCurrentCourse(), this.items.getCurrentSeat(), null));
    }

    public void gotNewItem(InventoryItem selected) {
        this.gotNewItem(this.currentAccount, selected);
    }

    public void gotNewItem(Account account, InventoryItem itemSelected) {
        this.currentAccount = account;
        this.newItemSelected.emit((Object)this.currentAccount, (Object)itemSelected, (Object)new OrderedItemDetails(this.items.getCurrentCourse(), this.items.getCurrentSeat(), null), (Object)this.groups.getQuantity());
    }

    public void gotNewCombo(InventoryCombo selected) {
        this.newComboSelected.emit((Object)this.currentAccount, (Object)selected, (Object)new OrderedItemDetails(this.items.getCurrentCourse(), this.items.getCurrentSeat(), null), (Object)this.groups.getQuantity());
    }

    void gotItem(Sellable theItem) {
        this.itemsUpdatedAndShow();
        this.sellableSelected.emit((Object)theItem, (Object)this.currentAccount);
    }

    public void gotEditItemDone() {
        this.selectItems();
        this.existingItemChanged.emit((Object)this.currentAccount, (Object)new OrderedItemDetails(this.items.getCurrentCourse(), this.items.getCurrentSeat(), null));
        this.itemsUpdatedAndShow();
    }

    private void itemsUpdated() {
        boolean hasAnyVoucherTxns;
        this.navPanel.setTotal(this.currentAccount.getTotal());
        boolean bl = hasAnyVoucherTxns = !this.currentAccount.getActiveVoucherTxns().isEmpty();
        if (this.currentAccount.isPersistent() || !this.currentAccount.getItems().isEmpty() || this.currentAccount.isSaveEmptyAllowed() || hasAnyVoucherTxns) {
            this.navPanel.setSaveButtonEnabled(true);
        } else {
            this.navPanel.setSaveButtonEnabled(false);
        }
        this.priceLevelCheckForChange();
        this.itemRenderer.setTriggerEventContext(new TriggerActivationContext(LoginManager.getEventContext(), this.getCurrentItemGroup()));
        this.items.setItems(this.sellableFactory.getSellables((ItemGroup)this.currentAccount));
        if (TableAccount.TYPE.equals((Object)this.currentAccount.getAccountType())) {
            this.items.setCurrentCourse(((TableAccount)this.currentAccount).getCurrentCourse());
        }
        new SwingWorker(){

            public Object doInBackground() {
                ArrayList<Price> prices = new ArrayList<Price>();
                if (AccountItems.this.currentAccount.isPersistent()) {
                    PreauthTransaction txn = (PreauthTransaction)PersistenceManager.getObject(PreauthTransaction.class, (String)PreauthTransaction.getExisting((Account)AccountItems.this.currentAccount).toString());
                    prices.add(txn != null ? PreauthTransactionHelper.getInstance().getTotalPreAuth(txn) : null);
                } else {
                    prices.add(null);
                }
                if (AccountItems.this.currentAccount instanceof CreditLimited) {
                    prices.add(((CreditLimited)AccountItems.this.currentAccount).getCreditLimit());
                } else {
                    prices.add(null);
                }
                prices.add(AccountItems.this.currentAccount.getTotal());
                return prices;
            }

            @Override
            public void done() {
                try {
                    List prices = (List)this.get();
                    AccountItems.this.navPanel.setPreauthAndCredit((Price)prices.get(0), (Price)prices.get(1));
                    AccountItems.this.navPanel.setTotal((Price)prices.get(2));
                }
                catch (ExecutionException ex) {
                    WaiterMate.LOG.error("Could not get account total", (Throwable)ex);
                }
                catch (InterruptedException ie) {
                    WaiterMate.LOG.warn("Interrupted whilst getting account total", (Throwable)ie);
                }
            }
        }.execute();
        this.enablifyMakeCombos();
        this.enablifyPrintOrder();
        if (WaiterMateCustomerDisplay.isActive()) {
            WaiterMateCustomerDisplay.getInstance().accountChanged(this.currentAccount);
        }
        if (this.upsell != null) {
            this.upsell.gotAccountChanged(this.currentAccount);
        }
    }

    private void itemsUpdatedAndShow() {
        this.refreshGroups();
        this.itemsUpdated();
    }

    public void refreshGroups() {
        if (this.currentAccount.allowsOrderingItems()) {
            TriggerActivationContext context = new TriggerActivationContext(LoginManager.getEventContext(), new Date(), this.getCurrentItemGroup());
            if (this.groups.getInventoryGroup() != null) {
                this.groups.showGroup(context, this.groups.getInventoryGroup(), this.currentAccount.getItems(), Collections.EMPTY_LIST);
            } else {
                this.groups.showRootGroup(context, this.currentAccount.getItems(), null);
            }
        }
    }

    private void priceLevelCheckForChange() {
        User loggedInUser = LoginManager.getInstance().getUser();
        if (PriceLevel.getAllPriceLevels().size() > 1 && loggedInUser != null) {
            boolean onlyActive = !loggedInUser.hasPermission(AllPermissions.USE_INACTIVE_PRICE_LEVEL);
            Set priceLevelSet = this.currentAccount.getPriceAdjHelper().getPossiblePriceLevels(onlyActive, LoginManager.getEventContext());
            this.navPanel.setPossiblePriceLevels(priceLevelSet, this.currentAccount);
        }
    }

    void gotQuantity(Sellable theItem) {
        if (theItem.isQuantifiable()) {
            SalesQuantity newQuantity = theItem.getQuantity().lessThan(0L) ? theItem.getQuantity().subtract(SalesQuantity.ONE) : theItem.getQuantity().add(SalesQuantity.ONE);
            if (theItem instanceof SalesLineItemWrapper) {
                SalesLineItem salesItem = (SalesLineItem)theItem.getSellingObject();
                boolean allowQuantityEdit = StockUtilities.allowQuantityEdit((Account)this.currentAccount, new ArrayList(), (SalesLineItem)salesItem, (SalesQuantity)newQuantity, (User)LoginManager.getInstance().getUser());
                if (allowQuantityEdit && this.currentAccount instanceof CreditLimited && ((CreditLimited)this.currentAccount).exceedsCreditLimit(salesItem.getPricePerItem())) {
                    boolean bl = allowQuantityEdit = allowQuantityEdit && CreditLimitPanel.doCreditLimitDialog((CreditLimited)this.currentAccount, salesItem.getPricePerItem(), this.currentAccount.getLabel(), true);
                }
                if (allowQuantityEdit) {
                    salesItem.setQuantity(newQuantity, LoginManager.getEventContext());
                }
            }
            this.existingItemChanged.emit((Object)this.currentAccount, (Object)new OrderedItemDetails(theItem.getCourse(), theItem.getSeat(), null));
        }
        this.itemsUpdatedAndShow();
    }

    private void logDeletedItems(Sellable theItem) {
        try {
            TerminalEventLog.logDeletedItems((User)LoginManager.getInstance().getUser(), (Terminal)LoginManager.getEventContext().getTerminal(), (ItemGroup)this.getAccount(), (Collection)theItem.getSalesItems());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            OrderMate.LOG.info("Exception during logDeleteItems " + ex.getMessage(), (Throwable)ex);
        }
    }

    void gotDelete(Sellable theItem) {
        this.logDeletedItems(theItem);
        if (theItem.hasFinanceTransactions()) {
            if (theItem instanceof SalesLineItemWrapper) {
                this.currentAccount.refundItem((SalesLineItem)theItem.getSellingObject(), Terminal.getLocalHost(), LoginManager.getInstance().getUser());
            } else if (theItem instanceof VoucherTransactionWrapper) {
                new VoucherTransactionReturner(new WaitermateGuiHandler()).returnTransaction((GiftVoucherTransaction)theItem.getSellingObject(), LoginManager.getEventContext());
            }
        } else if (theItem instanceof SalesLineItemWrapper) {
            SalesItem item;
            SalesLineItem deleteItem = (SalesLineItem)theItem.getSellingObject();
            if (!ExperimentalFeatureHelper.isWMShowComboItemsInOldWay() && theItem.getSellingObject() instanceof SalesItem && (item = (SalesItem)theItem.getSellingObject()).getParentCombo() != null) {
                deleteItem = item.getParentCombo();
            }
            this.currentAccount.getItemHelper().removeItem(deleteItem, LoginManager.getEventContext());
        } else if (theItem instanceof VoucherTransactionWrapper) {
            new VoucherTransactionReturner(new WaitermateGuiHandler()).returnTransaction((GiftVoucherTransaction)theItem.getSellingObject(), LoginManager.getEventContext());
        }
        this.itemsUpdatedAndShow();
    }

    void gotUpgrade(Sellable theItem) {
        if (theItem instanceof SalesLineItemWrapper) {
            UpgradeCombo.getInstance().configureSignal(this.upgradeFinished);
            UpgradeCombo.getInstance().upgradeRequested((SalesItem)theItem.getSellingObject(), this.getCurrentItemGroup(), LoginManager.getEventContext());
        }
    }

    void gotPay() {
        if (this.currentAccount.getItems().isEmpty() && this.currentAccount.getActiveVoucherTxns().isEmpty() && !this.currentAccount.allowsPayingIntoCredit() && this.currentAccount.getFinanceTransactions().isEmpty()) {
            Dialogs.displayOkDialog((String)Internationalization.getLiteralFor((String)"THERE_ARE_NO_ITEMS_TO_PAY_OFF"), (String)Internationalization.getLiteralFor((String)"NO_ITEMS"));
        } else {
            if (this.isTicketDataEntryRequired(this.currentAccount) && !this.currentAccount.hasTicketData() && !WaitermateSaveAccount.getInstance().getTicketData(this.currentAccount)) {
                return;
            }
            this.paySelected.emit((Object)this.currentAccount);
        }
    }

    void gotPrintBill() {
        if (WaitermateSaveAccount.getInstance().addInfo(this.currentAccount)) {
            WaitermateSaveAccount.getInstance().printReceiptDockets((ItemGroup)this.currentAccount);
            if (Config.getBooleanValue((String)"printbill_and_save")) {
                this.gotOk();
            }
        }
    }

    void gotAdmin() {
        this.adminSelected.emit((Object)this.currentAccount);
    }

    void gotSeatAdmin() {
        if (this.getAccount() instanceof TableAccount) {
            this.seatAdmin = new SeatAdmin((TableAccount)this.getAccount(), this.items.getCurrentSeat(), this.seatAdminDone);
            this.seatAdmin.gotCustomer.connect((Object)this, "gotCustomerFromSeatAdmin");
            this.seatAdmin.display(false);
        } else {
            Dialogs.displayOkDialog((String)"Seat Admin is only available for table accounts.", (String)"Seat Admin not available.");
        }
    }

    void gotCustomerFromSeatAdmin(Customer customer) {
        this.coupons.getRedeemDoneSignal().disconnect((Object)this);
        this.coupons.getRedeemDoneSignal().connect((Object)this, "gotCouponRedeemDone");
        this.coupons.setCustomer(customer);
        this.coupons.showCustomerCoupons();
        WaitermateAccountGui.getInstance().accountChanged(this.currentAccount);
        CustomerUpdateManager.getInstance().addCustomerToUpdate(customer);
    }

    void gotShowItems() {
        new ShowItemsUtils((SaveAccount)WaitermateSaveAccount.getInstance()).showItems((ItemGroup)this.currentAccount);
    }

    public JComponent getMainArea() {
        return this.gui;
    }

    public NavBar getNavBar() {
        return this.navPanel;
    }

    void gotUpdateCustomer(Customer toSet) {
        CustomerAssignmentContext context = new CustomerAssignmentContext(toSet, this.getAccount(), this.items.getCurrentSeat(), LoginManager.getEventContext());
        CustomerAssignmentStrategy strategy = this.customerAssignmentHelper.resolveStrategy(context);
        if (this.isDisplaying() && strategy.isCustomerEqual()) {
            WaitermateAccountGui.getInstance().accountChanged(this.currentAccount);
            this.refreshCustomerDetails(strategy.getAssignedCustomer());
            this.itemsUpdatedAndShow();
        }
    }

    void gotCustomer(Customer toSet, boolean isSwipe) {
        if (this.isDisplaying()) {
            CustomerAssignmentStrategy theStrategy;
            CustomerAssignmentContext context;
            String id;
            if (BarTabAccount.TYPE.equals((Object)this.currentAccount.getAccountType()) && !StringUtils.isEmpty((String)(id = ((BarTabAccount)this.currentAccount).getCardId())) && ((BarTabAccount)this.currentAccount).getLogicalTable() != null) {
                return;
            }
            if (this.seatAdmin != null && this.seatAdmin.isDisplaying()) {
                this.seatAdmin.setCustomer(toSet);
                return;
            }
            this.coupons.setCustomer(toSet);
            boolean wasDifferentCustomer = false;
            boolean successfullyAssigned = true;
            if (isSwipe) {
                context = new CustomerAssignmentContext(toSet, this.getAccount(), this.items.getCurrentSeat(), LoginManager.getEventContext());
                theStrategy = this.customerAssignmentHelper.resolveStrategy(context);
                wasDifferentCustomer = !theStrategy.isCustomerEqual();
                successfullyAssigned = theStrategy.assignCustomer();
            } else {
                context = new CustomerAssignmentContext(this.getOldCustomer(), this.getAccount(), this.items.getCurrentSeat(), LoginManager.getEventContext());
                theStrategy = this.customerAssignmentHelper.resolveStrategy(context);
                wasDifferentCustomer = !theStrategy.isCustomerEqual();
                successfullyAssigned = true;
            }
            this.oldCustomer = toSet;
            WaitermateAccountGui.getInstance().accountChanged(context.getAccount());
            Customer assignedCustomer = theStrategy.getAssignedCustomer();
            if (wasDifferentCustomer && successfullyAssigned) {
                this.showCoupons(assignedCustomer);
            }
            this.refreshCustomerDetails(assignedCustomer);
            this.itemsUpdatedAndShow();
            CustomerUpdateManager.getInstance().addCustomerToUpdate(assignedCustomer);
        }
    }

    public void showCoupons(Customer customer) {
        this.coupons.getRedeemDoneSignal().disconnect((Object)this);
        this.coupons.getRedeemDoneSignal().connect((Object)this, "gotCouponRedeemDone");
        this.coupons.showCustomerCoupons(customer);
    }

    public void gotCustomerSwipe(Customer aCustomer) {
        if (this.getAccount() != null) {
            this.setOldCustomer(this.getAccount().getCustomer());
        }
        if (this.isDisplaying() && aCustomer != null && SystemProperty.getInstance().isLoyaltyEnabled()) {
            new Thread((Runnable)new LoyaltyResyncTask((GuiHandler)new DummyGUIHandler(), aCustomer)).start();
        }
        this.gotCustomer(aCustomer, true);
        if (this.isDisplaying() && SystemProperty.getInstance().formAutoCombosOnOrder()) {
            ArrayList<List<? extends SalesLineItem>> specificItems = new ArrayList<List<? extends SalesLineItem>>();
            ItemGroup itemGroup = this.getCurrentItemGroup();
            specificItems.add(AccountItemsHelper.getTableCustomerItems((Account)this.getAccount(), (Customer)this.getCurrentCustomer()));
            if (AutoComboSelector.canMakeCombos(itemGroup, specificItems)) {
                AutoComboSelector selector = AutoComboSelector.getInstance();
                selector.configureSignal(this.autoComboDone);
                selector.setContext(itemGroup, specificItems, LoginManager.getEventContext());
                selector.startMake();
            }
        }
    }

    private void refreshCustomerDetails(Customer toRefresh) {
        if (toRefresh != null) {
            this.navPanel.setCustomerName(toRefresh.getName());
            this.navPanel.setCustomerPoints(toRefresh.getLoyaltyPoints());
            this.navPanel.setCustomerCategory(toRefresh.getCategory() != null ? toRefresh.getCategory().getLabel() : "");
            this.navPanel.setShowLoyaltyPoints(SystemProperty.getInstance().isLoyaltyEnabled() && toRefresh.getCategory() != null && toRefresh.getCategory().isLoyaltyPointsEnabled());
        } else {
            this.navPanel.setCustomerName(null);
            this.navPanel.setCustomerCategory(null);
            this.navPanel.setShowLoyaltyPoints(false);
        }
        this.navPanel.enableCustomerLocationButton(this.shouldEnableCustomerLocation(toRefresh));
    }

    private boolean shouldEnableCustomerLocation(Customer toTest) {
        if (toTest == null) {
            return false;
        }
        if (!StringUtils.isEmpty((String)toTest.getSuburb())) {
            return true;
        }
        return !StringUtils.isEmpty((String)toTest.getStreetName());
    }

    public void gotBarcode(String data) {
        InventoryItemUnit theUnit;
        if (this.isDisplaying() && !ScreenResource.isDialogShowing() && (theUnit = WaiterMateInputAdapter.getInstance().parseBarcodeString(data, this.currentAccount.getAccountType())) != null) {
            this.newItemUnitSelected.emit((Object)this.currentAccount, (Object)theUnit, (Object)new OrderedItemDetails(this.items.getCurrentCourse(), this.items.getCurrentSeat(), null), (Object)this.groups.getQuantity());
        }
    }

    public void gotBarcodedItemScanned(String PLU, Double payload) {
        InventoryItemUnit theUnit;
        if (this.isDisplaying() && !ScreenResource.isDialogShowing() && (theUnit = WaiterMateInputAdapter.getInstance().parseBarcodeString(PLU, this.currentAccount.getAccountType())) != null) {
            if (ItemBarcodeType.Price.equals((Object)SystemProperty.getInstance().getItemBarcodeType())) {
                this.newItemUnitSelected.emit((Object)this.currentAccount, (Object)theUnit, (Object)new OrderedItemDetails(this.items.getCurrentCourse(), this.items.getCurrentSeat(), new Price((Number)payload, 0.01)), (Object)this.groups.getQuantity());
            } else {
                SalesQuantity qty = this.groups.getQuantity();
                if (payload != null && payload > 0.0) {
                    qty = new SalesQuantity(new BigDecimal(payload));
                }
                this.newItemUnitSelected.emit((Object)this.currentAccount, (Object)theUnit, (Object)new OrderedItemDetails(this.items.getCurrentCourse(), this.items.getCurrentSeat(), null), (Object)qty);
            }
        }
    }

    private void showPhoneMenu() {
        this.refreshGroups();
        this.navPanel.setPickupButtonSelected(true);
        if (this.currentAccount instanceof PhoneAccount) {
            PhoneAccount phoneAccount = (PhoneAccount)this.currentAccount;
            phoneAccount.setDeliverable(false, LoginManager.getEventContext());
        }
        this.itemsUpdatedAndShow();
    }

    private void showDeliveryMenu() {
        this.refreshGroups();
        this.navPanel.setDeliveryButtonSelected(true);
        if (this.currentAccount instanceof PhoneAccount) {
            PhoneAccount phoneAccount = (PhoneAccount)this.currentAccount;
            phoneAccount.setDeliverable(true, LoginManager.getEventContext());
            Delivery accountDelivery = phoneAccount.getDelivery();
            if (accountDelivery != null) {
                this.navPanel.setPickupButtonEnabled(accountDelivery.getDriver() == null && accountDelivery.getExtDriverId() == null);
            } else {
                this.navPanel.setPickupButtonEnabled(true);
            }
        }
        this.itemsUpdatedAndShow();
    }

    void usePriceLevel(PriceLevel toUse) {
        this.currentAccount.getPriceAdjHelper().usePriceLevel(toUse, true, LoginManager.getEventContext());
        this.itemsUpdatedAndShow();
        new ShowItemsUtils((SaveAccount)WaitermateSaveAccount.getInstance()).showItemsOnPriceLevelChange((ItemGroup)this.currentAccount);
    }

    void useCheapestPriceLevel() {
        this.currentAccount.getPriceAdjHelper().useCheapestPriceLevel(false, LoginManager.getEventContext());
        this.itemsUpdatedAndShow();
        new ShowItemsUtils((SaveAccount)WaitermateSaveAccount.getInstance()).showItemsOnPriceLevelChange((ItemGroup)this.currentAccount);
    }

    private String itemsToString(List<? extends SalesLineItem> updatedItems) {
        StringBuffer itemList = new StringBuffer();
        SalesQuantity itemCount = SalesQuantity.ZERO;
        for (SalesLineItem salesLineItem : updatedItems) {
            itemCount = itemCount.add(salesLineItem.getQuantity());
            itemList.append("<li>");
            itemList.append(salesLineItem.getQuantity());
            itemList.append(" - ");
            itemList.append(salesLineItem.getLabel());
            itemList.append("</li>");
        }
        StringBuffer string = new StringBuffer("<html>" + itemCount);
        string.append(" " + Internationalization.getLiteralFor((String)"ITEM"));
        if (itemCount.notEquals(1)) {
            string.append('s');
        }
        string.append(" " + Internationalization.getLiteralFor((String)"UPDATED") + ". <ul>");
        string.append(itemList);
        string.append("</ul><html>");
        return string.toString();
    }

    public void gotCreditLimit() {
        CreditLimitPanel.doCreditLimitDialog((CreditLimited)this.getAccount(), this.getAccount().getDue(), this.getAccount().getLabel(), false);
    }

    public void gotPrintOrder() {
        if (WaitermateSaveAccount.getInstance().addInfo(this.currentAccount) && WaitermateSaveAccount.getInstance().printOrder(this.currentAccount, LoginManager.getEventContext())) {
            this.startSelectItems(this.currentAccount);
        }
        this.setLastPrintUpdatedTime();
    }

    protected void gotHoldAccount() {
        this.currentAccount.setOnHold(!this.currentAccount.isOnHold());
        this.navPanel.setHoldButtonSelected(this.currentAccount.isOnHold());
    }

    protected void gotOrderInfo() {
        WaitermateSaveAccount.getInstance().getTicketData(this.currentAccount);
    }

    protected void gotCustomerLocation() {
        GoogleMapHelper.getInstance().showGoogleMap(this.currentAccount.getCustomer(), (GuiHandler)new WaitermateGuiHandler());
    }

    public void setUp() {
        super.setUp();
        WaiterMateInputAdapter.getInstance().getUnknownCardHandler().done.connect((Object)this, "selectItems");
        WaiterMateInputAdapter.getInstance().enableUnknownCardHandler(true);
    }

    public void tearDown() {
        WaiterMateInputAdapter.getInstance().enableUnknownCardHandler(false);
        super.tearDown();
    }

    public void gotRenameBartab() {
        String value;
        if (this.currentAccount != null && AccountType.barTabType.equals((Object)this.currentAccount.getAccountType()) && (value = Dialogs.getString((String)Internationalization.getLiteralFor((String)"RENAME_BARTAB"), (String)((BarTabAccount)this.currentAccount).getTabName())) != null && !value.trim().isEmpty()) {
            ((BarTabAccount)this.currentAccount).setTabName(value);
        }
    }

    void showUpsellComponent(JComponent component) {
        this.items.setCustomComponent(component);
    }

    public void gotTableStateChanged(LogicalTableState newState) {
        if (this.currentAccount != null && this.currentAccount instanceof TableAccount) {
            LogicalTable table = ((TableAccount)this.currentAccount).getTable();
            WaitermateSaveAccount.getInstance().setTableState(newState, table, LoginManager.getEventContext(), false);
            if (TableAccount.TYPE.equals((Object)this.currentAccount.getAccountType())) {
                this.items.setCurrentCourse(((TableAccount)this.currentAccount).getCurrentCourse());
            }
        } else if (this.currentAccount != null && this.currentAccount instanceof BarTabAccount) {
            LogicalTable table = ((BarTabAccount)this.currentAccount).getLogicalTable();
            WaitermateSaveAccount.getInstance().setTableState(newState, table, LoginManager.getEventContext(), false);
        }
    }

    public void gotCouponScanned(String uniqueId) {
        if (!this.isDisplaying()) {
            return;
        }
        this.coupons.getRedeemDoneSignal().disconnect((Object)this);
        this.coupons.getRedeemDoneSignal().connect((Object)this, "gotCouponRedeemDone");
        this.coupons.gotCoupon(uniqueId);
    }

    public void gotCouponRedeemDone(Boolean success) {
        this.coupons.getRedeemDoneSignal().disconnect((Object)this);
        this.selectItems();
    }

    public void gotAssignBarTabToTable() {
        this.assignBarTab = new AssignBarTabToTable();
        this.assignBarTab.getBackSignal().connect((Object)this, "gotBarTabAssignedToTable");
        this.assignBarTab.doMoveBarTabToTable(this.currentAccount);
    }

    public void gotBarTabAssignedToTable() {
        if (this.assignBarTab != null) {
            this.assignBarTab.getBackSignal().disconnect((Object)this);
            this.assignBarTab = null;
        }
        this.selectItems();
    }

    void gotSeatTabChanged() {
        if (this.customerAssignmentHelper.isAssignmentPerSeat(this.getAccount())) {
            TableAccount tAcc = (TableAccount)this.getAccount();
            Customer customer = tAcc.getCustomerForSeat(this.items.getCurrentSeat());
            this.refreshCustomerDetails(customer);
            this.enablifyMakeCombos();
        }
        this.updateCourseHoldButton();
    }

    public Customer getCurrentCustomer() {
        Customer customer = this.getAccount().getCustomer();
        if (this.customerAssignmentHelper.isAssignmentPerSeat(this.getAccount())) {
            TableAccount tAcc = (TableAccount)this.getAccount();
            customer = tAcc.getCustomerForSeat(this.items.getCurrentSeat());
        }
        return customer;
    }

    void gotSeatAdminDone() {
        TableAccount tAcc = (TableAccount)this.getAccount();
        this.refreshCustomerDetails(tAcc.getCustomerForSeat(this.items.getCurrentSeat()));
        this.itemsUpdatedAndShow();
        this.seatAdmin = null;
    }

    public Customer getOldCustomer() {
        return this.oldCustomer;
    }

    public void setOldCustomer(Customer oldCustomer) {
        this.oldCustomer = oldCustomer;
    }
}

