/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.ordering.accountitems;

import au.com.ordermate.util.image.IconLoader;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JComponent;
import ordermate.OrderMate;
import ordermate.database.inventory.InventoryGroup;
import ordermate.database.inventory.InventoryItem;
import ordermate.database.misc.resource.ConfigResource;
import ordermate.database.sales.Account;
import ordermate.database.sales.SalesItem;
import ordermate.database.sales.SalesLineItem;
import ordermate.database.sales.Sellable;
import ordermate.database.sales.SellableWrapperFactory;
import ordermate.gui.AlphaButton;
import ordermate.gui.themes.OrderMateTheme;
import ordermate.internationalization.Internationalization;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import org.jdesktop.animation.timing.Animator;
import org.jdesktop.animation.timing.TimingTarget;
import org.jdesktop.animation.timing.interpolation.PropertySetter;
import waitermate.upsell.Upsell;
import waitermate.upsell.UpsellManager;

public class WaitermateUpsell {
    private static final String BUTTON_TEXT = "<html><b>" + Internationalization.getLiteralFor((String)"UPSELL_SUGGESTION") + "</b><br>";
    public final Signal<Sellable, ?, ?, ?, ?> upgrade = Signals.createSignal(Sellable.class, (String)"toUpgrade");
    public final Signal<InventoryItem, ?, ?, ?, ?> item = Signals.createSignal(InventoryItem.class, (String)"orderItem");
    public final Signal<InventoryGroup, ?, ?, ?, ?> section = Signals.createSignal(InventoryGroup.class, (String)"group");
    public final Signal<JComponent, ?, ?, ?, ?> component = Signals.createSignal(JComponent.class, (String)"theComponent");
    private AlphaButton upsellPanel = new AlphaButton();
    private Animator animator;
    private Upsell upsell;
    private ConfigResource resource;
    private SellableWrapperFactory sellableFactory;

    public WaitermateUpsell() {
        this.upsellPanel.setIcon((Icon)IconLoader.get((String)"/waitermate/images/blue_speech_bubble_48.png"));
        this.upsellPanel.setName("upsellButton");
        OrderMateTheme.setupTouchScreenButton((AbstractButton)this.upsellPanel);
        this.upsellPanel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WaitermateUpsell.this.doUpsell();
            }
        });
        this.animator = new Animator(2000, (TimingTarget)new PropertySetter((Object)this.upsellPanel, "alpha", (Object[])new Float[]{Float.valueOf(0.0f), Float.valueOf(0.999f)}));
        this.sellableFactory = new SellableWrapperFactory();
    }

    public void gotAccountChanged(Account account) {
        UpsellManager.getInstance().gotAccountChanged(account);
    }

    public void gotNoAccount() {
        UpsellManager.getInstance().gotAccountChanged(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void gotUpsell(Upsell newUpsell, ConfigResource newResource) {
        WaitermateUpsell waitermateUpsell = this;
        synchronized (waitermateUpsell) {
            this.upsell = newUpsell;
            this.resource = newResource;
            this.updateGui(this.upsell, this.resource);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doUpsell() {
        WaitermateUpsell waitermateUpsell = this;
        synchronized (waitermateUpsell) {
            if (this.upsell != null) {
                this.performUpsell();
            }
        }
    }

    private void performUpsell() {
        this.updateGui(null, null);
        if (this.upsell.getSuggestion().isUpgrade()) {
            SalesItem salesItem = this.upsell.getSalesItem();
            if (salesItem != null && salesItem.getParentCombo() == null) {
                this.upgrade.emit((Object)this.sellableFactory.wrapItem((SalesLineItem)this.upsell.getSalesItem()));
            } else {
                OrderMate.LOG.warn("Cannot upgrade, no salesItem has been linked for " + this.upsell);
            }
        } else if (this.upsell.getSuggestion().getSuggestedItem() != null) {
            this.item.emit((Object)this.upsell.getSuggestion().getSuggestedItem());
        } else if (this.upsell.getSuggestion().getSuggestedGroup() != null) {
            this.section.emit((Object)this.upsell.getSuggestion().getSuggestedGroup());
        }
        OrderMate.LOG.info("Got Upsell Performed:" + this.upsell);
        this.upsell = null;
    }

    private void updateGui(Upsell theUpsell, ConfigResource theResource) {
        if (this.animator != null) {
            this.animator.stop();
        }
        this.upsellPanel.setAlpha(0.0f);
        if (theUpsell == null) {
            this.upsellPanel.setVisible(false);
        } else {
            StringBuilder SB = new StringBuilder(BUTTON_TEXT);
            SB.append(theUpsell.toString());
            SB.append("</html>");
            this.upsellPanel.setText(SB.toString());
            this.upsellPanel.setVisible(true);
        }
        this.component.emit((Object)this.upsellPanel);
        this.animator.start();
    }
}

