/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.ordering.additems;

import java.util.List;
import java.util.Map;
import ordermate.database.sales.Account;
import ordermate.database.sales.ItemGroup;
import ordermate.database.sales.SalesLineItem;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import waitermate.gui.screens.ordering.additems.OrderedItemDetails;
import waitermate.gui.screens.ordering.additems.addSeatQty.AddSeatQuantities;
import waitermate.gui.screens.selectaccount.table.CoversHelper;

public class FinaliseItem {
    public final Signal itemsDone = Signals.createSignal(List.class, (String)"New items");
    public Signal back = Signals.createSignal();
    private Account account;
    private List<SalesLineItem> allFinishedItems;
    private OrderedItemDetails details;
    private AddSeatQuantities enterSeatQtys = new AddSeatQuantities();

    public FinaliseItem() {
        this.enterSeatQtys.back.connect((Object)this, "gotBack");
        this.enterSeatQtys.qtys.connect((Object)this, "gotSeatQtys");
        this.enterSeatQtys.singleQty.connect((Object)this, "gotSeat");
    }

    public void startFinalisingItem(List<SalesLineItem> slsLineItems, Account newAccount, OrderedItemDetails itemDetails, Signal backSig) {
        this.account = newAccount;
        this.details = itemDetails;
        this.allFinishedItems = slsLineItems;
        this.back = backSig;
        for (SalesLineItem item : slsLineItems) {
            this.enterSeatQty(item);
        }
    }

    void enterSeatQty(SalesLineItem toAssignQtyToSeats) {
        if (this.enterSeatQtys.checkDoScreen(this.account)) {
            this.enterSeatQtys.setup(toAssignQtyToSeats, CoversHelper.getValueForSeats((ItemGroup)this.account));
            this.enterSeatQtys.display(false);
        } else {
            this.finishFinalise();
        }
    }

    void gotSeatQtys(Map items) {
        this.details.setSeatToQtyMap(items);
        this.finishFinalise();
    }

    void gotSeat(Integer seat) {
        Integer selectedSeat = seat;
        if (selectedSeat != null) {
            this.details.setSeat(selectedSeat);
        }
        this.finishFinalise();
    }

    void finishFinalise() {
        this.tearDownScreens();
        this.itemsDone.emit(this.allFinishedItems);
    }

    void gotBack() {
        this.tearDownScreens();
        this.back.emit();
    }

    private void tearDownScreens() {
        this.enterSeatQtys.tearDown();
    }
}

