/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.ordering.additems;

import au.com.ordermate.gui.GuiHandler;
import au.com.ordermate.units.SalesQuantity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ordermate.OrderMate;
import ordermate.database.hardware.Terminal;
import ordermate.database.inventory.InventoryItem;
import ordermate.database.inventory.combos.InventoryCombo;
import ordermate.database.inventory.combos.InventoryComboGroup;
import ordermate.database.inventory.triggers.activation.TriggerActivationContext;
import ordermate.database.sales.Account;
import ordermate.database.sales.ItemGroup;
import ordermate.database.sales.SalesCombo;
import ordermate.database.sales.SalesItem;
import ordermate.database.sales.SalesLineItem;
import ordermate.database.users.User;
import ordermate.gui.ordering.OrderComboHelper;
import ordermate.signals.Signal;
import waitermate.LoginManager;
import waitermate.gui.WaitermateGuiHandler;
import waitermate.gui.screens.ordering.additems.SpecifyItem;
import waitermate.gui.screens.ordering.additems.selectcomboitems.SelectComboItems;
import waitermate.guikit.dialogs.Dialogs;

public class SpecifyCombo {
    public Signal comboDone;
    public Signal back;
    public Signal cancel;
    private SelectComboItems selectComboItems = new SelectComboItems();
    private SpecifyItem specifyItem;
    private InventoryCombo inventoryCombo;
    private SalesQuantity quantity;
    private Account account;
    private List<SalesItem> forcedItems;
    private boolean overOrdering = false;
    Map<InventoryComboGroup, List<SalesItem>> revertToMap;
    private Map<InventoryComboGroup, List<SalesItem>> comboItems;
    private final OrderComboHelper helper;
    private static final SpecifyCombo instance = new SpecifyCombo();

    public static final SpecifyCombo getInstance() {
        return instance;
    }

    private SpecifyCombo() {
        this.selectComboItems.back.connect((Object)this, "gotBack");
        this.selectComboItems.itemSelected.connect((Object)this, "gotInventoryItemSelected");
        this.selectComboItems.ok.connect((Object)this, "gotComboDone");
        this.selectComboItems.clear.connect((Object)this, "gotClear");
        this.specifyItem = new SpecifyItem();
        this.specifyItem.back.connect((Object)this.selectComboItems, "display");
        this.specifyItem.itemsDone.connect((Object)this, "gotItemsDone");
        this.helper = new OrderComboHelper((GuiHandler)new WaitermateGuiHandler());
    }

    public void configureSignals(Signal backSignal, Signal cancelSignal, Signal gotComboDoneSignal) {
        this.back = backSignal;
        this.cancel = cancelSignal;
        this.comboDone = gotComboDoneSignal;
    }

    public void startSpecifyingItem(InventoryCombo combo, SalesQuantity newQuantity, Account newAccount, List<SalesItem> forcedItems) {
        this.quantity = newQuantity;
        this.account = newAccount;
        this.inventoryCombo = combo;
        this.comboItems = new HashMap<InventoryComboGroup, List<SalesItem>>();
        this.forcedItems = forcedItems;
        this.overOrdering = false;
        this.selectComboItems.start(combo, this.comboItems, forcedItems, new TriggerActivationContext(LoginManager.getEventContext(), new Date(), (ItemGroup)newAccount));
    }

    public void startSpecifyingItem(InventoryCombo combo, SalesQuantity newQuantity, Account theAccount) {
        this.startSpecifyingItem(combo, newQuantity, theAccount, new ArrayList<SalesItem>());
    }

    void gotBack() {
        this.back.emit();
    }

    void doOverOrderedComboItems(InventoryItem item, InventoryComboGroup comboGroup, SalesQuantity totalOrderedQty) {
        this.overOrdering = true;
        SalesQuantity newQty = this.helper.doOverOrderedComboItems(item, comboGroup, totalOrderedQty, this.getComboItemsForTab(comboGroup), this.selectComboItems.getQuantity(), this.selectComboItems.getIncrementQuantityFlag());
        if (newQty != null) {
            this.selectComboItems.setQuantity(newQty);
            this.selectComboItems.setIncrementQuantityFlag(true);
        }
        this.specifyItem.startSpecifyingComboItem(item, comboGroup, this.selectComboItems.getQuantity(), this.account);
    }

    void gotInventoryItemSelected(InventoryItem item, InventoryComboGroup comboGroup) {
        SalesQuantity totalOrderedQty = this.getTotalOrderedQty(comboGroup);
        if (totalOrderedQty.add(this.selectComboItems.getQuantity()).greaterThan(comboGroup.getMaxQuantity()) && (this.selectComboItems.getIncrementQuantityFlag() || this.selectComboItems.getQuantity().add(totalOrderedQty).greaterThan(comboGroup.getMaxQuantity()))) {
            this.doOverOrderedComboItems(item, comboGroup, totalOrderedQty);
            this.selectComboItems.updatedOrderedItems(this.comboItems);
            this.selectComboItems.display();
            return;
        }
        this.specifyItem.startSpecifyingComboItem(item, comboGroup, this.selectComboItems.getQuantity(), this.account);
    }

    void gotItemsDone(List<SalesItem> newSalesItems) {
        List selectedTabsItems = this.fetchComboGroupItems(newSalesItems);
        if (!this.overOrdering) {
            selectedTabsItems.removeAll(this.selectComboItems.getSelectedTabGroup().getMatchedItems(this.forcedItems));
        }
        selectedTabsItems = this.regroupItems(newSalesItems, selectedTabsItems);
        List<SalesLineItem> singles = this.splitItems(selectedTabsItems);
        this.filterZeroQtys(singles, selectedTabsItems);
        if (!this.overOrdering) {
            selectedTabsItems.addAll(this.filterUsedForcedItems(this.selectComboItems.getSelectedTabGroup().getMatchedItems(this.forcedItems)));
        }
        this.comboItems.put(this.selectComboItems.getSelectedTabGroup(), selectedTabsItems);
        this.selectComboItems.updatedOrderedItems(this.comboItems);
        this.selectComboItems.display();
        if (!this.selectComboItems.hasChoices()) {
            this.selectComboItems.clickOk();
        }
    }

    private Collection filterUsedForcedItems(List<? extends SalesLineItem> matchedItems) {
        for (InventoryComboGroup group : this.comboItems.keySet()) {
            if (group.equals((Object)this.selectComboItems.getSelectedTabGroup())) continue;
            for (SalesLineItem salesLineItem : this.comboItems.get(group)) {
                if (!matchedItems.contains(salesLineItem)) continue;
                matchedItems.remove(salesLineItem);
            }
        }
        return matchedItems;
    }

    private void filterZeroQtys(List<SalesLineItem> singles, List toFilterQtysOn) {
        toFilterQtysOn.clear();
        for (SalesItem salesItem : singles) {
            if (!salesItem.getQuantity().greaterThan(0L)) continue;
            toFilterQtysOn.add(salesItem);
        }
    }

    private List<SalesLineItem> splitItems(List allItemsToSplit) {
        ArrayList<SalesLineItem> tempComboList = new ArrayList<SalesLineItem>();
        for (SalesItem item : allItemsToSplit) {
            tempComboList.addAll(item.splitItem(Terminal.getLocalHost(), LoginManager.getInstance().getUser()));
        }
        return tempComboList;
    }

    private List fetchComboGroupItems(List<SalesItem> newSalesItems) {
        List<SalesItem> selectedTabsItems = this.getComboItemsForTab(this.selectComboItems.getSelectedTabGroup());
        if (!this.selectComboItems.getIncrementQuantityFlag()) {
            if (!newSalesItems.isEmpty()) {
                SalesLineItem item = (SalesLineItem)newSalesItems.get(0);
                selectedTabsItems.removeAll(item.getEquivalentItems(selectedTabsItems));
                selectedTabsItems.addAll(newSalesItems);
            }
        } else {
            selectedTabsItems.addAll(newSalesItems);
        }
        return selectedTabsItems;
    }

    private List regroupItems(List<SalesItem> itemsToGroupOn, List allItemsToBeGrouped) {
        List toReturn = allItemsToBeGrouped;
        for (int i = 0; i < itemsToGroupOn.size(); ++i) {
            SalesItem item = itemsToGroupOn.get(i);
            toReturn = item.regroupItems(toReturn, Terminal.getLocalHost(), LoginManager.getInstance().getUser());
        }
        return toReturn;
    }

    void gotComboDone() {
        Terminal localhost = Terminal.getLocalHost();
        User user = LoginManager.getInstance().getUser();
        SalesCombo salesCombo = null;
        this.revertToMap = this.cloneContentsOfMap(this.selectComboItems.getOrderedItemsSortedByGroup());
        try {
            salesCombo = this.inventoryCombo.createHelper().makeSalesCombo(new OrderComboHelper((GuiHandler)new WaitermateGuiHandler()), this.selectComboItems.getOrderedItemsSortedByGroup(), this.quantity, localhost, user);
            this.comboDone.emit((Object)salesCombo);
        }
        catch (RuntimeException e) {
            OrderMate.LOG.warn("Failed to create a combo for " + this.inventoryCombo.toString(), (Throwable)e);
            Dialogs.displayOkDialog((String)"This combo can't be ordered due to an issue in the menu setup. This will need to be corrected in OfficeMate before this combo can be ordered.", (String)"Can't order combo!");
        }
    }

    private Map<InventoryComboGroup, List<SalesItem>> cloneContentsOfMap(Map<InventoryComboGroup, List<SalesItem>> orderedItemsSortedByGroup) {
        HashMap<InventoryComboGroup, List<SalesItem>> myMap = new HashMap<InventoryComboGroup, List<SalesItem>>();
        for (Map.Entry<InventoryComboGroup, List<SalesItem>> entry : orderedItemsSortedByGroup.entrySet()) {
            ArrayList<SalesItem> copyList = new ArrayList<SalesItem>();
            for (SalesItem item : entry.getValue()) {
                copyList.add((SalesItem)item.copy(LoginManager.getEventContext(), true));
            }
            myMap.put(entry.getKey(), copyList);
        }
        return myMap;
    }

    public void gotBackToState() {
        this.selectComboItems.updatedOrderedItems(this.revertToMap);
    }

    private void regroupMap(Map<InventoryComboGroup, List<SalesLineItem>> comboListMap, List<SalesLineItem> toGroupOn) {
        for (InventoryComboGroup group : comboListMap.keySet()) {
            List localToGroupOn = group.getMatchedItems(toGroupOn);
            List<SalesLineItem> groupsItems = comboListMap.get(group);
            comboListMap.put(group, this.regroupItems(localToGroupOn, groupsItems));
        }
    }

    void gotClear(InventoryComboGroup group) {
        this.getComboItemsForTab(group).removeAll((Collection)this.comboItems.get(group));
        this.selectComboItems.updatedOrderedItems(this.comboItems);
        this.selectComboItems.display();
    }

    List<SalesItem> getComboItemsForTab(InventoryComboGroup tabGroup) {
        if (!this.comboItems.containsKey(tabGroup)) {
            this.comboItems.put(tabGroup, new ArrayList());
        }
        return this.comboItems.get(tabGroup);
    }

    private SalesQuantity getTotalOrderedQty(InventoryComboGroup comboGroup) {
        SalesQuantity totalOrderedQty = SalesQuantity.ZERO;
        for (SalesItem element : this.getComboItemsForTab(comboGroup)) {
            SalesLineItem salesLinteItem = (SalesLineItem)element;
            totalOrderedQty = totalOrderedQty.add(salesLinteItem.getQuantity());
        }
        return totalOrderedQty;
    }
}

