/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.ordering.additems;

import au.com.ordermate.units.SalesQuantity;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import ordermate.database.hardware.Terminal;
import ordermate.database.inventory.InventoryItem;
import ordermate.database.inventory.InventoryItemUnit;
import ordermate.database.inventory.InventoryOptionGroupLink;
import ordermate.database.inventory.UnitPriceLevel;
import ordermate.database.inventory.triggers.activation.TriggerActivationContext;
import ordermate.database.sales.Account;
import ordermate.database.sales.ItemGroup;
import ordermate.database.sales.SalesComponent;
import ordermate.database.sales.SalesItem;
import ordermate.internationalization.Internationalization;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import waitermate.LoginManager;
import waitermate.gui.screens.ordering.additems.selectitem.SelectHalfHalf;
import waitermate.gui.screens.ordering.additems.selectoptions.SelectOptions;
import waitermate.guikit.dialogs.Dialogs;

class SpecifyComponents {
    public final Signal back = Signals.createSignal();
    public final Signal<SalesItem, ?, ?, ?, ?> done = Signals.createSignal(SalesItem.class, (String)"new item");
    private SelectHalfHalf selectHalfHalf = new SelectHalfHalf();
    private SelectOptions selectOptions;
    private SalesItem currentItem;
    private SalesComponent currentComponent;
    private Account currentAccount;
    private List otherItems;
    private final double SOME_SMALL_AMOUNT = 1.0E-10;

    public SpecifyComponents() {
        this.selectHalfHalf.back.connect((Object)this, "gotBackToOptions");
        this.selectHalfHalf.itemSelected.connect((Object)this, "gotHalfHalf");
        this.selectOptions = new SelectOptions();
        this.selectOptions.optionsSelected.connect((Object)this, "gotOptions");
        this.selectOptions.back.connect((Object)this, "gotBackHalfHalf");
    }

    public void start(InventoryItemUnit selectedUnit, List otherPossibleItems, SalesQuantity newQuantity, Account account) {
        this.otherItems = otherPossibleItems;
        UnitPriceLevel priceLevel = selectedUnit.getActiveUnitPriceLevel(LoginManager.getEventContext(), new Date(), account);
        if (priceLevel == null) {
            Dialogs.displayOkDialog((String)Internationalization.getLiteralFor((String)"THE_SELECTED_ITEM_AND_SIZE_HAS_NO_CURRENTLY_ACTIVE_PRICES"), (String)Internationalization.getLiteralFor((String)"ITEM_CANNOT_BE_ORDERED"));
            this.back.emit();
        } else {
            this.currentItem = new SalesItem(Terminal.getLocalHost(), LoginManager.getInstance().getUser());
            this.currentItem.setQuantity(newQuantity, LoginManager.getEventContext());
            this.currentComponent = this.currentItem.createComponent(selectedUnit, priceLevel);
            this.currentAccount = account;
            this.selectOptions(selectedUnit);
        }
    }

    public void startBack() {
        this.gotBackToOptions();
    }

    void selectOptions(InventoryItemUnit unit) {
        TriggerActivationContext context = new TriggerActivationContext(LoginManager.getEventContext(), new Date(), (ItemGroup)this.currentAccount);
        List groupLinks = unit.getOptionGroupLinks();
        boolean mandatory = false;
        for (InventoryOptionGroupLink link : groupLinks) {
            if (link.getMinQty() <= 0) continue;
            mandatory = true;
            break;
        }
        if (groupLinks.isEmpty() || !mandatory && !Terminal.getLocalHost().getForcedOptions()) {
            this.gotOptions(new ArrayList());
        } else {
            this.selectOptions.selectOptions(this.currentComponent, context, true);
        }
    }

    void gotOptions(List options) {
        this.currentComponent.removeAllOptions();
        this.currentComponent.addOptions(options);
        if (Math.abs(this.currentItem.getTotalPortion() - 1.0) < 1.0E-10) {
            this.done.emit((Object)this.currentItem);
        } else {
            this.startHalfHalf();
        }
    }

    void gotBackToOptions() {
        this.currentComponent.removeAllOptions();
        TriggerActivationContext context = new TriggerActivationContext(LoginManager.getEventContext(), new Date(), (ItemGroup)this.currentAccount);
        if (this.currentComponent.getUnit().getActiveOptionGroupLinks(context).isEmpty()) {
            this.gotBackHalfHalf();
        } else {
            this.selectOptions.selectOptions(this.currentComponent, context, false);
        }
    }

    private void startHalfHalf() {
        ArrayList<SalesItem> allOrdered = new ArrayList<SalesItem>();
        allOrdered.add(this.currentItem);
        this.selectHalfHalf.selectItem(this.otherItems, allOrdered, this.currentAccount.getItemHelper().getAllItemsUnsaved());
    }

    void gotHalfHalf(InventoryItem otherHalf) {
        InventoryItemUnit selectedUnit = otherHalf.getUnit(this.currentComponent.getUnit().getSize(), this.currentComponent.getUnit().getPortion());
        UnitPriceLevel priceLevel = selectedUnit.getActiveUnitPriceLevel(LoginManager.getEventContext(), new Date(), this.currentAccount);
        if (priceLevel == null) {
            Dialogs.displayOkDialog((String)Internationalization.getLiteralFor((String)"THE_SELECTED_ITEM_AND_SIZE_HAS_NO_CURRENTLY_ACTIVE_PRICES"), (String)Internationalization.getLiteralFor((String)"ITEM_CANNOT_BE_ORDERED"));
            this.back.emit();
        } else {
            this.currentComponent = this.currentItem.createComponent(selectedUnit, null);
            this.selectOptions(selectedUnit);
        }
    }

    void gotBackHalfHalf() {
        this.currentItem.removeComponent(this.currentComponent);
        this.currentComponent = null;
        if (this.currentItem.getTotalPortion() == 0.0) {
            this.back.emit();
        } else {
            this.currentComponent = (SalesComponent)this.currentItem.getComponentList().get(this.currentItem.getComponentList().size() - 1);
            this.startHalfHalf();
        }
    }

    public void tearDown() {
        this.selectOptions.tearDown();
        this.selectHalfHalf.tearDown();
    }
}

