/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.ordering.additems.selectWeight;

import javax.swing.JComponent;
import ordermate.database.hardware.Terminal;
import ordermate.database.hardware.physical.scales.ScalesStatus;
import ordermate.database.inventory.InventoryItemUnit;
import ordermate.integration.scales.ScalesAdapter;
import ordermate.integration.scales.ScalesManager;
import ordermate.integration.scales.ScalesResponse;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import waitermate.gui.screens.ordering.additems.selectWeight.ScalesSniffer;
import waitermate.gui.screens.ordering.additems.selectWeight.SelectWeightNavBar;
import waitermate.gui.screens.ordering.additems.selectWeight.SelectWeightPanel;
import waitermate.guikit.NavBar;
import waitermate.guikit.dialogs.PopupWindow;

public class SelectWeight {
    public final Signal cancel = Signals.createSignal();
    public final Signal<InventoryItemUnit, Double, ?, ?, ?> weightOk = Signals.createSignal(InventoryItemUnit.class, (String)"itemUnit", Double.class, (String)"weight");
    public final Signal<InventoryItemUnit, ?, ?, ?, ?> manuallyEnterWeight = Signals.createSignal(InventoryItemUnit.class, (String)"itemUnit");
    private SelectWeightPanel weightPanel = new SelectWeightPanel();
    private SelectWeightNavBar navBar = new SelectWeightNavBar();
    private PopupWindow window;
    private InventoryItemUnit itemUnit;
    private Double lastStableValue;
    private ScalesSniffer sniffer;
    private ScalesAdapter adapter;

    public SelectWeight() {
        this.navBar.cancel.connect((Object)this, "gotWeightCanceled");
        this.navBar.ok.connect((Object)this, "gotWeightDone");
        this.navBar.manualEntry.connect((Object)this, "gotManuallyEnterWeight");
        this.window = new PopupWindow((NavBar)this.navBar);
        this.sniffer = new ScalesSniffer();
        this.sniffer.readScales.connect((Object)this, "gotWeightData");
    }

    public void startSelectingWeight(InventoryItemUnit newItemUnit) {
        this.itemUnit = newItemUnit;
        this.lastStableValue = null;
        this.adapter = ScalesManager.getInstance().getScalesAdapter(Terminal.getLocalHost());
        if (this.adapter == null) {
            this.manuallyEnterWeight.emit((Object)newItemUnit);
        } else {
            this.window.setComponent((JComponent)this.weightPanel);
            this.weightPanel.setInventoryItem(this.itemUnit.getItem());
            this.sniffer.startSniffing(this.adapter);
            this.navBar.getOkButton().setEnabled(false);
            this.navBar.setStatus(ScalesStatus.Zero);
            this.navBar.enableManualEntryButton(false);
            this.window.start();
        }
    }

    public void gotWeightData(ScalesResponse response) {
        if (ScalesStatus.OK.equals((Object)response.getStatus()) && response.getWeight() != null && response.getWeight() > 0.0) {
            this.lastStableValue = response.getWeight();
        }
        this.navBar.getOkButton().setEnabled(this.lastStableValue != null);
        if (this.lastStableValue != null && !this.lastStableValue.equals(0.0) && this.adapter.isRetailMode()) {
            this.navBar.ok.emit();
        } else {
            ScalesStatus status = response.getStatus();
            this.navBar.enableManualEntryButton(ScalesStatus.Unreachable.equals((Object)status));
            this.weightPanel.setWeight(this.lastStableValue);
            this.navBar.setStatus(status);
        }
    }

    void gotWeightDone() {
        this.sniffer.stopSniffing();
        if (this.lastStableValue != null) {
            this.weightOk.emit((Object)this.itemUnit, (Object)this.lastStableValue);
        } else {
            this.gotWeightCanceled();
        }
        this.itemUnit = null;
    }

    void gotWeightCanceled() {
        this.sniffer.stopSniffing();
        this.itemUnit = null;
        this.lastStableValue = null;
        this.cancel.emit();
    }

    void gotManuallyEnterWeight() {
        InventoryItemUnit unit = this.itemUnit;
        this.navBar.cancel.emit();
        this.gotWeightCanceled();
        this.manuallyEnterWeight.emit((Object)unit);
    }
}

