/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.ordering.additems.selectWeight;

import au.com.ordermate.gui.GraphPaperLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import javax.swing.JLabel;
import javax.swing.JPanel;
import ordermate.database.inventory.InventoryItem;
import ordermate.database.inventory.InventoryWeightUnit;
import ordermate.gui.themes.OrderMateTheme;
import ordermate.internationalization.Internationalization;

class SelectWeightPanel
extends JPanel {
    private NumberFormat numberFormat;
    private JLabel itemLabel;
    private JLabel weightLabel;
    private JLabel unitsLabel;
    private InventoryWeightUnit unit;

    SelectWeightPanel() {
        super((LayoutManager)new GraphPaperLayout(5, 5));
        this.setupComponents();
    }

    private void setupComponents() {
        this.itemLabel = new JLabel(Internationalization.getLiteralFor((String)"A_REALLY_LONG_NAMED_ITEM"));
        this.unitsLabel = new JLabel(Internationalization.getLiteralFor((String)"KG"));
        this.weightLabel = new JLabel("123.456");
        this.itemLabel.setFont(OrderMateTheme.getVeryLargeFont());
        this.unitsLabel.setFont(OrderMateTheme.getVeryLargeFont());
        this.weightLabel.setFont(OrderMateTheme.getVeryLargeFont());
        this.add((Component)this.itemLabel, new Rectangle(0, 0, 5, 2));
        this.add((Component)this.weightLabel, new Rectangle(2, 2, 2, 3));
        this.add((Component)this.unitsLabel, new Rectangle(4, 2, 1, 3));
    }

    void setInventoryItem(InventoryItem item) {
        this.unit = item.getInventoryWeightUnit();
        this.unitsLabel.setText(this.unit.getDisplay());
        this.weightLabel.setText(" - ");
        this.itemLabel.setText(item.getLabel());
        this.numberFormat = this.unit.getFactor() > 1 ? new DecimalFormat("#0") : new DecimalFormat("#0.000");
    }

    void setWeight(Double value) {
        if (value != null) {
            this.weightLabel.setText(this.numberFormat.format(value * (double)this.unit.getFactor()));
        } else {
            this.weightLabel.setText(" - ");
        }
        this.weightLabel.invalidate();
        this.weightLabel.repaint();
    }
}

