/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.ordering.additems.selectitem;

import au.com.ordermate.units.SalesQuantity;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import ordermate.database.hardware.Terminal;
import ordermate.database.inventory.InventoryGroup;
import ordermate.database.inventory.InventoryItem;
import ordermate.database.inventory.InventoryProfile;
import ordermate.database.inventory.OrderedQuantity;
import ordermate.database.inventory.triggers.activation.TriggerActivationContext;
import ordermate.database.misc.SystemProperty;
import ordermate.database.sales.AccountType;
import ordermate.database.sales.SalesLineItem;
import ordermate.gui.BorderUtils;
import ordermate.gui.keypad.Keypad;
import ordermate.gui.scroll.CustomScrollPane;
import ordermate.gui.scroll.CustomScrollPaneModel;
import ordermate.gui.scroll.DefaultScrollPaneModel;
import ordermate.gui.scroll.Renderer;
import ordermate.gui.scroll.RendererScrollPaneModel;
import ordermate.internationalization.Internationalization;
import waitermate.gui.displayitems.SelectItemButtonRenderer;
import waitermate.gui.screens.ordering.additems.selectitem.AbstractMenuItemSelectionPanel;
import waitermate.guikit.dialogs.KeypadDialog;

public class SimpleMenuItemSelectionPanel
extends AbstractMenuItemSelectionPanel {
    private final SelectItemButtonRenderer renderer;
    private final RendererScrollPaneModel scrollModel;
    private final CustomScrollPane scrollPane;
    private final KeypadDialog quantity;
    private final CustomScrollPane seats;
    private final DefaultScrollPaneModel seatPaneModel;
    private final JPanel seatPanel;
    private ButtonGroup seatButtonGroup;
    private InventoryGroup currentGroup;

    public SimpleMenuItemSelectionPanel(SelectItemButtonRenderer theRenderer) {
        this.renderer = theRenderer;
        this.groupSelected = theRenderer.groupSelected;
        this.itemSelected = theRenderer.itemSelected;
        this.comboSelected = theRenderer.comboSelected;
        this.scrollModel = new RendererScrollPaneModel((Renderer)this.renderer);
        this.scrollPane = new CustomScrollPane((CustomScrollPaneModel)this.scrollModel);
        this.scrollPane.setEmptyMessage(Internationalization.getLiteralFor((String)"THERE_ARE_NO_ITEMS_IN_THIS_GROUP"));
        this.scrollPane.setName("itemsScroll");
        Keypad keypad = new Keypad.HorizontalKeypadBuilder().setShowDecimal(SystemProperty.getInstance().isFractionalQtys()).setButtonPadding(1).build();
        this.quantity = new KeypadDialog(keypad, 1);
        this.quantity.setUnits(Internationalization.getLiteralFor((String)"QTY_COLON"));
        this.quantity.setVisible(false);
        BorderUtils.addEmptyBorder((JComponent)this.quantity);
        this.seatPanel = new JPanel(new BorderLayout());
        this.seatPanel.setBorder(BorderFactory.createTitledBorder(Internationalization.getLiteralFor((String)"QUICK_SEAT_SELECT")));
        this.seatPaneModel = new DefaultScrollPaneModel(1, 6);
        this.seats = new CustomScrollPane((CustomScrollPaneModel)this.seatPaneModel);
        this.seatPanel.add((Component)this.seats, "Center");
        this.seatPanel.setVisible(false);
        this.setLayout(new BorderLayout());
        this.add((Component)this.scrollPane, "Center");
        this.add((Component)this.quantity, "North");
        this.add((Component)this.seatPanel, "East");
    }

    public SimpleMenuItemSelectionPanel(int columns, int rows, SelectItemButtonRenderer theRenderer) {
        this(theRenderer);
        this.scrollPane.setColumns(columns);
        this.scrollPane.setRowsPerPage(rows);
    }

    @Override
    public void showRootGroup(TriggerActivationContext context, List<SalesLineItem> orderedItems, List<SalesLineItem> uncommittedItems) {
        InventoryProfile profile = InventoryProfile.getProfile((AccountType)context.getAccount().getAccountType(), (Terminal)Terminal.getLocalHost());
        if (profile == null) {
            this.scrollPane.setEmptyMessage("<html><p align='center'>" + Internationalization.getLiteralFor((String)"THERE_IS_NO_MENU_PROFILE_ASSIGNED_TO_THIS_ACCOUNT_TYPE") + "</html>");
            this.currentGroup = null;
        } else {
            this.showRootGroup(context, profile, false, null, orderedItems, uncommittedItems);
        }
    }

    void showRootGroup(TriggerActivationContext context, InventoryProfile profile, boolean doHighlight, InventoryGroup initGroup, List<SalesLineItem> orderedItems, List<SalesLineItem> uncommittedItems) {
        this.renderer.highlightSelected(doHighlight, initGroup);
        this.scrollPane.setEmptyMessage("<html><p align='center'>" + Internationalization.getLiteralFor((String)"THERE_ARE_NO_MENU_GROUPS") + "</html>");
        ArrayList toDisplay = new ArrayList(InventoryProfile.getProfileGroups((TriggerActivationContext)context, (InventoryProfile)profile));
        toDisplay.addAll(profile.getQuickSaleItems(Terminal.getLocalHost()));
        this.renderer.setOrderedQuantities(new OrderedQuantity(orderedItems, true), new OrderedQuantity(uncommittedItems, true));
        this.scrollModel.setObjects(toDisplay);
        this.currentGroup = null;
    }

    public void showItems(List<InventoryItem> inventoryItems, List<SalesLineItem> orderedItems, List<SalesLineItem> uncommitedItems) {
        LinkedList<InventoryItem> toAdd = new LinkedList<InventoryItem>(inventoryItems);
        OrderedQuantity orderedQuantity = new OrderedQuantity(orderedItems, true);
        OrderedQuantity uncommittedItemData = new OrderedQuantity(uncommitedItems, true);
        this.renderer.setOrderedQuantities(orderedQuantity, uncommittedItemData);
        this.scrollModel.setObjects(toAdd);
        this.quantity.setupLongInt(SystemProperty.getInstance().isFractionalQtys(), SystemProperty.getInstance().getMaxNumbFigures());
        this.quantity.setValue("1");
    }

    public void showGroup(TriggerActivationContext context, InventoryGroup theGroup, List orderedItems, List uncommitedItems) {
        this.showGroup(context, theGroup, orderedItems, uncommitedItems, true);
    }

    protected void showGroup(TriggerActivationContext context, InventoryGroup theGroup, List<SalesLineItem> orderedItems, List<SalesLineItem> uncommitedItems, boolean showSubGroups) {
        LinkedList toAdd = new LinkedList();
        this.currentGroup = theGroup;
        if (showSubGroups) {
            ArrayList breadCrumb = new ArrayList(theGroup.getParentGroups());
            if (breadCrumb.size() > 1) {
                Collections.reverse(breadCrumb);
            }
            toAdd.addAll(breadCrumb);
            toAdd.addAll(theGroup.getActiveSubgroups(context));
        }
        toAdd.addAll(theGroup.getActiveCombos(context));
        toAdd.addAll(theGroup.getItems());
        OrderedQuantity orderedQuantity = new OrderedQuantity(orderedItems, true);
        OrderedQuantity uncommittedItemData = new OrderedQuantity(uncommitedItems, true);
        this.renderer.setOrderedQuantities(orderedQuantity, uncommittedItemData);
        this.scrollModel.setObjects(toAdd);
        this.quantity.setupLongInt(SystemProperty.getInstance().isFractionalQtys(), SystemProperty.getInstance().getMaxNumbFigures());
        this.quantity.setValue("1");
    }

    @Override
    public void setNumKeypadVisible(boolean showQuantity) {
        this.quantity.setVisible(showQuantity);
    }

    public void setQtyKeypadLabelInline(boolean inline) {
        this.quantity.setKeypadLabelInline(inline);
    }

    @Override
    public SalesQuantity getQuantity() {
        if (this.quantity.isVisible()) {
            SalesQuantity qty = new SalesQuantity(this.quantity.getValueAsBigDecimal());
            if (SalesQuantity.ONE.equals(qty)) {
                return SalesQuantity.ONE;
            }
            return qty;
        }
        return SalesQuantity.ONE;
    }

    @Override
    public boolean getFirstPressQuantityFlag() {
        return this.quantity.getFirstPressQuantityFlag();
    }

    @Override
    public void setRowsPerPage(int rowsPerPage) {
        this.scrollPane.setRowsPerPage(rowsPerPage);
    }

    public int getRowsPerPage() {
        return this.scrollPane.getRowsPerPage();
    }

    @Override
    public void setColumns(int columns) {
        this.scrollPane.setColumns(columns);
    }

    public int getColumns() {
        return this.scrollPane.getColumns();
    }

    @Override
    public InventoryGroup getInventoryGroup() {
        return this.currentGroup;
    }

    @Override
    public void setupSeatsPanel(int numSeats, int selectedSeat) {
        this.seatPaneModel.reset();
        if (numSeats < 2) {
            this.seatPanel.setVisible(false);
            return;
        }
        this.seatButtonGroup = new ButtonGroup();
        for (int i = 0; i < numSeats + 1; ++i) {
            JToggleButton newButton = new JToggleButton();
            newButton.setPreferredSize(new Dimension(150, 150));
            if (i == 0) {
                newButton.setText(Internationalization.getLiteralFor((String)"ALL"));
            } else {
                newButton.setText(Internationalization.getLiteralFor((String)"COVER") + " " + i);
            }
            newButton.setModel(new SeatNumberButtonModel(i));
            this.seatButtonGroup.add(newButton);
            this.seatPaneModel.addComponent((Component)newButton);
            if (i != selectedSeat) continue;
            newButton.setSelected(true);
        }
        this.seatPanel.setVisible(true);
    }

    @Override
    public void setSeatPanelVisible(boolean display) {
        this.seatPanel.setVisible(display);
    }

    @Override
    public int getSeat() {
        if (this.seatButtonGroup == null) {
            return 0;
        }
        ButtonModel selectedModel = this.seatButtonGroup.getSelection();
        if (selectedModel != null && selectedModel instanceof SeatNumberButtonModel) {
            return ((SeatNumberButtonModel)this.seatButtonGroup.getSelection()).getSeatNumber();
        }
        return 0;
    }

    @Override
    public void setGroupTextWidth(int textWidth) {
        this.renderer.setGroupTextWidth(textWidth);
    }

    @Override
    public void setItemTextWidth(int textWidth) {
        this.renderer.setItemTextWidth(textWidth);
    }

    public void setScrollName(String string) {
        this.scrollPane.setName(string);
    }

    private class SeatNumberButtonModel
    extends JToggleButton.ToggleButtonModel {
        private int seatNumber;

        public SeatNumberButtonModel(int seat) {
            this.seatNumber = seat;
        }

        public int getSeatNumber() {
            return this.seatNumber;
        }
    }
}

