/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.ordering.additems.selectunit;

import au.com.ordermate.gui.GraphPaperLayout;
import au.com.ordermate.guicore.NameDecorator;
import au.com.ordermate.persistence.Displayable;
import au.com.ordermate.util.Price;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Hashtable;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import ordermate.database.inventory.InventoryItemPortion;
import ordermate.database.inventory.InventoryItemSize;
import ordermate.database.inventory.InventoryItemUnit;
import ordermate.database.inventory.UnitPriceLevel;
import ordermate.database.inventory.triggers.activation.TriggerActivationContext;
import ordermate.database.sales.Account;
import ordermate.database.sales.ItemGroup;
import ordermate.database.stock.StockUtilities;
import ordermate.gui.button.CustomButton;
import ordermate.gui.button.CustomButtonLabelGenerator;
import ordermate.gui.scroll.CustomScrollPane;
import ordermate.gui.scroll.CustomScrollPaneModel;
import ordermate.gui.scroll.DataScrollPaneModel;
import ordermate.gui.themes.OrderMateTheme;
import ordermate.internationalization.Internationalization;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import waitermate.LoginManager;
import waitermate.gui.screens.ordering.additems.selectunit.ItemSizeButtonLabelGenerator;

public class SelectUnitPanel
extends JPanel {
    private DataScrollPaneModel sizes;
    private DataScrollPaneModel portions;
    private CustomScrollPane portionPane;
    private Account currentAccount;
    private List units;
    private Map<InventoryItemSize, InventoryItemUnit> unitSizes;
    private JLabel portionsLabel;
    public final Signal unitSelected = Signals.createSignal(InventoryItemUnit.class, (String)"theUnit");
    private ItemSizeButtonLabelGenerator sizesLabelGenerator = new ItemSizeButtonLabelGenerator();
    private Map<InventoryItemPortion, Map<InventoryItemSize, Price>> priceAdds;

    public SelectUnitPanel() {
        this.setLayout((LayoutManager)new GraphPaperLayout(new Dimension(20, 20)));
        this.setName("PortionSize");
        this.unitSizes = new Hashtable<InventoryItemSize, InventoryItemUnit>();
        this.portions = new DataScrollPaneModel(3, 2);
        this.portions.objectSelected.connect((Object)this, "portionSelected");
        this.portionPane = new CustomScrollPane((CustomScrollPaneModel)this.portions);
        this.portionPane.setEmptyMessage(Internationalization.getLiteralFor((String)"THERE_ARE_NO_PORTIONS_FOR_THIS_ITEM"));
        this.add((Component)new NameDecorator((JComponent)this.portionPane, "portions"), new Rectangle(1, 2, 18, 7));
        this.portionsLabel = new JLabel(Internationalization.getLiteralFor((String)"PORTIONS_COLON"));
        this.portionsLabel.setFont(OrderMateTheme.getMediumFont());
        this.add((Component)this.portionsLabel, new Rectangle(1, 1, 5, 1));
        this.sizes = new DataScrollPaneModel(3, 2);
        CustomScrollPane sizePanel = new CustomScrollPane((CustomScrollPaneModel)this.sizes);
        sizePanel.setEmptyMessage(Internationalization.getLiteralFor((String)"THERE_ARE_NO_SIZES_FOR_THIS_ITEM"));
        this.sizes.objectSelected.connect((Object)this, "sizeSelected");
        this.sizes.setCustomLabelGenerator((CustomButtonLabelGenerator)this.sizesLabelGenerator);
        this.add((Component)new NameDecorator((JComponent)sizePanel, "sizes"), new Rectangle(1, 11, 18, 7));
        JLabel sizesLabel = new JLabel(Internationalization.getLiteralFor((String)"SIZES_COLON"));
        sizesLabel.setFont(OrderMateTheme.getMediumFont());
        this.add((Component)sizesLabel, new Rectangle(1, 10, 5, 1));
    }

    public void setUnits(Account newAccount, List<InventoryItemUnit> newUnits, Map<InventoryItemPortion, Map<InventoryItemSize, Price>> priceAdds) {
        this.units = newUnits;
        this.currentAccount = newAccount;
        LinkedHashSet<InventoryItemPortion> portionSet = new LinkedHashSet<InventoryItemPortion>();
        this.priceAdds = priceAdds;
        TriggerActivationContext triggerContext = new TriggerActivationContext(LoginManager.getEventContext(), new Date(), (ItemGroup)this.currentAccount);
        for (InventoryItemUnit unit : this.units) {
            if (unit.getActiveUnitPriceLevel(triggerContext) == null) continue;
            portionSet.add(unit.getPortion());
        }
        if (portionSet.size() > 1) {
            ArrayList sortedList = new ArrayList(portionSet);
            Collections.sort(sortedList, new PortionComparator());
            this.portions.setItems(sortedList, true);
            InventoryItemPortion firstPortion = (InventoryItemPortion)sortedList.get(0);
            this.portionSelected((Displayable)firstPortion, false);
            this.portionPane.setVisible(true);
            this.portionsLabel.setVisible(true);
        } else {
            if (!portionSet.isEmpty()) {
                InventoryItemPortion firstPortion = (InventoryItemPortion)portionSet.iterator().next();
                this.portionSelected((Displayable)firstPortion);
            }
            this.portionPane.setVisible(false);
            this.portionsLabel.setVisible(false);
        }
    }

    public void setUnits(Account newAccount, List newUnits) {
        this.setUnits(newAccount, newUnits, null);
    }

    public void portionSelected(Displayable selectedPortion) {
        this.portionSelected(selectedPortion, true);
    }

    public void portionSelected(Displayable selectedPortion, boolean autoSelect) {
        this.unitSizes.clear();
        ArrayList<InventoryItemSize> sizesList = new ArrayList<InventoryItemSize>();
        ArrayList<InventoryItemUnit> unitList = new ArrayList<InventoryItemUnit>();
        for (InventoryItemUnit unit : this.units) {
            if (!unit.getPortion().equals((Object)selectedPortion)) continue;
            unitList.add(unit);
        }
        Collections.sort(unitList, new SizeComparator());
        TriggerActivationContext triggerContext = new TriggerActivationContext(LoginManager.getEventContext(), new Date(), (ItemGroup)this.currentAccount);
        for (InventoryItemUnit unit : unitList) {
            if (unit.getActiveUnitPriceLevel(triggerContext) == null) continue;
            sizesList.add(unit.getSize());
            this.unitSizes.put(unit.getSize(), unit);
        }
        this.sizesLabelGenerator.setPriceAdds(this.priceAdds != null ? this.priceAdds.get(selectedPortion) : null);
        this.sizes.setItems(sizesList);
        List sizeButtons = this.sizes.getButtons();
        for (NameDecorator dec : sizeButtons) {
            CustomButton button = (CustomButton)dec.getDecorateComponent();
            InventoryItemSize size = (InventoryItemSize)button.getData();
            InventoryItemUnit unit = this.unitSizes.get(size);
            StockUtilities.setupUnitButton((AbstractButton)button, (InventoryItemUnit)unit);
            if (sizeButtons.size() != 1 || !autoSelect || !button.isEnabled()) continue;
            this.sizeSelected(button.getData());
        }
    }

    public void sizeSelected(Displayable selectedSize) {
        if (!this.unitSizes.containsKey(selectedSize)) {
            throw new IllegalArgumentException("Was passed a size, that was not within the list of possible sizes");
        }
        InventoryItemUnit selectedUnit = this.unitSizes.get(selectedSize);
        this.unitSelected.emit((Object)selectedUnit);
    }

    public void setRowsPerPage(int rows) {
        this.portions.setRowsPerPage(rows);
        this.sizes.setRowsPerPage(rows);
    }

    public void setColumns(int columns) {
        this.portions.setColumns(columns);
        this.sizes.setColumns(columns);
    }

    private class SizeComparator
    implements Comparator<InventoryItemUnit> {
        private SizeComparator() {
        }

        @Override
        public int compare(InventoryItemUnit o1, InventoryItemUnit o2) {
            InventoryItemSize size1 = o1.getSize();
            InventoryItemSize size2 = o2.getSize();
            if (size1.getSequence() != null) {
                if (size2.getSequence() != null) {
                    return size1.getSequence().compareTo(size2.getSequence());
                }
                return -1;
            }
            if (size2.getSequence() != null) {
                return 1;
            }
            TriggerActivationContext triggerContext = new TriggerActivationContext(LoginManager.getEventContext(), new Date(), (ItemGroup)SelectUnitPanel.this.currentAccount);
            UnitPriceLevel level1 = o1.getActiveUnitPriceLevel(triggerContext);
            UnitPriceLevel level2 = o2.getActiveUnitPriceLevel(triggerContext);
            return this.compareByPrice(level1, level2);
        }

        private int compareByPrice(UnitPriceLevel level1, UnitPriceLevel level2) {
            if (level1 != null && level2 != null) {
                Price price1 = level1.getPrice();
                Price price2 = level2.getPrice();
                if (price1 != null && price2 != null) {
                    return price1.compareTo(price2);
                }
                if (price1 != null) {
                    return -1;
                }
                if (price2 != null) {
                    return 1;
                }
                return 0;
            }
            if (level1 != null) {
                return -1;
            }
            if (level2 != null) {
                return 1;
            }
            return 0;
        }
    }

    private static class PortionComparator
    implements Comparator<InventoryItemPortion> {
        private PortionComparator() {
        }

        @Override
        public int compare(InventoryItemPortion o1, InventoryItemPortion o2) {
            int result = new Double(o2.getSize()).compareTo(new Double(o1.getSize()));
            return result;
        }
    }
}

