/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.ordering.coupon;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.List;
import javax.swing.JPanel;
import ordermate.database.sales.coupon.SalesCoupon;
import ordermate.gui.scroll.CustomScrollPane;
import ordermate.gui.scroll.Renderer;
import ordermate.gui.scroll.RendererScrollPaneModel;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import waitermate.gui.screens.ordering.coupon.CouponRenderer;
import waitermate.guikit.dialogs.Dialogs;

public class AvailableCouponsPanel
extends JPanel {
    private CustomScrollPane scrolly;
    private RendererScrollPaneModel<SalesCoupon> model;
    public Signal<SalesCoupon, ?, ?, ?, ?> gotCoupon = Signals.createSignal(SalesCoupon.class, (String)"uniqueId");

    public AvailableCouponsPanel(List<SalesCoupon> coupons) {
        super(new BorderLayout());
        this.model = new RendererScrollPaneModel((Renderer)new SalesCouponRenderer());
        this.model.addObjects(coupons);
        this.scrolly = new CustomScrollPane(this.model);
        this.scrolly.setColumns(1);
        this.add((Component)this.scrolly, "Center");
    }

    public void gotInfo(SalesCoupon coupon) {
        String html = "<html>" + coupon.getInventoryCoupon().getTool().getConditionsHtml() + "</html>";
        Dialogs.displayOkDialog((String)html, (String)(coupon.getInventoryCoupon().getLabel() + " - " + coupon.getUniqueId()));
    }

    public void gotSelection(SalesCoupon coupon) {
        this.gotCoupon.emit((Object)coupon);
    }

    class SalesCouponRenderer
    implements Renderer<CouponRenderer, SalesCoupon> {
        SalesCouponRenderer() {
        }

        public CouponRenderer createComponent() {
            CouponRenderer renderer = new CouponRenderer();
            renderer.info.connect((Object)AvailableCouponsPanel.this, "gotInfo");
            renderer.selection.connect((Object)AvailableCouponsPanel.this, "gotSelection");
            return renderer;
        }

        public void setupComponent(CouponRenderer component, SalesCoupon coupon, int index) {
            component.setCoupon(coupon);
        }
    }
}

