/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.ordering.coupon;

import au.com.ordermate.util.image.IconLoader;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JPanel;
import ordermate.database.sales.coupon.SalesCoupon;
import ordermate.signals.Signal;
import ordermate.signals.Signals;

class CouponRenderer
extends JPanel
implements ActionListener {
    private JButton infoButton;
    private JButton rendererButton;
    private SalesCoupon coupon;
    Signal<SalesCoupon, ?, ?, ?, ?> info = Signals.createSignal(SalesCoupon.class, (String)"coupon");
    Signal<SalesCoupon, ?, ?, ?, ?> selection = Signals.createSignal(SalesCoupon.class, (String)"coupon");

    CouponRenderer() {
        super(new BorderLayout());
        this.setupComponents();
    }

    private void setupComponents() {
        this.infoButton = new JButton(IconLoader.get((String)"/ordermate/images/info.png"));
        this.rendererButton = new JButton("");
        this.infoButton.addActionListener(this);
        this.rendererButton.addActionListener(this);
        this.add((Component)this.infoButton, "East");
        this.add((Component)this.rendererButton, "Center");
    }

    public void setCoupon(SalesCoupon coupon) {
        this.coupon = coupon;
        this.infoButton.setName(coupon.getID() + "-info");
        StringBuilder SB = new StringBuilder("<html><h2>");
        SB.append(coupon.getInventoryCoupon().getLabel()).append("</h2>");
        SB.append("</html>");
        this.rendererButton.setText(SB.toString());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.infoButton) {
            this.info.emit((Object)this.coupon);
        } else if (e.getSource() == this.rendererButton) {
            this.selection.emit((Object)this.coupon);
        }
    }
}

