/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.ordering.coupon;

import au.com.ordermate.guicore.task.Task;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.swing.JComponent;
import ordermate.database.EventContext;
import ordermate.database.integration.coupon.CouponTransaction;
import ordermate.database.integration.coupon.administration.CouponAdministratorRemote;
import ordermate.database.inventory.triggers.activation.TriggerActivationContext;
import ordermate.database.misc.license.LicenseType;
import ordermate.database.misc.license.PersistentLicenseManager;
import ordermate.database.sales.Account;
import ordermate.database.sales.Customer;
import ordermate.database.sales.ItemGroup;
import ordermate.database.sales.coupon.SalesCoupon;
import ordermate.signals.Signal;
import waitermate.LoginManager;
import waitermate.gui.screens.ordering.coupon.AvailableCouponsPanel;
import waitermate.gui.screens.ordering.coupon.CouponComparator;
import waitermate.gui.screens.ordering.coupon.FetchCouponTask;
import waitermate.guikit.ScreenResource;
import waitermate.guikit.dialogs.Dialogs;
import waitermate.guikit.dialogs.PopupWindow;
import waitermate.guikit.dialogs.ProgressDialog;

public class WaiterMateCoupons {
    private final Account account;
    private TriggerActivationContext context;
    private AvailableCouponsPanel avails;
    private PopupWindow window;
    private final boolean active = PersistentLicenseManager.getInstance().getBoolean(LicenseType.CouponsIntegrationEnabled);

    public WaiterMateCoupons(Account yourAccount) {
        this.account = yourAccount;
        this.context = new TriggerActivationContext(LoginManager.getEventContext(), new Date(), (ItemGroup)this.account, this.account.getCustomer());
    }

    public void setCustomer(Customer newCustomer) {
        if (this.active) {
            this.context = new TriggerActivationContext((EventContext)this.context, this.context.getDate(), (ItemGroup)this.context.getAccount(), newCustomer);
        }
    }

    public void gotCoupon(String uniqueId) {
        if (!this.active) {
            Dialogs.displayOkDialog((String)"Coupons are not Licensed at this site.", (String)"Coupons Unlicensed");
            return;
        }
        FetchCouponTask fetchCouponTask = new FetchCouponTask(uniqueId);
        ProgressDialog.doProgressDialog((Task)fetchCouponTask);
        if (fetchCouponTask.getCoupon() == null) {
            StringBuilder SB = new StringBuilder("<html>The coupon of id <b>");
            SB.append(uniqueId).append("</b> is not known at this store.<br><br>If this is a genuine coupon<ul>");
            SB.append("<li>Try to scan again, it might need to be downloaded.</li>");
            SB.append("<li>Check that it has not been revoked.</li>");
            SB.append("<li>Check that is is redeemable at this store</li>");
            SB.append("</ul><html>");
            Dialogs.displayOkDialog((String)"Unknown Coupon", (String)SB.toString());
            return;
        }
        this.gotCoupon(fetchCouponTask.getCoupon());
    }

    public void gotCoupon(SalesCoupon coupon) {
        if (!this.active) {
            Dialogs.displayOkDialog((String)"Coupons are not Licensed at this site.", (String)"Coupons Unlicensed");
            return;
        }
        if (this.avails != null) {
            ScreenResource.stopWindow((JComponent)this.window);
            this.avails.gotCoupon.disconnect((Object)this);
            this.avails = null;
        }
        if (coupon == null) {
            throw new IllegalArgumentException("Cannot pass in a null coupon.");
        }
        CouponAdministratorRemote.getInstance().redeemCoupon(new CouponTransaction(coupon), this.context);
    }

    public void showCustomerCoupons(Customer customer) {
        if (!this.active) {
            return;
        }
        if (customer != null) {
            List coupons = CouponAdministratorRemote.getInstance().getValidCouponsForCustomer(customer);
            Collections.sort(coupons, new CouponComparator());
            if (coupons != null && !coupons.isEmpty()) {
                this.avails = new AvailableCouponsPanel(coupons);
                this.avails.gotCoupon.connect((Object)this, "gotCoupon");
                this.window = Dialogs.createDialog((JComponent)this.avails, (String)"Available Coupons", (String)"OK", (String)"Cancel", (boolean)true, (boolean)false, (boolean)true);
                this.window.start();
            }
        }
    }

    public void showCustomerCoupons() {
        this.showCustomerCoupons(this.account.getCustomer());
    }

    public Signal<Boolean, ?, ?, ?, ?> getRedeemDoneSignal() {
        return CouponAdministratorRemote.getInstance().redeemDone;
    }
}

