/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.ordering.coupon.handlers;

import au.com.ordermate.persistence.Displayable;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import ordermate.database.sales.SalesLineItem;
import ordermate.gui.scroll.CustomScrollPane;
import ordermate.gui.scroll.CustomScrollPaneModel;
import ordermate.gui.scroll.Renderer;
import ordermate.gui.scroll.RendererScrollPaneModel;
import ordermate.gui.scroll.renderer.DisplayableToggleRenderer;
import waitermate.guikit.dialogs.PopupWindow;

public class SelectSalesLineItemDialog<T extends SalesLineItem>
extends PopupWindow {
    private RendererScrollPaneModel itemsModel;
    private CustomScrollPane itemsPanel;
    private List<T> selectedItems = new ArrayList<T>();

    public SelectSalesLineItemDialog(List<? extends SalesLineItem> items, String title) {
        this.setText(title);
        DisplayableToggleRenderer renderer = new DisplayableToggleRenderer();
        renderer.selected.connect((Object)this, "gotItemSelected");
        renderer.deselected.connect((Object)this, "gotItemDeselected");
        this.itemsModel = new RendererScrollPaneModel((Renderer)renderer);
        this.itemsModel.setColumns(4);
        this.itemsModel.setRowsPerPage(5);
        this.itemsModel.setObjects(items);
        this.itemsPanel = new CustomScrollPane((CustomScrollPaneModel)this.itemsModel);
        this.setComponent((JComponent)this.itemsPanel);
    }

    public void gotItemSelected(Displayable item) {
        SalesLineItem selectedItem = (SalesLineItem)item;
        this.selectedItems.add(selectedItem);
    }

    public void gotItemDeselected(Displayable item) {
        SalesLineItem selectedItem = (SalesLineItem)item;
        this.selectedItems.remove(selectedItem);
    }

    public void setCancelText(String text) {
        this.setCancelButtonText(text);
    }

    public List<T> getSelectedItems() {
        return this.selectedItems;
    }
}

