/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.ordering.giftvoucher;

import au.com.ordermate.guicore.task.Task;
import au.com.ordermate.util.DateTimeUtils;
import au.com.ordermate.util.HtmlUtils;
import au.com.ordermate.util.StringUtils;
import au.com.ordermate.util.image.IconLoader;
import java.awt.Component;
import java.util.Date;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import ordermate.database.finance.giftvoucher.GiftVoucher;
import ordermate.database.finance.giftvoucher.VoucherError;
import ordermate.database.integration.giftvoucher.GiftVoucherConfiguration;
import ordermate.database.queries.finance.voucher.VoucherQueries;
import ordermate.internationalization.Internationalization;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import waitermate.WaiterMateInputAdapter;
import waitermate.gui.screens.ordering.giftvoucher.AutoGenerateVoucherTask;
import waitermate.gui.screens.ordering.giftvoucher.FetchVoucherTask;
import waitermate.gui.screens.ordering.giftvoucher.VoucherKeyboardDialog;
import waitermate.guikit.ScreenResource;
import waitermate.guikit.dialogs.Dialogs;
import waitermate.guikit.dialogs.KeyboardDialog;
import waitermate.guikit.dialogs.PopupWindow;
import waitermate.guikit.dialogs.ProgressDialog;

public class VoucherGrabber {
    private KeyboardDialog voucherIdKeypad;
    private final boolean active;
    public static final String HIGHLIGHT_COLOR = "green";
    private GiftVoucher voucher;
    private String voucherId;
    private PopupWindow keyboardDialog;
    public Signal autoCreatePressed = Signals.createSignal();
    private static final String CANNOT_GENERATE = Internationalization.getLiteralFor((String)"CANNOT_GENERATE_VOUCHER");
    private static final String CANNOT_GENERATE_EXPL = Internationalization.getLiteralFor((String)"CANNOT_GENERATE_VOUCHER_EXPL");
    private static final String SELECT_PROVIDER = Internationalization.getLiteralFor((String)"SELECT_VOUCHER_PROVIDER");
    private static final String AUTO_CREATE = Internationalization.getLiteralFor((String)"AUTO_CREATE_VOUCHER");
    private boolean gotScannedInput;
    private VoucherRetrievalResult result;
    boolean canAutoCreate = true;

    public VoucherGrabber(boolean allowAutoCreate) {
        this.canAutoCreate = allowAutoCreate;
        this.active = true;
        this.voucherId = "";
        this.voucherIdKeypad = new VoucherKeyboardDialog(Internationalization.getLiteralFor((String)"VOUCHER_ID") + ":");
        this.autoCreatePressed.connect((Object)this, "gotAutoCreate");
    }

    public GiftVoucher start() {
        this.voucher = null;
        this.voucherId = "";
        if (!this.active) {
            Dialogs.displayOkDialog((String)HtmlUtils.html((String)HtmlUtils.boldColor((String)"Gift vouchers are not Licensed at this site.", (String)HIGHLIGHT_COLOR)), (String)"Vouchers Unlicensed");
            this.result = VoucherRetrievalResult.UNLICENSED;
            return null;
        }
        this.preVoucherRetrieval();
        boolean clickedOk = this.retrieveVoucherId();
        this.postVoucherRetrieval();
        if (!clickedOk && !this.gotScannedInput) {
            this.result = VoucherRetrievalResult.CANCELLED;
            return null;
        }
        if (this.voucher == null && !StringUtils.isEmpty((String)this.voucherId)) {
            this.setGiftVoucher(this.voucherId);
        }
        this.result = this.voucher == null ? VoucherRetrievalResult.FAILED : VoucherRetrievalResult.SUCCESS;
        return this.voucher;
    }

    private void preVoucherRetrieval() {
        this.linkToVoucherScan(true);
        WaiterMateInputAdapter.getInstance().enableInputParsing(false);
    }

    private void postVoucherRetrieval() {
        this.linkToVoucherScan(false);
        WaiterMateInputAdapter.getInstance().enableInputParsing(true);
    }

    public void gotVoucherScanned(String scannedVoucherId) {
        this.gotScannedInput = true;
        ScreenResource.stopWindow((JComponent)((JComponent)this.voucherIdKeypad.getParent().getParent()));
        if (scannedVoucherId != null) {
            this.voucherId = scannedVoucherId.trim();
        }
        this.setGiftVoucher(scannedVoucherId);
        this.result = this.voucher == null ? VoucherRetrievalResult.FAILED : VoucherRetrievalResult.SUCCESS;
    }

    private boolean retrieveVoucherId() {
        this.keyboardDialog = Dialogs.createDialog((JComponent)this.voucherIdKeypad, (String)Internationalization.getLiteralFor((String)"ENTER_THE_VOUCHER_ID"), (String)"OK", (String)"Cancel", (boolean)true, (boolean)true, (boolean)true);
        if (this.canAutoCreate) {
            JButton autoCreate = this.keyboardDialog.getNavBar().constructButton((Icon)IconLoader.get((String)"/waitermate/guikit/images/print.png"), AUTO_CREATE, "autoCreate", this.autoCreatePressed);
            JButton ok = this.keyboardDialog.getNavBar().getOkButton();
            this.keyboardDialog.getNavBar().removeRight((Component)ok);
            this.keyboardDialog.getNavBar().addRight((Component)autoCreate);
            this.keyboardDialog.getNavBar().addRight((Component)ok);
        }
        if (this.keyboardDialog.start()) {
            this.voucherId = this.voucherIdKeypad.getValue();
            if (this.voucherId != null) {
                this.voucherId = this.voucherId.trim();
            }
            this.keyboardDialog = null;
            return true;
        }
        this.keyboardDialog = null;
        return this.voucher != null;
    }

    public String getScannedString() {
        return this.voucherId;
    }

    public boolean wasCancelled() {
        return this.result == VoucherRetrievalResult.CANCELLED;
    }

    private void setGiftVoucher(String voucherId) {
        FetchVoucherTask fetchVoucherTask = new FetchVoucherTask(voucherId);
        ProgressDialog.doProgressDialog((Task)fetchVoucherTask);
        this.voucher = fetchVoucherTask.getGiftVoucher();
        if (this.voucher == null) {
            return;
        }
        Date voucherDate = this.voucher.getExpiryDateTime();
        if (!this.voucher.getTransactions().isEmpty() && voucherDate == null) {
            Dialogs.displayOkDialog((String)"Gift Card Error", (String)("The gift card: " + this.voucher.getUniqueId() + " has NO expiry date /time  or NO transaction records in the system"));
            return;
        }
        Date currentDate = new Date();
        if (voucherDate != null && currentDate.after(voucherDate)) {
            Dialogs.displayOkDialog((String)"Gift Card expired", (String)("The gift card: " + this.voucher.getUniqueId() + " has expired on " + DateTimeUtils.formatDateForDisplay((Date)this.voucher.getExpiryDateTime())));
        }
    }

    private void linkToVoucherScan(boolean connect) {
        if (connect) {
            WaiterMateInputAdapter.getInstance().voucherScanned.connect((Object)this, "gotVoucherScanned");
        } else {
            WaiterMateInputAdapter.getInstance().voucherScanned.disconnect((Object)this);
        }
    }

    void gotAutoCreate() {
        Object selected;
        List providers = VoucherQueries.getActiveAutogenVoucherProviders();
        if (providers.isEmpty()) {
            Dialogs.displayOkDialog((String)CANNOT_GENERATE_EXPL, (String)CANNOT_GENERATE);
        } else if (providers.size() == 1) {
            this.performAutoCreateRequest((GiftVoucherConfiguration)providers.get(0));
        } else if (providers.size() > 1 && (selected = Dialogs.displaySelectionDialog((String)SELECT_PROVIDER, (List)providers)) != null) {
            this.performAutoCreateRequest((GiftVoucherConfiguration)selected);
        }
    }

    private void performAutoCreateRequest(GiftVoucherConfiguration config) {
        this.keyboardDialog.gotCancel();
        AutoGenerateVoucherTask task = new AutoGenerateVoucherTask(config);
        ProgressDialog.doProgressDialog((Task)task);
        if (task.getResponse() != null && task.getResponse().isApproved()) {
            this.voucher = task.getResponse().getVoucher();
        } else if (task.getResponse() != null) {
            String description = task.getResponse().getDescription() != null ? task.getResponse().getDescription() : VoucherError.CANNOT_GENERATE.getExplanation() + " Please try again, or contact OrderMate technical support.";
            Dialogs.displayOkDialog((String)description, (String)task.getResponse().getError().getExplanation());
        }
    }

    private static enum VoucherRetrievalResult {
        SUCCESS,
        FAILED,
        CANCELLED,
        UNLICENSED,
        UNRECOGNISED_ID,
        INVALID_INPUT;

    }
}

