/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.ordering.giftvoucher;

import ordermate.OrderMate;
import ordermate.database.finance.giftvoucher.GiftVoucher;
import ordermate.database.sales.Account;
import ordermate.signals.Signal;
import waitermate.gui.screens.ordering.giftvoucher.VoucherCreator;
import waitermate.gui.screens.ordering.giftvoucher.VoucherGrabber;
import waitermate.gui.screens.ordering.giftvoucher.topup.TopupVoucherScreen;

public class WaiterMateGiftVouchers {
    private final Account account;
    private GiftVoucher voucher;
    private TopupVoucherScreen topupScreen = null;
    private boolean isFullScreen;
    public Signal topupDone;
    public Signal topupCancel;

    public WaiterMateGiftVouchers(Account yourAccount, Signal actionSignal) {
        this(yourAccount, actionSignal, true);
    }

    public WaiterMateGiftVouchers(Account yourAccount, Signal actionSignal, boolean isFullScreen) {
        this.account = yourAccount;
        this.topupDone = actionSignal;
        this.topupCancel = actionSignal;
        this.isFullScreen = isFullScreen;
    }

    public void start() {
        this.grabVoucher();
        this.topUpGiftVoucher(this.voucher);
    }

    private void grabVoucher() {
        VoucherGrabber grabber = new VoucherGrabber(true);
        this.voucher = grabber.start();
        if (grabber.wasCancelled() || this.voucher != null || grabber.getScannedString().isEmpty()) {
            return;
        }
        VoucherCreator creator = new VoucherCreator(grabber.getScannedString());
        this.voucher = creator.start();
        creator.handleResult();
    }

    protected void topUpGiftVoucher(GiftVoucher voucherToTopup) {
        if (voucherToTopup == null) {
            OrderMate.LOG.warn("Failed to grab or create voucher, cannot proceed with purchase / top-up.");
        } else {
            this.topupScreen = new TopupVoucherScreen(voucherToTopup, this.account);
            this.topupScreen.done.connect((Object)this, "gotTopup");
            this.topupScreen.cancel.connect((Object)this, "gotCancelTopup");
            this.topupScreen.display(this.isFullScreen);
        }
    }

    public void gotTopup() {
        this.topupDone.emit();
    }

    public void gotCancelTopup() {
        this.topupCancel.emit();
    }
}

