/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.ordering.giftvoucher.topup;

import au.com.ordermate.gui.GraphPaperLayout;
import au.com.ordermate.util.DateTimeUtils;
import au.com.ordermate.util.HtmlUtils;
import au.com.ordermate.util.Price;
import au.com.ordermate.util.image.IconLoader;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.border.TitledBorder;
import ordermate.database.finance.giftvoucher.GiftVoucher;
import ordermate.database.users.AllPermissions;
import ordermate.gui.keypad.Keypad;
import ordermate.gui.keypad.KeypadModel;
import ordermate.gui.keypad.PriceModel;
import ordermate.gui.modify.security.SecurityDecorator;
import ordermate.gui.modify.security.StandardSecurityDecorator;
import ordermate.gui.themes.OrderMateTheme;
import ordermate.internationalization.Internationalization;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import waitermate.guikit.dialogs.MonthlyCalendarDialog;

class TopupVoucherPanel
extends JPanel
implements ActionListener {
    public static final int PAID_EDIT = 1;
    public static final int TIP_EDIT = 2;
    public static final int TENDERED_EDIT = 3;
    private static int LABEL_START = 0;
    private static int LABEL_WIDTH;
    private static int COMPONENT_START;
    private static int COMPONENT_WIDTH;
    private JToggleButton[] quickTopup;
    private JToggleButton chargeable;
    private JButton expiryDateButton;
    private Keypad keypad;
    private ButtonGroup buttonGroup;
    private JLabel currentValue;
    private JLabel valueDeposited;
    private JLabel total;
    private Price[] preSetTopupPrices;
    private GiftVoucher giftVoucher;
    private Date expiryDate;
    private SecurityDecorator expiryDateDecorator;
    public final Signal<Price, ?, ?, ?, ?> chargeableUpdated = Signals.createSignal(Price.class, (String)"chargeableValue");
    public final Signal<Date, ?, ?, ?, ?> expiryDateUpdate = Signals.createSignal(Date.class, (String)"expiryDate");

    public TopupVoucherPanel(GiftVoucher voucher, Date expiryDefaultDate, Price ... quickTopupPrices) {
        super((LayoutManager)new GraphPaperLayout(new Dimension(25, 22)));
        this.preSetTopupPrices = quickTopupPrices;
        this.giftVoucher = voucher;
        this.expiryDate = expiryDefaultDate;
        this.quickTopup = new JToggleButton[quickTopupPrices.length];
        this.buttonGroup = new ButtonGroup();
        JPanel textPanel = new JPanel((LayoutManager)new GraphPaperLayout(new Dimension(10, 10), 0, 0));
        this.add((Component)textPanel, new Rectangle(1, 0, 11, 20));
        this.setupKeypadPanel();
        this.setupVoucherInfoPanel(textPanel);
        this.setupQuickTopupPanel(textPanel);
        this.setupAmountChargeablePanel(textPanel);
        this.setupExpiryDatePanel(textPanel);
        this.keypad.updated.connect((Object)this, "keypadUpdated");
    }

    private void setupAmountChargeablePanel(JPanel textPanel) {
        JPanel amountChargeableGroupPanel = new JPanel((LayoutManager)new GraphPaperLayout(new Dimension(10, 3), 5, 5));
        amountChargeableGroupPanel.setBorder(new TitledBorder(Internationalization.getLiteralFor((String)"AMOUNT_CHARGEABLE")));
        amountChargeableGroupPanel.add((Component)this.makeLabel("AMOUNT_CHARGEABLE", OrderMateTheme.getMediumFont(), null, null), new Rectangle(LABEL_START, 0, LABEL_WIDTH, 3));
        this.chargeable = new JToggleButton(Internationalization.getLiteralFor((String)"DOLLAR_ZERO_DOT_ZERO"));
        this.chargeable.setName("chargeableButton");
        this.chargeable.setFont(OrderMateTheme.getMediumFont());
        this.chargeable.addActionListener(this);
        this.buttonGroup.add(this.chargeable);
        amountChargeableGroupPanel.add((Component)this.chargeable, new Rectangle(COMPONENT_START, 0, COMPONENT_WIDTH, 3));
        this.add((Component)amountChargeableGroupPanel, new Rectangle(13, 16, 11, 3));
    }

    private void setupVoucherInfoPanel(JPanel textPanel) {
        JPanel voucherInfoPanel = new JPanel((LayoutManager)new GraphPaperLayout(new Dimension(10, 3), 0, 0));
        this.currentValue = this.makeLabel("DOLLAR_ZERO_DOT_ZERO", OrderMateTheme.getSmallFont(), "currentValueLabel", this.giftVoucher.getCachedValue().toString());
        voucherInfoPanel.add((Component)this.makeLabelForComponent("CURRENT_VALUE", OrderMateTheme.getSmallFont(), null, null, this.currentValue), new Rectangle(LABEL_START, 0, LABEL_WIDTH, 1));
        voucherInfoPanel.add((Component)this.currentValue, new Rectangle(COMPONENT_START, 0, COMPONENT_WIDTH, 1));
        this.valueDeposited = this.makeLabel("DOLLAR_ZERO_DOT_ZERO", OrderMateTheme.getSmallFont(), "valueDepositedLabel", null);
        voucherInfoPanel.add((Component)this.makeLabelForComponent("VALUE_DEPOSITED", OrderMateTheme.getSmallFont(), null, null, this.valueDeposited), new Rectangle(LABEL_START, 1, LABEL_WIDTH, 1));
        voucherInfoPanel.add((Component)this.valueDeposited, new Rectangle(COMPONENT_START, 1, COMPONENT_WIDTH, 1));
        this.total = this.makeLabel("DOLLAR_ZERO_DOT_ZERO", OrderMateTheme.getLargeFont(), "totalLabel", null);
        voucherInfoPanel.add((Component)this.makeLabelForComponent("TOTAL", OrderMateTheme.getLargeFont(), null, null, this.total), new Rectangle(LABEL_START, 2, LABEL_WIDTH, 1));
        voucherInfoPanel.add((Component)this.total, new Rectangle(COMPONENT_START, 2, COMPONENT_WIDTH, 1));
        textPanel.add((Component)voucherInfoPanel, new Rectangle(0, 1, 10, 1));
    }

    private JLabel makeLabelForComponent(String literal, Font font, String labelName, String infoText, Component component) {
        JLabel labelForComponent = this.makeLabel(literal, font, labelName, infoText);
        labelForComponent.setLabelFor(component);
        return labelForComponent;
    }

    private JLabel makeLabel(String literal, Font font, String labelName, String infoText) {
        JLabel newLabel = new JLabel(Internationalization.getLiteralFor((String)literal));
        newLabel.setFont(font);
        if (labelName != null) {
            newLabel.setName(labelName);
        }
        if (infoText != null) {
            newLabel.setText(infoText);
        }
        return newLabel;
    }

    private void setupKeypadPanel() {
        JLabel amountLabel = new JLabel(Internationalization.getLiteralFor((String)"AMOUNT") + ":");
        JLabel keypadLabel = new JLabel();
        this.keypad = new Keypad.KeypadBuilder().setOutputLabel(keypadLabel).build();
        this.keypad.setModel((KeypadModel)new PriceModel());
        this.keypad.setRenderer(Keypad.PRICE_RENDERER);
        this.keypad.setFirstPress(true);
        JPanel keypadPanel = new JPanel();
        keypadPanel.setLayout((LayoutManager)new GraphPaperLayout(new Dimension(10, 10)));
        keypadPanel.setBorder(BorderFactory.createTitledBorder(Internationalization.getLiteralFor((String)"VALUE_DEPOSITED")));
        keypadPanel.add((Component)amountLabel, new Rectangle(1, 0, 2, 1));
        keypadPanel.add((Component)keypadLabel, new Rectangle(3, 0, 5, 1));
        keypadPanel.add((Component)this.keypad, new Rectangle(1, 1, 8, 8));
        this.add((Component)keypadPanel, new Rectangle(13, 1, 11, 15));
    }

    private void setupQuickTopupPanel(JPanel textPanel) {
        JPanel quickTopupGroupPanel = new JPanel((LayoutManager)new GraphPaperLayout(new Dimension(5, this.quickTopup.length), 2, 5));
        quickTopupGroupPanel.setBorder(new TitledBorder(Internationalization.getLiteralFor((String)"QUICK_TOPUP")));
        for (int i = 0; i < this.quickTopup.length; ++i) {
            this.addNewTopupBtn(quickTopupGroupPanel, i);
        }
        textPanel.add((Component)quickTopupGroupPanel, new Rectangle(0, 3, 4, this.quickTopup.length));
    }

    private void addNewTopupBtn(JPanel quickTopupGroupPanel, int sequence) {
        this.quickTopup[sequence] = new JToggleButton(Internationalization.getLiteralFor((String)"DOLLAR_ZERO_DOT_ZERO"));
        this.quickTopup[sequence].setName("quickTopup" + sequence + "Button");
        this.quickTopup[sequence].setText(this.preSetTopupPrices[sequence].toString());
        this.quickTopup[sequence].addActionListener(this);
        this.buttonGroup.add(this.quickTopup[sequence]);
        quickTopupGroupPanel.add((Component)this.quickTopup[sequence], new Rectangle(LABEL_START + 1, sequence, COMPONENT_WIDTH, 1));
    }

    public void resetDisplay() {
        this.chargeable.setSelected(true);
        this.keypad.setFirstPress(true);
        this.keypad.setOverwrite(true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() instanceof JToggleButton) {
            this.updateDisplay(new Price(((JToggleButton)e.getSource()).getText()));
        }
    }

    private void updateDisplay(Price price) {
        this.keypad.setValue(price.toString());
        this.keypad.setFirstPress(true);
        this.keypad.setOverwrite(true);
        this.updateInfo(price);
    }

    private void updateInfo(Price price) {
        this.valueDeposited.setText(price.toString());
        this.chargeable.setText(price.toString());
        Price totalValue = new Price(this.currentValue.getText());
        this.total.setText(totalValue.add(price).toString());
    }

    void keypadUpdated() {
        double keypadValue = this.keypad.getValueAsDouble();
        Price tempPrice = new Price(keypadValue);
        this.updateInfo(tempPrice);
        this.chargeableUpdated.emit((Object)tempPrice);
    }

    public Price getChargeableAmount() {
        return new Price(this.chargeable.getText());
    }

    public Date getExpiryDate() {
        return this.expiryDate;
    }

    private void setupExpiryDatePanel(JPanel textPanel) {
        JPanel expiryDateGroupPanel = new JPanel((LayoutManager)new GraphPaperLayout(new Dimension(10, 3), 5, 5));
        expiryDateGroupPanel.setBorder(new TitledBorder(Internationalization.getLiteralFor((String)"EXPIRY_DATE")));
        expiryDateGroupPanel.add((Component)this.makeLabel("EXPIRY_DATE", OrderMateTheme.getMediumFont(), null, null), new Rectangle(LABEL_START, 0, LABEL_WIDTH, 3));
        this.expiryDateButton = new JButton(this.getDisplayExpiryDateString());
        this.expiryDateButton.setName("expiryDateButton");
        this.expiryDateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Date startDate = TopupVoucherPanel.this.expiryDate == null ? new Date() : TopupVoucherPanel.this.expiryDate;
                MonthlyCalendarDialog calendarDialog = new MonthlyCalendarDialog(startDate, Internationalization.getLiteralFor((String)"NO_EXPIRY_DATE"), (Icon)IconLoader.get((String)"/waitermate/images/voucher.png"));
                if (calendarDialog.go()) {
                    TopupVoucherPanel.this.setVoucherExpiryDate(calendarDialog.getSelectedDate());
                }
            }
        });
        this.expiryDateDecorator = new StandardSecurityDecorator((JComponent)this.expiryDateButton, AllPermissions.EDIT_VOUCHER_EXPIRY_DATE);
        expiryDateGroupPanel.add((Component)this.expiryDateDecorator, new Rectangle(COMPONENT_START, 0, COMPONENT_WIDTH, 3));
        this.add((Component)expiryDateGroupPanel, new Rectangle(13, 19, 11, 3));
    }

    private void setVoucherExpiryDate(Date newDate) {
        this.expiryDate = newDate != null ? DateTimeUtils.combineDateAndTime((Date)newDate, (Date)new Date()) : newDate;
        this.expiryDateButton.setText(this.getDisplayExpiryDateString());
        this.expiryDateUpdate.emit((Object)this.expiryDate);
    }

    private String getDisplayExpiryDateString() {
        if (this.getExpiryDate() != null) {
            return DateTimeUtils.getMediumDateFormat().format(this.getExpiryDate());
        }
        return HtmlUtils.html((String)HtmlUtils.boldColor((String)Internationalization.getLiteralFor((String)"DOES_NOT_EXPIRE"), (String)"red"));
    }

    static {
        COMPONENT_START = LABEL_WIDTH = 6;
        COMPONENT_WIDTH = 4;
    }
}

